/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.EnumType;
import org.eclipse.jpt.jpa.core.resource.java.EnumeratedAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class EnumeratedTests
extends JpaJavaResourceModelTestCase {
    public EnumeratedTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEnumerated() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Enumerated"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Enumerated");
            }
        });
    }

    private ICompilationUnit createTestEnumeratedWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Enumerated", "javax.persistence.EnumType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Enumerated(EnumType.ORDINAL)");
            }
        });
    }

    public void testEnumerated() throws Exception {
        ICompilationUnit cu = this.createTestEnumerated();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)attributeResource.getAnnotation("javax.persistence.Enumerated");
        EnumeratedTests.assertNotNull((Object)enumerated);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestEnumeratedWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)attributeResource.getAnnotation("javax.persistence.Enumerated");
        EnumeratedTests.assertEquals((Object)EnumType.ORDINAL, (Object)enumerated.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestEnumerated();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)attributeResource.getAnnotation("javax.persistence.Enumerated");
        enumerated.setValue(EnumType.STRING);
        this.assertSourceContains("@Enumerated(STRING)", cu);
        enumerated.setValue(null);
        this.assertSourceDoesNotContain("@Enumerated(", cu);
        this.assertSourceContains("@Enumerated", cu);
    }
}

