/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class IdClassTests
extends JpaJavaResourceModelTestCase {
    private static final String ID_CLASS_VALUE = "MyClass";

    public IdClassTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestIdClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.IdClass"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@IdClass");
            }
        });
    }

    private ICompilationUnit createTestIdClassWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.IdClass"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@IdClass(MyClass.class)");
            }
        });
    }

    public void testIdClass() throws Exception {
        ICompilationUnit cu = this.createTestIdClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        IdClassAnnotation idClass = (IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass");
        IdClassTests.assertNotNull((Object)idClass);
        IdClassTests.assertNull((Object)idClass.getValue());
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestIdClassWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        IdClassAnnotation idClass = (IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass");
        IdClassTests.assertEquals((String)ID_CLASS_VALUE, (String)idClass.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestIdClassWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        IdClassAnnotation idClass = (IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass");
        IdClassTests.assertEquals((String)ID_CLASS_VALUE, (String)idClass.getValue());
        idClass.setValue("foo");
        IdClassTests.assertEquals((String)"foo", (String)idClass.getValue());
        this.assertSourceContains("@IdClass(foo.class)", cu);
        idClass.setValue(null);
        this.assertSourceDoesNotContain("@IdClass(", cu);
    }

    public void testGetFullyQualifiedClass() throws Exception {
        ICompilationUnit cu = this.createTestIdClassWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        IdClassAnnotation idClass = (IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass");
        IdClassTests.assertNotNull((Object)idClass.getValue());
        IdClassTests.assertEquals((String)ID_CLASS_VALUE, (String)idClass.getFullyQualifiedClassName());
        idClass.setValue("AnnotationTestType");
        IdClassTests.assertEquals((String)"test.AnnotationTestType", (String)idClass.getFullyQualifiedClassName());
        this.assertSourceContains("@IdClass(AnnotationTestType.class)", cu);
    }
}

