/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.TemporalType;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class TemporalTests
extends JpaJavaResourceModelTestCase {
    public TemporalTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestTemporal() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Temporal"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Temporal");
            }
        });
    }

    private ICompilationUnit createTestTemporalWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Temporal", "javax.persistence.TemporalType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Temporal(TemporalType.DATE)");
            }
        });
    }

    public void testTemporal() throws Exception {
        ICompilationUnit cu = this.createTestTemporal();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getAnnotation("javax.persistence.Temporal");
        TemporalTests.assertNotNull((Object)temporal);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestTemporalWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getAnnotation("javax.persistence.Temporal");
        TemporalTests.assertEquals((Object)TemporalType.DATE, (Object)temporal.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestTemporal();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getAnnotation("javax.persistence.Temporal");
        temporal.setValue(TemporalType.TIME);
        this.assertSourceContains("@Temporal(TIME)", cu);
        temporal.setValue(null);
        this.assertSourceDoesNotContain("@Temporal(", cu);
    }
}

