/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.formatter.comment;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.formatter.comment.CommentTestCase;

public class SingleLineTestCase
extends CommentTestCase {
    protected static final String PREFIX = "// ";
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.formatter.comment.SingleLineTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return SingleLineTestCase.buildTestSuite(clazz);
    }

    public SingleLineTestCase(String name) {
        super(name);
    }

    protected int getCommentKind() {
        return 16;
    }

    public void testClearBlankLines1() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "5");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_block_comment", "false");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_javadoc_comment", "false");
        SingleLineTestCase.assertEquals((String)("// test" + DELIMITER + PREFIX + "test" + DELIMITER + PREFIX + "test" + DELIMITER), (String)this.testFormat("//test\ttest" + DELIMITER + "//" + DELIMITER + "//\t\ttest"));
    }

    public void testClearBlankLines2() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "5");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_block_comment", "false");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_javadoc_comment", "false");
        SingleLineTestCase.assertEquals((String)("// test" + DELIMITER + PREFIX + "test" + DELIMITER + PREFIX + "test" + DELIMITER), (String)this.testFormat("//test\t\ttest" + DELIMITER + PREFIX + DELIMITER + "//\t\ttest"));
    }

    public void testClearBlankLines3() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "5");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_block_comment", "false");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_javadoc_comment", "false");
        SingleLineTestCase.assertEquals((String)("// test" + DELIMITER + PREFIX + "test" + DELIMITER + PREFIX + "test" + DELIMITER + PREFIX + "test" + DELIMITER), (String)this.testFormat("//test\ttest" + DELIMITER + "//" + DELIMITER + PREFIX + "test\ttest"));
    }

    public void testCommentBegin1() {
        SingleLineTestCase.assertEquals((String)("// test" + DELIMITER), (String)this.testFormat("//test"));
    }

    public void testCommentBegin2() {
        SingleLineTestCase.assertEquals((String)("// test" + DELIMITER), (String)this.testFormat("// test"));
    }

    public void testCommentBegin3() {
        SingleLineTestCase.assertEquals((String)("// test" + DELIMITER), (String)this.testFormat("//\t\ttest " + DELIMITER));
    }

    public void testCommentDelimiter1() {
        SingleLineTestCase.assertEquals((String)("// test" + DELIMITER), (String)this.testFormat("//\t\ttest " + DELIMITER + DELIMITER));
    }

    public void testCommentDelimiter2() {
        SingleLineTestCase.assertEquals((String)("// test" + DELIMITER), (String)this.testFormat("// test " + DELIMITER + DELIMITER + DELIMITER));
    }

    public void testCommentSpace1() {
        SingleLineTestCase.assertEquals((String)("// test test" + DELIMITER), (String)this.testFormat("//test\t \t test"));
    }

    public void testCommentSpace2() {
        SingleLineTestCase.assertEquals((String)("// test test" + DELIMITER), (String)this.testFormat("//test test"));
    }

    public void testCommentSpace3() {
        SingleLineTestCase.assertEquals((String)("// test test" + DELIMITER), (String)this.testFormat("// test \t    \t test"));
    }

    public void testCommentWrapping1() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "5");
        SingleLineTestCase.assertEquals((String)("// test" + DELIMITER + PREFIX + "test" + DELIMITER), (String)this.testFormat("//test\ttest"));
    }

    public void testCommentWrapping2() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "1");
        SingleLineTestCase.assertEquals((String)("// test" + DELIMITER + PREFIX + "test" + DELIMITER), (String)this.testFormat("//test\ttest"));
    }

    public void testCommentWrapping3() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "32");
        SingleLineTestCase.assertEquals((String)("// test test" + DELIMITER), (String)this.testFormat("//test\ttest"));
    }

    public void testCommentWrapping4() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "32");
        SingleLineTestCase.assertEquals((String)("// test test" + DELIMITER), (String)this.testFormat("//test\ttest" + DELIMITER));
    }

    public void testCommentWrapping5() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        String prefix = "public class Test {" + DELIMITER + "\tint test; // test test test test test test test test test test test test";
        String inputInfix = " ";
        String expectedInfix = String.valueOf(DELIMITER) + "\t\t\t\t" + PREFIX;
        String suffix = "test" + DELIMITER + "}" + DELIMITER;
        String input = String.valueOf(prefix) + inputInfix + suffix;
        int offset = input.indexOf("//");
        SingleLineTestCase.assertEquals((String)(String.valueOf(prefix) + expectedInfix + suffix), (String)this.testFormat(input, offset, input.indexOf(DELIMITER, offset) + DELIMITER.length() - offset));
    }

    public void testHeaderComment1() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.format_header", "false");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "12");
        SingleLineTestCase.assertEquals((String)("// test test" + DELIMITER + PREFIX + "test test" + DELIMITER + PREFIX + "test test" + DELIMITER), (String)this.testFormat("//test\t\t\t\ttest" + DELIMITER + PREFIX + "test test test test"));
    }

    public void testHeaderComment2() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.format_header", "false");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "24");
        SingleLineTestCase.assertEquals((String)("// test test test test" + DELIMITER + PREFIX + "test" + DELIMITER), (String)this.testFormat("//test\t\t\t" + DELIMITER + PREFIX + "test test test test" + DELIMITER));
    }

    public void testIllegalLineLength1() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "1");
        SingleLineTestCase.assertEquals((String)("// test" + DELIMITER + PREFIX + "test" + DELIMITER), (String)this.testFormat("//test\ttest"));
    }

    public void testIllegalLineLength2() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "-16");
        SingleLineTestCase.assertEquals((String)("// test" + DELIMITER + PREFIX + "test" + DELIMITER), (String)this.testFormat("// \t\t test\ttest"));
    }

    public void testMultipleComments1() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "5");
        SingleLineTestCase.assertEquals((String)("// test" + DELIMITER + PREFIX + "test" + DELIMITER + PREFIX + "test" + DELIMITER + PREFIX + "test" + DELIMITER + PREFIX + "test" + DELIMITER + PREFIX + "test" + DELIMITER), (String)this.testFormat("//test test" + DELIMITER + PREFIX + "test test test test"));
    }

    public void testMultipleComments2() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "12");
        SingleLineTestCase.assertEquals((String)("// test test" + DELIMITER + PREFIX + "test test" + DELIMITER + PREFIX + "test test" + DELIMITER + PREFIX + "test" + DELIMITER), (String)this.testFormat("//test test\ttest" + DELIMITER + PREFIX + DELIMITER + PREFIX + "test test test test"));
    }

    public void testMultipleComments3() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "11");
        SingleLineTestCase.assertEquals((String)("// test" + DELIMITER + PREFIX + "test" + DELIMITER + PREFIX + "test" + DELIMITER + PREFIX + "test" + DELIMITER + PREFIX + "test" + DELIMITER + PREFIX + "test" + DELIMITER + PREFIX + "test" + DELIMITER), (String)this.testFormat("//   test\t\t\ttest\ttest" + DELIMITER + PREFIX + "test test test test"));
    }

    public void testIndentedComment1() {
        String prefix = "public class Test {" + DELIMITER + "\t";
        String comment = "// test" + DELIMITER;
        String postfix = "}" + DELIMITER;
        String string = String.valueOf(prefix) + comment + postfix;
        SingleLineTestCase.assertEquals((String)string, (String)this.testFormat(string, prefix.length(), comment.length()));
    }

    public void testIndentedComment2() {
        String prefix = "public class Test {" + DELIMITER + "\tpublic void test() {" + DELIMITER + "\t\t";
        String comment = "// test" + DELIMITER;
        String postfix = "\t}" + DELIMITER + "}" + DELIMITER;
        String string = String.valueOf(prefix) + comment + postfix;
        SingleLineTestCase.assertEquals((String)string, (String)this.testFormat(string, prefix.length(), comment.length()));
    }

    public void testIndentedComment3() {
        String prefix = "public class Test {" + DELIMITER + "\tpublic void test() {" + DELIMITER + "\t\tif (true) {" + DELIMITER + "\t\t\t";
        String comment = "// test" + DELIMITER;
        String postfix = "\t\t}" + DELIMITER + "\t}" + DELIMITER + "}" + DELIMITER;
        String string = String.valueOf(prefix) + comment + postfix;
        SingleLineTestCase.assertEquals((String)string, (String)this.testFormat(string, prefix.length(), comment.length()));
    }

    public void testNoChange1() {
        String content = PREFIX;
        SingleLineTestCase.assertEquals((String)content, (String)this.testFormat(content));
    }

    public void testNoFormat1() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments", "false");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "1");
        String content = "// test test";
        SingleLineTestCase.assertEquals((String)content, (String)this.testFormat(content));
    }

    public void _test109581() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments", "true");
        String content = "//// some comment ////";
        SingleLineTestCase.assertEquals((String)(String.valueOf(content) + DELIMITER), (String)this.testFormat(content));
    }
}

