/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchConstants;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.MethodReferenceMatch;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;

public class AbstractJavaSearchTests
extends AbstractJavaModelTests
implements IJavaScriptSearchConstants {
    public static List JAVA_SEARCH_SUITES = null;
    protected static IJavaScriptProject JAVA_PROJECT;
    protected static boolean COPY_DIRS;
    protected static int EXACT_RULE;
    protected static int EQUIVALENT_RULE;
    protected static int ERASURE_RULE;
    protected static int RAW_RULE;
    protected JavaSearchResultCollector resultCollector;

    static {
        COPY_DIRS = true;
        EXACT_RULE = 8;
        EQUIVALENT_RULE = EXACT_RULE | 0x20;
        ERASURE_RULE = EXACT_RULE | 0x10;
        RAW_RULE = EXACT_RULE | 0x10 | 0x20;
    }

    public AbstractJavaSearchTests(String name) {
        this(name, 2);
    }

    public AbstractJavaSearchTests(String name, int tabs) {
        super(name, tabs);
        this.displayName = true;
    }

    protected void assertSearchResults(String expected) {
        this.assertSearchResults(expected, this.resultCollector);
    }

    protected void assertSearchResults(String expected, JavaSearchResultCollector collector) {
        this.assertSearchResults("Unexpected search results", expected, collector);
    }

    protected void assertSearchResults(String message, String expected, JavaSearchResultCollector collector) {
        String actual = collector.toString();
        if (!expected.equals(actual)) {
            if (this.displayName) {
                System.out.print(this.getName());
                System.out.print(" got ");
                if (collector.count == 0) {
                    System.out.println("no result!");
                } else {
                    System.out.print(collector.count);
                    System.out.print(" result");
                    if (collector.count == 1) {
                        System.out.println(":");
                    } else {
                        System.out.println("s:");
                    }
                }
            }
            if (!this.displayName || collector.count > 0) {
                System.out.print(this.displayString(actual, this.tabs));
                System.out.println(this.endChar);
            }
            if (this.workingCopies != null) {
                int length = this.workingCopies.length;
                String[] sources = new String[length * 2];
                int i = 0;
                while (i < length) {
                    sources[i * 2] = this.workingCopies[i].getPath().toString();
                    try {
                        sources[i * 2 + 1] = this.workingCopies[i].getSource();
                    }
                    catch (JavaScriptModelException javaScriptModelException) {}
                    ++i;
                }
                System.out.println("--------------------------------------------------------------------------------");
                i = 0;
                while (i < length) {
                    System.out.println(sources[i]);
                    System.out.println(sources[i + 1]);
                    i += 2;
                }
            }
        }
        AbstractJavaSearchTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void copyDirectory(File sourceDir, File targetDir) throws IOException {
        if (COPY_DIRS) {
            super.copyDirectory(sourceDir, targetDir);
        } else {
            targetDir.mkdirs();
            File sourceFile = new File(sourceDir, ".project");
            File targetFile = new File(targetDir, ".project");
            targetFile.createNewFile();
            this.copy(sourceFile, targetFile);
            sourceFile = new File(sourceDir, ".classpath");
            targetFile = new File(targetDir, ".classpath");
            targetFile.createNewFile();
            this.copy(sourceFile, targetFile);
        }
    }

    IJavaScriptSearchScope getJavaSearchScope() {
        return SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptProject[]{this.getJavaProject("JSSearch")});
    }

    IJavaScriptSearchScope getJavaSearchScope15() {
        return SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptProject[]{this.getJavaProject("JavaSearch15")});
    }

    IJavaScriptSearchScope getJavaSearchScope15(String packageName, boolean addSubpackages) throws JavaScriptModelException {
        if (packageName == null) {
            return this.getJavaSearchScope15();
        }
        return this.getJavaSearchPackageScope("JavaSearch15", packageName, addSubpackages);
    }

    IJavaScriptSearchScope getJavaSearchPackageScope(String projectName, String packageName, boolean addSubpackages) throws JavaScriptModelException {
        IPackageFragment fragment = this.getPackageFragment(projectName, "src", packageName);
        if (fragment == null) {
            return null;
        }
        IJavaScriptElement[] searchPackages = null;
        if (addSubpackages) {
            ArrayList<Object> packages = new ArrayList<Object>();
            packages.add(fragment);
            IJavaScriptElement[] children = ((IPackageFragmentRoot)fragment.getParent()).getChildren();
            String[] names = ((PackageFragment)fragment).names;
            int namesLength = names.length;
            int i = 0;
            int length = children.length;
            while (i < length) {
                block7: {
                    PackageFragment currentPackage = (PackageFragment)children[i];
                    String[] otherNames = currentPackage.names;
                    if (otherNames.length > namesLength) {
                        int j = 0;
                        while (j < namesLength) {
                            if (names[j].equals(otherNames[j])) {
                                ++j;
                                continue;
                            }
                            break block7;
                        }
                        packages.add(currentPackage);
                    }
                }
                ++i;
            }
            searchPackages = new IJavaScriptElement[packages.size()];
            packages.toArray(searchPackages);
        } else {
            searchPackages = new IJavaScriptElement[]{fragment};
        }
        return SearchEngine.createJavaSearchScope((IJavaScriptElement[])searchPackages);
    }

    IJavaScriptSearchScope getJavaSearchCUScope(String projectName, String packageName, String cuName) throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit(projectName, "src", packageName, cuName);
        return SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptUnit[]{cu});
    }

    protected void search(IJavaScriptElement element, int limitTo, IJavaScriptSearchScope scope) throws CoreException {
        this.search(element, limitTo, EXACT_RULE, scope, (SearchRequestor)this.resultCollector);
    }

    IJavaScriptSearchScope getJavaSearchWorkingCopiesScope(IJavaScriptUnit workingCopy) throws JavaScriptModelException {
        return SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptUnit[]{workingCopy});
    }

    IJavaScriptSearchScope getJavaSearchWorkingCopiesScope() throws JavaScriptModelException {
        return SearchEngine.createJavaSearchScope((IJavaScriptElement[])this.workingCopies);
    }

    protected void search(IJavaScriptElement element, int limitTo, int matchRule, IJavaScriptSearchScope scope) throws CoreException {
        this.search(element, limitTo, matchRule, scope, (SearchRequestor)this.resultCollector);
    }

    protected void search(IJavaScriptElement element, int limitTo, int matchRule, IJavaScriptSearchScope scope, SearchRequestor requestor) throws CoreException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaScriptElement)element, (int)limitTo, (int)matchRule);
        AbstractJavaSearchTests.assertNotNull((String)"Pattern should not be null", (Object)pattern);
        new SearchEngine(this.workingCopies).search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    protected void search(SearchPattern searchPattern, IJavaScriptSearchScope scope, SearchRequestor requestor) throws CoreException {
        new SearchEngine().search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    protected void search(String patternString, int searchFor, int limitTo, IJavaScriptSearchScope scope) throws CoreException {
        this.search(patternString, searchFor, limitTo, EXACT_RULE, scope, this.resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule, IJavaScriptSearchScope scope) throws CoreException {
        this.search(patternString, searchFor, limitTo, matchRule, scope, this.resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule, IJavaScriptSearchScope scope, SearchRequestor requestor) throws CoreException {
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule);
        AbstractJavaSearchTests.assertNotNull((String)"Pattern should not be null", (Object)pattern);
        new SearchEngine(this.workingCopies).search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    protected void searchDeclarationsOfAccessedFields(IJavaScriptElement enclosingElement, SearchRequestor requestor) throws JavaScriptModelException {
        new SearchEngine().searchDeclarationsOfAccessedFields(enclosingElement, requestor, null);
    }

    protected void searchDeclarationsOfReferencedTypes(IJavaScriptElement enclosingElement, SearchRequestor requestor) throws JavaScriptModelException {
        new SearchEngine().searchDeclarationsOfReferencedTypes(enclosingElement, requestor, null);
    }

    protected void searchDeclarationsOfSentMessages(IJavaScriptElement enclosingElement, SearchRequestor requestor) throws JavaScriptModelException {
        new SearchEngine().searchDeclarationsOfSentMessages(enclosingElement, requestor, null);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resultCollector = new JavaSearchResultCollector();
    }

    public static class JavaSearchResultCollector
    extends SearchRequestor {
        protected SearchMatch match;
        public StringBuffer results = new StringBuffer();
        public StringBuffer line;
        public boolean showAccuracy;
        public boolean showContext;
        public boolean showRule;
        public boolean showInsideDoc;
        public boolean showPotential = true;
        public boolean showProject;
        public boolean showSynthetic;
        public int showFlavors = 0;
        public int count = 0;

        public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
            ++this.count;
            this.match = searchMatch;
            this.writeLine();
            if (this.line != null) {
                this.writeLineToResult();
            }
        }

        protected void writeLineToResult() {
            if (this.match.getAccuracy() == 0 || this.showPotential) {
                if (this.results.length() > 0) {
                    this.results.append("\n");
                }
                this.results.append(this.line);
            }
        }

        protected void writeLine() throws CoreException {
            try {
                MethodReferenceMatch methRef;
                IResource resource = this.match.getResource();
                IJavaScriptElement element = this.getElement(this.match);
                this.line = new StringBuffer(this.getPathString(resource, element));
                if (this.showProject) {
                    IProject project = element.getJavaScriptProject().getProject();
                    this.line.append(" [in ");
                    this.line.append(project.getName());
                    this.line.append("]");
                }
                IJavaScriptUnit unit = null;
                if (element instanceof IFunction) {
                    this.line.append(" ");
                    IFunction method = (IFunction)element;
                    this.append(method);
                    unit = method.getJavaScriptUnit();
                } else if (element instanceof IType) {
                    this.line.append(" ");
                    IType type = (IType)element;
                    this.append(type);
                    unit = type.getJavaScriptUnit();
                } else if (element instanceof IField) {
                    this.line.append(" ");
                    IField field = (IField)element;
                    this.append(field);
                    unit = field.getJavaScriptUnit();
                } else if (element instanceof IInitializer) {
                    this.line.append(" ");
                    IInitializer initializer = (IInitializer)element;
                    this.append(initializer);
                    unit = initializer.getJavaScriptUnit();
                } else if (element instanceof IPackageFragment) {
                    this.line.append(" ");
                    this.append((IPackageFragment)element);
                } else if (element instanceof ILocalVariable) {
                    this.line.append(" ");
                    ILocalVariable localVar = (ILocalVariable)element;
                    IJavaScriptElement parent = localVar.getParent();
                    if (parent instanceof IInitializer) {
                        IInitializer initializer = (IInitializer)parent;
                        this.append(initializer);
                        this.line.append(".");
                    } else if (parent instanceof IFunction) {
                        IFunction method = (IFunction)parent;
                        this.append(method);
                        this.line.append(".");
                    }
                    this.line.append(localVar.getElementName());
                    unit = (IJavaScriptUnit)localVar.getAncestor(5);
                } else if (element instanceof IImportDeclaration) {
                    IImportDeclaration importDeclaration = (IImportDeclaration)element;
                    unit = (IJavaScriptUnit)importDeclaration.getAncestor(5);
                }
                if (resource instanceof IFile) {
                    char[] contents = this.getSource(resource, element, unit);
                    int start = this.match.getOffset();
                    int end = start + this.match.getLength();
                    if (start == -1 || contents != null && contents.length > 0) {
                        this.line.append(" [");
                        if (start > -1) {
                            if (this.showContext) {
                                int lineStart1 = CharOperation.lastIndexOf((char)'\n', (char[])contents, (int)0, (int)start);
                                int lineStart2 = CharOperation.lastIndexOf((char)'\r', (char[])contents, (int)0, (int)start);
                                int lineStart = Math.max(lineStart1, lineStart2) + 1;
                                this.line.append(CharOperation.subarray((char[])contents, (int)lineStart, (int)start));
                                this.line.append("<");
                            }
                            this.line.append(CharOperation.subarray((char[])contents, (int)start, (int)end));
                            if (this.showContext) {
                                int lineEnd;
                                this.line.append(">");
                                int lineEnd1 = CharOperation.indexOf((char)'\n', (char[])contents, (int)end);
                                int lineEnd2 = CharOperation.indexOf((char)'\r', (char[])contents, (int)end);
                                int n = lineEnd = lineEnd1 > 0 && lineEnd2 > 0 ? Math.min(lineEnd1, lineEnd2) : Math.max(lineEnd1, lineEnd2);
                                if (lineEnd == -1) {
                                    lineEnd = contents.length;
                                }
                                this.line.append(CharOperation.subarray((char[])contents, (int)end, (int)lineEnd));
                            }
                        } else {
                            this.line.append("No source");
                        }
                        this.line.append("]");
                    }
                }
                if (this.showAccuracy) {
                    this.line.append(" ");
                    if (this.match.getAccuracy() == 0) {
                        if (this.showRule) {
                            if (this.match.isExact()) {
                                this.line.append("EXACT_");
                            } else if (this.match.isEquivalent()) {
                                this.line.append("EQUIVALENT_");
                            } else if (this.match.isErasure()) {
                                this.line.append("ERASURE_");
                            } else {
                                this.line.append("INVALID_RULE_");
                            }
                            if (this.match.isRaw()) {
                                this.line.append("RAW_");
                            }
                        } else {
                            this.line.append("EXACT_");
                        }
                        this.line.append("MATCH");
                    } else {
                        this.line.append("POTENTIAL_MATCH");
                    }
                }
                if (this.showInsideDoc) {
                    this.line.append(" ");
                    if (this.match.isInsideDocComment()) {
                        this.line.append("INSIDE_JAVADOC");
                    } else {
                        this.line.append("OUTSIDE_JAVADOC");
                    }
                }
                if (this.showSynthetic && this.match instanceof MethodReferenceMatch) {
                    MethodReferenceMatch cfr_ignored_0 = (MethodReferenceMatch)this.match;
                }
                if (this.showFlavors > 0 && this.match instanceof MethodReferenceMatch && (methRef = (MethodReferenceMatch)this.match).isSuperInvocation() && this.showSuperInvocation()) {
                    this.line.append(" SUPER INVOCATION");
                }
            }
            catch (JavaScriptModelException e) {
                this.results.append("\n");
                this.results.append(e.toString());
            }
        }

        private boolean showSuperInvocation() {
            return (this.showFlavors & 0x200) != 0;
        }

        protected void append(IField field) throws JavaScriptModelException {
            this.append(field.getDeclaringType());
            this.line.append(".");
            this.line.append(field.getElementName());
        }

        private void append(IInitializer initializer) throws JavaScriptModelException {
            this.append(initializer.getDeclaringType());
            this.line.append(".");
            if (Flags.isStatic((int)initializer.getFlags())) {
                this.line.append("static ");
            }
            this.line.append("{}");
        }

        private void append(IFunction method) throws JavaScriptModelException {
            if (!method.isConstructor() && method.getReturnType() != null) {
                this.line.append(Signature.toString((String)method.getReturnType()));
                this.line.append(" ");
            }
            if (method.getDeclaringType() != null) {
                this.append(method.getDeclaringType());
                this.line.append(".");
            }
            if (!method.isConstructor()) {
                this.line.append(method.getElementName());
            }
            this.line.append("(");
            String[] parameters = method.getParameterTypes();
            boolean varargs = Flags.isVarargs((int)method.getFlags());
            int i = 0;
            int length = parameters.length;
            while (i < length) {
                if (i < length - 1) {
                    this.line.append(Signature.toString((String)parameters[i]));
                    this.line.append(", ");
                } else if (varargs) {
                    String parameter = parameters[i].substring(1);
                    this.line.append(Signature.toString((String)parameter));
                    this.line.append(" ...");
                } else {
                    this.line.append(Signature.toString((String)parameters[i]));
                }
                ++i;
            }
            this.line.append(")");
        }

        private void append(IPackageFragment pkg) {
            this.line.append(pkg.getElementName());
        }

        private void append(IType type) throws JavaScriptModelException {
            String typeName;
            IJavaScriptElement parent = type.getParent();
            boolean isLocal = false;
            switch (parent.getElementType()) {
                case 5: {
                    IPackageFragment pkg = type.getPackageFragment();
                    this.append(pkg);
                    if (pkg.getElementName().equals("")) break;
                    this.line.append(".");
                    break;
                }
                case 6: {
                    IType declaringType = type.getDeclaringType();
                    if (declaringType != null) {
                        this.append(type.getDeclaringType());
                        this.line.append("$");
                        break;
                    }
                    IPackageFragment pkg = type.getPackageFragment();
                    this.append(pkg);
                    if (pkg.getElementName().equals("")) break;
                    this.line.append(".");
                    break;
                }
                case 7: {
                    this.append((IType)parent);
                    this.line.append("$");
                    break;
                }
                case 8: {
                    this.append((IField)parent);
                    isLocal = true;
                    break;
                }
                case 10: {
                    this.append((IInitializer)parent);
                    isLocal = true;
                    break;
                }
                case 9: {
                    this.append((IFunction)parent);
                    isLocal = true;
                }
            }
            if (isLocal) {
                this.line.append(":");
            }
            if ((typeName = type.getElementName()).length() == 0) {
                this.line.append("<anonymous>");
            } else {
                this.line.append(typeName);
            }
            if (isLocal) {
                this.line.append("#");
                this.line.append(((SourceRefElement)type).occurrenceCount);
            }
        }

        protected IJavaScriptElement getElement(SearchMatch searchMatch) {
            return (IJavaScriptElement)searchMatch.getElement();
        }

        protected String getPathString(IResource resource, IJavaScriptElement element) {
            String pathString;
            if (resource != null) {
                IPath path = resource.getProjectRelativePath();
                if (path.segmentCount() == 0) {
                    IPackageFragmentRoot pkgFragmentRoot;
                    IJavaScriptElement root = element;
                    while (root != null && !(root instanceof IPackageFragmentRoot)) {
                        root = root.getParent();
                    }
                    pathString = root != null ? ((pkgFragmentRoot = (IPackageFragmentRoot)root).isExternal() ? pkgFragmentRoot.getPath().toOSString() : pkgFragmentRoot.getPath().toString()) : "";
                } else {
                    pathString = path.toString();
                }
            } else {
                pathString = element.getPath().toString();
            }
            return pathString;
        }

        protected char[] getSource(IResource resource, IJavaScriptElement element, IJavaScriptUnit unit) throws CoreException {
            char[] contents = CharOperation.NO_CHAR;
            if ("js".equals(resource.getFileExtension())) {
                IJavaScriptUnit cu = (IJavaScriptUnit)element.getAncestor(5);
                if (cu != null && cu.isWorkingCopy()) {
                    contents = unit.getBuffer().getCharacters();
                } else {
                    IFile file = (IFile)resource;
                    try {
                        contents = new CompilationUnit(null, file.getLocation().toFile().getPath(), file.getCharset()).getContents();
                    }
                    catch (AbortCompilationUnit abortCompilationUnit) {}
                }
            }
            return contents;
        }

        public String toString() {
            return this.results.toString();
        }
    }

    static class TypeNameMatchCollector
    extends TypeNameMatchRequestor {
        List matches = new ArrayList();

        TypeNameMatchCollector() {
        }

        public void acceptTypeNameMatch(TypeNameMatch match) {
            IType type = match.getType();
            if (type != null) {
                this.matches.add(type);
            }
        }

        public int size() {
            return this.matches.size();
        }

        private String toString(int kind) {
            int size = this.size();
            if (size == 0) {
                return "";
            }
            Object[] strings = new String[size];
            int i = 0;
            while (i < size) {
                IType type = (IType)this.matches.get(i);
                switch (kind) {
                    case 1: {
                        strings[i] = type.getFullyQualifiedName();
                        break;
                    }
                    default: {
                        strings[i] = type.toString();
                    }
                }
                ++i;
            }
            Arrays.sort(strings);
            StringBuffer buffer = new StringBuffer();
            int i2 = 0;
            while (i2 < size) {
                if (i2 > 0) {
                    buffer.append('\n');
                }
                buffer.append((String)strings[i2]);
                ++i2;
            }
            return buffer.toString();
        }

        public String toString() {
            return this.toString(0);
        }

        public String toFullyQualifiedNamesString() {
            return this.toString(1);
        }
    }
}

