/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.eclipselink.core.JptJpaEclipseLinkCorePlugin;
import org.eclipse.jpt.jpa.eclipselink.core.internal.operations.EclipseLinkOrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class EclipseLinkJpaProjectTests
extends EclipseLinkContextModelTestCase {
    public EclipseLinkJpaProjectTests(String name) {
        super(name);
    }

    protected IDataModel buildJpaConfigDataModel() {
        IDataModel dataModel = super.buildJpaConfigDataModel();
        dataModel.setProperty("JpaFacetInstallDataModelProperties.CREATE_ORM_XML", (Object)Boolean.FALSE);
        return dataModel;
    }

    public void testGetDefaultOrmXmlResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFileWithEclipseLinkContentType();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLinkJpaProjectTests.assertNotNull((Object)resource);
        EclipseLinkJpaProjectTests.assertEquals((Object)JptJpaEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLinkJpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFile();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLinkJpaProjectTests.assertNotNull((Object)resource);
        EclipseLinkJpaProjectTests.assertEquals((Object)JptJpaCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLinkJpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    public void testGetDefaultEclipseLinkOrmXmlResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
        this.createDefaultEclipseLinkOrmXmlFile();
        resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLinkJpaProjectTests.assertNotNull((Object)resource);
        EclipseLinkJpaProjectTests.assertEquals((Object)JptJpaEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLinkJpaProjectTests.assertEquals((String)"src/META-INF/eclipselink-orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
    }

    private void createDefaultOrmXmlFile() throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new OrmFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getJpaProject().getProject().getFolder("src/META-INF").getFullPath());
        config.getDefaultOperation().execute(null, null);
    }

    private void createDefaultOrmXmlFileWithEclipseLinkContentType() throws Exception {
        this.createEclipseLinkOrmXmlFile(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.lastSegment());
    }

    private void createDefaultEclipseLinkOrmXmlFile() throws Exception {
        this.createEclipseLinkOrmXmlFile(JptJpaEclipseLinkCorePlugin.DEFAULT_ECLIPSELINK_ORM_XML_RUNTIME_PATH.lastSegment());
    }

    private void createEclipseLinkOrmXmlFile(String fileName) throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new EclipseLinkOrmFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getJpaProject().getProject().getFolder("src/META-INF").getFullPath());
        config.setProperty("JptFileCreationDataModelProperties.FILE_NAME", (Object)fileName);
        config.getDefaultOperation().execute(null, null);
    }

    public void testGetMappingFileResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getMappingFileXmlResource(JptJpaEclipseLinkCorePlugin.DEFAULT_ECLIPSELINK_ORM_XML_RUNTIME_PATH);
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
        this.createDefaultEclipseLinkOrmXmlFile();
        resource = this.getJpaProject().getMappingFileXmlResource(JptJpaEclipseLinkCorePlugin.DEFAULT_ECLIPSELINK_ORM_XML_RUNTIME_PATH);
        EclipseLinkJpaProjectTests.assertNotNull((Object)resource);
        EclipseLinkJpaProjectTests.assertEquals((Object)JptJpaEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLinkJpaProjectTests.assertEquals((String)"src/META-INF/eclipselink-orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource(JptJpaEclipseLinkCorePlugin.DEFAULT_ECLIPSELINK_ORM_XML_RUNTIME_PATH);
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
    }

    public void testGetDifferentlyNamedMappingFileResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
        this.createEclipseLinkOrmXmlFile("orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        EclipseLinkJpaProjectTests.assertNotNull((Object)resource);
        EclipseLinkJpaProjectTests.assertEquals((Object)JptJpaEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLinkJpaProjectTests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
        this.createEclipseLinkOrmXmlFile("orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        EclipseLinkJpaProjectTests.assertNotNull((Object)resource);
        EclipseLinkJpaProjectTests.assertEquals((Object)JptJpaEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLinkJpaProjectTests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }
}

