/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetch;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkOneToOneMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkPrivateOwned;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkJoinFetchAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.JoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaOneToOneMappingTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithPrivateOwnedOneToOne() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "org.eclipse.persistence.annotations.PrivateOwned"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
                sb.append("@PrivateOwned").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithJoinFetchOneToOne() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "org.eclipse.persistence.annotations.JoinFetch"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
                sb.append("@JoinFetch").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithDefaultOneToOne() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("implements java.io.Serializable");
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("private AnnotationTestType myType;").append(CR);
                sb.append(CR);
            }
        });
    }

    public EclipseLinkJavaOneToOneMappingTests(String name) {
        super(name);
    }

    public void testGetPrivateOwned() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        EclipseLinkPrivateOwned privateOwnable = oneToOneMapping.getPrivateOwned();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testSetPrivateOwned() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        EclipseLinkPrivateOwned privateOwnable = oneToOneMapping.getPrivateOwned();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
        privateOwnable.setPrivateOwned(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.PrivateOwned"));
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)false, (boolean)privateOwnable.isPrivateOwned());
        privateOwnable.setPrivateOwned(true);
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.PrivateOwned"));
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testPrivateOwnedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        EclipseLinkPrivateOwned privateOwnable = oneToOneMapping.getPrivateOwned();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.PrivateOwned");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)false, (boolean)privateOwnable.isPrivateOwned());
        attributeResource.addAnnotation("org.eclipse.persistence.annotations.PrivateOwned");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testGetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getMapping();
        EclipseLinkJoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJoinFetchAnnotation joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(JoinFetchType.INNER);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(JoinFetchType.OUTER);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)contextJoinFetch.getValue());
    }

    public void testSetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getMapping();
        EclipseLinkJoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJoinFetchAnnotation joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.INNER);
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(null);
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.JoinFetch"));
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.INNER);
        joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
    }

    public void testDefaultOneToOne() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"basic", (String)((JavaPersistentAttribute)attributes.next()).getDefaultMappingKey());
    }

    public void testDefaultOneToOneSetFetch() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.setSpecifiedFetch(FetchType.LAZY);
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)specifiedOneToOneMapping.getFetch());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY, (Object)annotation.getFetch());
    }

    public void testDefaultOneToOneSetTargetEntity() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.setSpecifiedTargetEntity("Foo");
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"Foo", (String)specifiedOneToOneMapping.getSpecifiedTargetEntity());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"Foo", (String)annotation.getTargetEntity());
    }

    public void testDefaultOneToOneSetMappedBy() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("Foo");
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"Foo", (String)specifiedOneToOneMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"Foo", (String)annotation.getMappedBy());
    }

    public void testDefaultOneToOneSetCascadeAll() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.getCascade().setAll(true);
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToOneMapping.getCascade().isAll());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeAll());
    }

    public void testDefaultOneToOneSetCascadeMerge() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.getCascade().setMerge(true);
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToOneMapping.getCascade().isMerge());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeMerge());
    }

    public void testDefaultOneToOneSetCascadePersist() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.getCascade().setPersist(true);
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToOneMapping.getCascade().isPersist());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadePersist());
    }

    public void testDefaultOneToOneSetCascadeRefresh() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.getCascade().setRefresh(true);
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToOneMapping.getCascade().isRefresh());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeRefresh());
    }

    public void testDefaultOneToOneSetCascadeRemove() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.getCascade().setRemove(true);
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToOneMapping.getCascade().isRemove());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeRemove());
    }
}

