/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.Cascade;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmCascade;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkOneToManyMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkManyToManyMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlManyToMany;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;

public class EclipseLinkOrmManyToManyMappingTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmManyToManyMappingTests(String name) {
        super(name);
    }

    private void createTestDepartment() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("import java.util.Collection;");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.ManyToMany").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.JoinTable").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.JoinColumn").append(";");
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Department").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    @JoinTable(name=\"DEP_EMP\", joinColumns=@JoinColumn(name=\"DEPT_ID\"), inverseJoinColumns=@JoinColumn(name=\"EMP_ID\"))").append(CR);
                sb.append("    private Collection<Employee> employees;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Department.java", sourceWriter);
    }

    private void createTestEmployee() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Employee").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int empId;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Employee.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.FetchType", "javax.persistence.CascadeType", "javax.persistence.OrderBy", "org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany(fetch=FetchType.EAGER, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH})");
                sb.append(CR);
                sb.append("    @OrderBy(\"city\"");
                sb.append(CR);
                sb.append("    @JoinFetch(JoinFetchType.INNER)");
                sb.append(CR);
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    public void testUpdateJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToMany");
        EclipseLinkRelationshipMapping contextManyToMany = (EclipseLinkRelationshipMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlManyToMany resourceManyToMany = (XmlManyToMany)resourceEntity.getAttributes().getManyToManys().get(0);
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)contextManyToMany.getJoinFetch().getValue());
        resourceManyToMany.setJoinFetch(XmlJoinFetchType.INNER);
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextManyToMany.getJoinFetch().getValue());
        resourceManyToMany.setJoinFetch(XmlJoinFetchType.OUTER);
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextManyToMany.getJoinFetch().getValue());
        resourceManyToMany.setJoinFetch(null);
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)contextManyToMany.getJoinFetch().getValue());
    }

    public void testModifyJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToMany");
        EclipseLinkRelationshipMapping contextManyToMany = (EclipseLinkRelationshipMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlManyToMany resourceManyToMany = (XmlManyToMany)resourceEntity.getAttributes().getManyToManys().get(0);
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)contextManyToMany.getJoinFetch().getValue());
        contextManyToMany.getJoinFetch().setValue(EclipseLinkJoinFetchType.INNER);
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextManyToMany.getJoinFetch().getValue());
        contextManyToMany.getJoinFetch().setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextManyToMany.getJoinFetch().getValue());
        contextManyToMany.getJoinFetch().setValue(null);
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)contextManyToMany.getJoinFetch().getValue());
    }

    public void testJoinFetchDefault() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.getEntityMappings().addPersistentType("entity", "test.Department");
        this.getEntityMappings().addPersistentType("entity", "test.Employee");
        OrmPersistentType departmentPersistentType = (OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next();
        EclipseLinkRelationshipMapping manyToMany = (EclipseLinkRelationshipMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)manyToMany.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        EclipseLinkOneToManyMapping oneToMany = (EclipseLinkOneToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)oneToMany.getJoinFetch().getValue());
        EclipseLinkRelationshipMapping javaRelationshipMapping = (EclipseLinkRelationshipMapping)departmentPersistentType.getJavaPersistentType().getAttributeNamed("employees").getMapping();
        javaRelationshipMapping.getJoinFetch().setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)oneToMany.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        manyToMany = (EclipseLinkRelationshipMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)manyToMany.getJoinFetch().getValue());
    }

    public void testDefaultJoinTable() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.getEntityMappings().addPersistentType("entity", "test.Department");
        this.getEntityMappings().addPersistentType("entity", "test.Employee");
        OrmPersistentType departmentPersistentType = (OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next();
        OrmReadOnlyPersistentAttribute attribute = departmentPersistentType.getAttributeNamed("employees");
        ManyToManyMapping manyToMany = (ManyToManyMapping)attribute.getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)attribute.isVirtual());
        JoinTable ormJoinTable = manyToMany.getRelationship().getJoinTableStrategy().getJoinTable();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"DEP_EMP", (String)ormJoinTable.getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"DEPT_ID", (String)((JoinColumn)ormJoinTable.specifiedJoinColumns().next()).getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"id", (String)((JoinColumn)ormJoinTable.specifiedJoinColumns().next()).getReferencedColumnName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"EMP_ID", (String)((JoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"empId", (String)((JoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getReferencedColumnName());
        departmentPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        departmentPersistentType.addSpecifiedAttribute("id", "id");
        attribute = departmentPersistentType.getAttributeNamed("employees");
        OneToManyMapping oneToMany = (OneToManyMapping)attribute.getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)attribute.isVirtual());
        ormJoinTable = oneToMany.getRelationship().getJoinTableStrategy().getJoinTable();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"Department_Employee", (String)ormJoinTable.getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"Department_id", (String)ormJoinTable.getDefaultJoinColumn().getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"id", (String)ormJoinTable.getDefaultJoinColumn().getReferencedColumnName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"employees_empId", (String)ormJoinTable.getDefaultInverseJoinColumn().getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"empId", (String)ormJoinTable.getDefaultInverseJoinColumn().getReferencedColumnName());
        departmentPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.FALSE);
        attribute = departmentPersistentType.getAttributeNamed("employees");
        manyToMany = (ManyToManyMapping)attribute.getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)attribute.isVirtual());
        ormJoinTable = manyToMany.getRelationship().getJoinTableStrategy().getJoinTable();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"DEP_EMP", (String)ormJoinTable.getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"DEPT_ID", (String)((JoinColumn)ormJoinTable.specifiedJoinColumns().next()).getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"id", (String)((JoinColumn)ormJoinTable.specifiedJoinColumns().next()).getReferencedColumnName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"EMP_ID", (String)((JoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"empId", (String)((JoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getReferencedColumnName());
        departmentPersistentType.addSpecifiedAttribute("manyToMany", "employees");
        attribute = departmentPersistentType.getAttributeNamed("employees");
        manyToMany = (ManyToManyMapping)attribute.getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)attribute.isVirtual());
        ormJoinTable = manyToMany.getRelationship().getJoinTableStrategy().getJoinTable();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"Department_Employee", (String)ormJoinTable.getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((int)0, (int)ormJoinTable.specifiedJoinColumnsSize());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"Department_id", (String)ormJoinTable.getDefaultJoinColumn().getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"id", (String)ormJoinTable.getDefaultJoinColumn().getReferencedColumnName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((int)0, (int)ormJoinTable.specifiedInverseJoinColumnsSize());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"employees_empId", (String)ormJoinTable.getDefaultInverseJoinColumn().getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"empId", (String)ormJoinTable.getDefaultInverseJoinColumn().getReferencedColumnName());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityManyToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLinkOrmManyToManyMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)virtualPersistentAttribute.getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"address", (String)virtualManyToManyMapping.getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)virtualManyToManyMapping.getSpecifiedFetch());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"Address", (String)virtualManyToManyMapping.getSpecifiedTargetEntity());
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)virtualManyToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        Cascade cascade = virtualManyToManyMapping.getCascade();
        EclipseLinkOrmManyToManyMappingTests.assertTrue((boolean)cascade.isAll());
        EclipseLinkOrmManyToManyMappingTests.assertTrue((boolean)cascade.isMerge());
        EclipseLinkOrmManyToManyMappingTests.assertTrue((boolean)cascade.isPersist());
        EclipseLinkOrmManyToManyMappingTests.assertTrue((boolean)cascade.isRemove());
        EclipseLinkOrmManyToManyMappingTests.assertTrue((boolean)cascade.isRefresh());
        EclipseLinkOrmManyToManyMappingTests.assertTrue((boolean)virtualManyToManyMapping.getOrderable().isCustomOrdering());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"city", (String)virtualManyToManyMapping.getOrderable().getSpecifiedOrderBy());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)((EclipseLinkJoinFetchMapping)virtualManyToManyMapping).getJoinFetch().getValue());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityManyToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmManyToManyMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"oneToMany", (String)virtualPersistentAttribute.getMappingKey());
        EclipseLinkOrmManyToManyMappingTests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        OrmPersistentAttribute ormPersistentAttribute = virtualPersistentAttribute.convertToSpecified("manyToMany");
        OrmEclipseLinkManyToManyMapping ormManyToManyMapping = (OrmEclipseLinkManyToManyMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"address", (String)ormManyToManyMapping.getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToManyMapping.getFetch());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"test.Address", (String)ormManyToManyMapping.getTargetEntity());
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        OrmCascade cascade = ormManyToManyMapping.getCascade();
        EclipseLinkOrmManyToManyMappingTests.assertFalse((boolean)cascade.isAll());
        EclipseLinkOrmManyToManyMappingTests.assertFalse((boolean)cascade.isMerge());
        EclipseLinkOrmManyToManyMappingTests.assertFalse((boolean)cascade.isPersist());
        EclipseLinkOrmManyToManyMappingTests.assertFalse((boolean)cascade.isRemove());
        EclipseLinkOrmManyToManyMappingTests.assertFalse((boolean)cascade.isRefresh());
        EclipseLinkOrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
        EclipseLinkOrmManyToManyMappingTests.assertEquals(null, (String)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
        EclipseLinkOrmManyToManyMappingTests.assertEquals(null, (Object)ormManyToManyMapping.getJoinFetch().getValue());
    }
}

