/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.v1_1.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkIdMapping;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkOneToOneMapping;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.v1_1.context.orm.EclipseLink1_1OrmContextModelTestCase;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EclipseLink1_1OrmPersistentAttributeTests
extends EclipseLink1_1OrmContextModelTestCase {
    public EclipseLink1_1OrmPersistentAttributeTests(String name) {
        super(name);
    }

    protected IDataModel buildJpaConfigDataModel() {
        IDataModel dataModel = super.buildJpaConfigDataModel();
        dataModel.setProperty("JpaFacetInstallDataModelProperties.CREATE_ORM_XML", (Object)Boolean.TRUE);
        return dataModel;
    }

    private ICompilationUnit createTestTypeNullAttributeMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityIdMappingPropertyAccess() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
                sb.append("    private Address address;");
            }
        });
    }

    public void testMakeSpecified() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.convertToSpecified();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormPersistentAttribute.convertToSpecified();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.specifiedAttributes();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"name", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeSpecifiedMappingKey() throws Exception {
        this.createTestTypeNullAttributeMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertNull((Object)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute.convertToSpecified("oneToOne");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof OrmEclipseLinkOneToOneMapping));
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormPersistentAttribute.convertToSpecified("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.specifiedAttributes();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof OrmEclipseLinkIdMapping));
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeVirtual() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).convertToSpecified();
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).convertToSpecified();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute.convertToVirtual();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        specifiedOrmPersistentAttribute.convertToVirtual();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator virtualAttributes = ormPersistentType.virtualAttributes();
        OrmReadOnlyPersistentAttribute virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)virtualAttribute.getName());
        virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"name", (String)virtualAttribute.getName());
    }

    public void testMakeVirtualNoUnderlyingJavaAttribute() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).convertToSpecified();
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).convertToSpecified();
        ((OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next()).getMapping().setName("noJavaAttribute");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        specifiedOrmPersistentAttribute.convertToVirtual();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"name", (String)((OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next()).getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMappingKey());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"FOO", (String)((IdMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)((BasicMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete2() throws Exception {
        this.createTestEntityOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMappingKey());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
    }

    public void testGetJavaPersistentAttribute() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        JavaResourcePersistentAttribute javaResourcePersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute();
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaResourcePersistentAttribute.isField());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourcePersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals(javaPersistentType.getResourcePersistentType().persistableFields().next(), (Object)javaResourcePersistentAttribute);
        ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ((OrmPersistentAttribute)ormPersistentAttribute).convertToVirtual();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)ormPersistentAttribute, (Object)ormPersistentType.getAttributeNamed("id"));
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        javaResourcePersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute();
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaResourcePersistentAttribute.isProperty());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourcePersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals(javaPersistentType.getResourcePersistentType().persistableProperties().next(), (Object)javaResourcePersistentAttribute);
        ormPersistentType.setSpecifiedAccess(null);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmPersistentAttribute ormPersistentAttribute2 = ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute2.getMapping().setName("id2");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentAttribute2.getMapping().setName(null);
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentAttribute2.getMapping().setName("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
    }

    public void testGetJavaPersistentAttributeMixedAccess() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getOwningPersistentType().getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)javaPersistentAttribute.getMappingKey());
        ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isProperty());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
        ((OrmPersistentAttribute)ormPersistentAttribute).setSpecifiedAccess(AccessType.FIELD);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isField());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
    }

    public void testGetAccess() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isField());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
        ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isField());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
    }

    public void testGetAccessPropertyInJava() throws Exception {
        this.createTestEntityIdMappingPropertyAccess();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isProperty());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isProperty());
        ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isProperty());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isProperty());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isProperty());
    }
}

