/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.v2_0.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.AssociationOverride;
import org.eclipse.jpt.jpa.core.context.AssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.MappedSuperclass;
import org.eclipse.jpt.jpa.core.context.VirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.VirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.jpa2.context.Cacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.CacheableHolder2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.SharedCacheMode;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.Cacheable2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.v2_0.context.EclipseLink2_0ContextModelTestCase;

public class EclipseLink2_0JavaEntityTests
extends EclipseLink2_0ContextModelTestCase {
    protected static final String SUB_TYPE_NAME = "AnnotationTestTypeChild";
    protected static final String FULLY_QUALIFIED_SUB_TYPE_NAME = "test.AnnotationTestTypeChild";

    public EclipseLink2_0JavaEntityTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.OneToOne", "javax.persistence.ManyToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne");
                sb.append(CR);
                sb.append("    private int address2;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany");
                sb.append(CR);
                sb.append("    private int address3;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany");
                sb.append(CR);
                sb.append("    private int address4;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    private ICompilationUnit createTestAbstractEntityTablePerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "javax.persistence.InheritanceType", "javax.persistence.OneToOne", "javax.persistence.ManyToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)");
                sb.append("abstract");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne");
                sb.append(CR);
                sb.append("    private int address2;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany");
                sb.append(CR);
                sb.append("    private int address3;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany");
                sb.append(CR);
                sb.append("    private int address4;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append(EclipseLink2_0JavaEntityTests.SUB_TYPE_NAME).append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    private void createTestMappedSuperclassCustomer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.MappedSuperclass");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@MappedSuperclass");
                sb.append(CR);
                sb.append("public class ").append("Customer ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Customer.java", sourceWriter);
    }

    private void createTestMappedSuperclassCustomerWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.MappedSuperclass");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@MappedSuperclass");
                sb.append(CR);
                sb.append("public class ").append("Customer ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Customer.java", sourceWriter);
    }

    private void createTestEntityLongTimeCustomer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("LongTimeCustomer extends Customer ");
                sb.append("{}");
            }
        };
        this.javaProject.createCompilationUnit("test", "LongTimeCustomer.java", sourceWriter);
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OneToOne");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String street;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private ZipCode zipCode;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableZipCode() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("ZipCode").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String zip;").append(CR);
                sb.append(CR);
                sb.append("    private String plusfour;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "ZipCode.java", sourceWriter);
    }

    public void testAttributeMappingKeyAllowed() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = (Entity)this.getJavaPersistentType().getMapping();
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("basic"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("id"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embedded"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embeddedId"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("version"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("transient"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToOne"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToOne"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToMany"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToMany"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("elementCollection"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("basicCollection"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("basicMap"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("transformation"));
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("variableOneToOne"));
    }

    public void testOverridableAttributes() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().overridableAttributeNames();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
        this.getJavaEntity().setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        overridableAttributes = this.getJavaEntity().overridableAttributeNames();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testOverridableAttributeNames() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributeNames = this.getJavaEntity().overridableAttributeNames();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
        this.getJavaEntity().setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        overridableAttributeNames = this.getJavaEntity().overridableAttributeNames();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testAllOverridableAttributes() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().allOverridableAttributeNames();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAttributesTablePerClass() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().allOverridableAttributeNames();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        JavaEntity abstractEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        overridableAttributes = abstractEntity.allOverridableAttributeNames();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAssociationsTablePerClass() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociations = this.getJavaEntity().allOverridableAssociationNames();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address3", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address4", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        JavaEntity abstractEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        overridableAssociations = abstractEntity.allOverridableAssociationNames();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address3", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address4", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testAllOverridableAttributesMappedSuperclassInOrmXml() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().allOverridableAttributeNames();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAttributeNames() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributeNames = this.getJavaEntity().allOverridableAttributeNames();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributeNames.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        typeResource.moveAnnotation(1, 0, "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testDefaultAttributeOverrides() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAttributeOverrideContainer overrideContainer = javaEntity.getAttributeOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.virtualOverridesSize());
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.virtualOverrides().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        BasicMapping idMapping = (BasicMapping)mappedSuperclass.getPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.getColumn().setSpecifiedTable("BAR");
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.virtualOverridesSize());
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.virtualOverrides().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)virtualAttributeOverride.getColumn().getTable());
        idMapping.getColumn().setSpecifiedName(null);
        idMapping.getColumn().setSpecifiedTable(null);
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.virtualOverrides().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride.convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)overrideContainer.virtualOverridesSize());
    }

    public void testDefaultAttributeOverridesEntityHierachy() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAttributeOverrideContainer overrideContainer = javaEntity.getAttributeOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.virtualOverridesSize());
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.virtualOverrides().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        JavaEntity superclass = (JavaEntity)this.getJavaPersistentType().getMapping();
        BasicMapping idMapping = (BasicMapping)superclass.getPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.getColumn().setSpecifiedTable("BAR");
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.virtualOverridesSize());
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.virtualOverrides().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)virtualAttributeOverride.getColumn().getTable());
        idMapping.getColumn().setSpecifiedName(null);
        idMapping.getColumn().setSpecifiedTable(null);
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.virtualOverrides().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride.convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)overrideContainer.virtualOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)overrideContainer.specifiedOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)overrideContainer.specifiedOverridesSize());
    }

    public void testDefaultAttributeOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.virtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)overrideContainer.virtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)1, (int)overrideContainer.virtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)overrideContainer.virtualOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.overridesSize());
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.overridesSize());
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.overridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        annotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals((int)4, (int)overrideContainer.overridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator attributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = overrideContainer.virtualOverrides();
        virtualAttributeOverrides.next();
        ((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator attributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideSetVirtualTrue() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")));
        ((AttributeOverride)overrideContainer.specifiedOverrides().next()).convertToVirtual();
        Iterator attributeOverrideResources = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        ListIterator attributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((JavaAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((JavaAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)overrideContainer.specifiedOverrides().next()).convertToVirtual();
        attributeOverrideResources = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        attributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((JavaAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)overrideContainer.specifiedOverrides().next()).convertToVirtual();
        attributeOverrideResources = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        attributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator javaAttributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaAttributeOverrides));
        overrideContainer.moveSpecifiedOverride(2, 0);
        ListIterator attributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverride)attributeOverrides.next()).getName());
        javaAttributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        overrideContainer.moveSpecifiedOverride(0, 1);
        attributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverride)attributeOverrides.next()).getName());
        javaAttributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
    }

    public void testUpdateSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ((AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")).setName("FOO");
        ((AttributeOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")).setName("BAR");
        ((AttributeOverrideAnnotation)typeResource.addAnnotation(2, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator attributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.moveAnnotation(2, 0, "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.moveAnnotation(0, 1, "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = overrideContainer.virtualOverrides();
        JavaVirtualAttributeOverride virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)virtualAttributeOverrides.hasNext());
        ((VirtualAttributeOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        AttributeOverride specifiedAttributeOverride = (AttributeOverride)overrideContainer.specifiedOverrides().next();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAttributeOverride.isVirtual());
        virtualAttributeOverrides = overrideContainer.virtualOverrides();
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)virtualAttributeOverrides.hasNext());
    }

    public void testOverridableAssociations() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociations = this.getJavaEntity().overridableAssociationNames();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testOverridableAssociationNames() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociationNames = this.getJavaEntity().overridableAssociationNames();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAllOverridableAssociationNames() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociationNames = this.getJavaEntity().allOverridableAssociationNames();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((String)overridableAssociationNames.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((String)overridableAssociationNames.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address3", (String)((String)overridableAssociationNames.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address4", (String)((String)overridableAssociationNames.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAllOverridableAssociationsMappedSuperclassInOrmXml() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        Iterator overridableAssociations = this.getJavaEntity().allOverridableAssociationNames();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address3", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address4", (String)((String)overridableAssociations.next()));
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator specifiedAssociationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        typeResource.moveAnnotation(1, 0, "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
    }

    public void testVirtualAssociationOverrides() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAssociationOverrideContainer overrideContainer = javaEntity.getAssociationOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
        EclipseLink2_0JavaEntityTests.assertEquals((int)4, (int)overrideContainer.virtualOverridesSize());
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.virtualOverrides().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
        EclipseLink2_0JavaEntityTests.assertEquals((int)4, (int)overrideContainer.virtualOverridesSize());
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.virtualOverrides().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.virtualOverrides().next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride.convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.virtualOverridesSize());
    }

    public void testSpecifiedAssociationOverridesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)overrideContainer.specifiedOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("FOO");
        associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)overrideContainer.specifiedOverridesSize());
    }

    public void testVirtualAssociationOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)4, (int)overrideContainer.virtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)3, (int)overrideContainer.virtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)overrideContainer.virtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)1, (int)overrideContainer.virtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)overrideContainer.virtualOverridesSize());
    }

    public void testAssociationOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)4, (int)overrideContainer.overridesSize());
        ((VirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)4, (int)overrideContainer.overridesSize());
        ((VirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((int)4, (int)overrideContainer.overridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        AssociationOverrideAnnotation annotation = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        annotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals((int)5, (int)overrideContainer.overridesSize());
    }

    public void testAssociationOverrideSetVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((VirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        ((VirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator associationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtual2() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.virtualOverrides();
        virtualAssociationOverrides.next();
        ((JavaVirtualAssociationOverride)virtualAssociationOverrides.next()).convertToSpecified();
        ((VirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator associationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtualTrue() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((VirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        ((VirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")));
        ((AssociationOverride)overrideContainer.specifiedOverrides().next()).convertToVirtual();
        Iterator associationOverrideResources = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)associationOverrideResources.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrideResources.hasNext());
        ListIterator associationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        ((AssociationOverride)overrideContainer.specifiedOverrides().next()).convertToVirtual();
        associationOverrideResources = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrideResources.hasNext());
        associationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        EclipseLink2_0JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
    }

    public void testMoveSpecifiedAssociationOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((VirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        ((VirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator javaAssociationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        EclipseLink2_0JavaEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)javaAssociationOverrides));
        overrideContainer.moveSpecifiedOverride(1, 0);
        ListIterator associationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        overrideContainer.moveSpecifiedOverride(0, 1);
        associationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
    }

    public void testUpdateSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ((AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")).setName("FOO");
        ((AssociationOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")).setName("BAR");
        ((AssociationOverrideAnnotation)typeResource.addAnnotation(2, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator associationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.moveAnnotation(2, 0, "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.moveAnnotation(0, 1, "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedOverrides();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.virtualOverrides();
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address3", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address4", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
        ((VirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        AssociationOverride specifiedAssociationOverride = (AssociationOverride)overrideContainer.specifiedOverrides().next();
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)specifiedAssociationOverride.isVirtual());
        virtualAssociationOverrides = overrideContainer.virtualOverrides();
        virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address2", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address3", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address4", (String)virtualAssociationOverride.getName());
        EclipseLink2_0JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        EclipseLink2_0JavaEntityTests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
    }

    public void testNestedVirtualAttributeOverrides() throws Exception {
        this.createTestMappedSuperclassCustomer();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.LongTimeCustomer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().specifiedClassRefs();
        ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType longTimeCustomerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType addressPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType zipCodePersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        AttributeOverrideContainer attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)6, (int)attributeOverrideContainer.virtualOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualOverrides();
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.street", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.city", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.zip", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"zip", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        BasicMapping plusFourMapping = (BasicMapping)zipCodePersistentType.getAttributeNamed("plusfour").getMapping();
        plusFourMapping.getColumn().setSpecifiedName("BLAH");
        plusFourMapping.getColumn().setSpecifiedTable("BLAH_TABLE");
        plusFourMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        plusFourMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        plusFourMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        plusFourMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        plusFourMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (VirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        AttributeOverride specifiedAttributeOverride = ((VirtualAttributeOverride)((EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getOverrideNamed("plusfour")).convertToSpecified();
        specifiedAttributeOverride.getColumn().setSpecifiedName("BLAH_OVERRIDE");
        specifiedAttributeOverride.getColumn().setSpecifiedTable("BLAH_TABLE_OVERRIDE");
        specifiedAttributeOverride.getColumn().setColumnDefinition("COLUMN_DEFINITION_OVERRIDE");
        attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (VirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_OVERRIDE", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)virtualAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        specifiedAttributeOverride = virtualAttributeOverride.convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.isVirtual());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)specifiedAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedTable());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)255, (int)specifiedAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getScale());
    }

    public void testNestedVirtualAttributeOverridesElementCollection() throws Exception {
        this.createTestMappedSuperclassCustomerWithElementCollection();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.LongTimeCustomer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().specifiedClassRefs();
        ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType longTimeCustomerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType addressPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType zipCodePersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        AttributeOverrideContainer attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)6, (int)attributeOverrideContainer.virtualOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualOverrides();
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.street", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.city", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.zip", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"zip", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        BasicMapping plusFourMapping = (BasicMapping)zipCodePersistentType.getAttributeNamed("plusfour").getMapping();
        plusFourMapping.getColumn().setSpecifiedName("BLAH");
        plusFourMapping.getColumn().setSpecifiedTable("BLAH_TABLE");
        plusFourMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        plusFourMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        plusFourMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        plusFourMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        plusFourMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (VirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        AttributeOverride specifiedAttributeOverride = ((VirtualAttributeOverride)((EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getOverrideNamed("plusfour")).convertToSpecified();
        specifiedAttributeOverride.getColumn().setSpecifiedName("BLAH_OVERRIDE");
        specifiedAttributeOverride.getColumn().setSpecifiedTable("BLAH_TABLE_OVERRIDE");
        specifiedAttributeOverride.getColumn().setColumnDefinition("COLUMN_DEFINITION_OVERRIDE");
        attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (VirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_OVERRIDE", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)virtualAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        specifiedAttributeOverride = virtualAttributeOverride.convertToSpecified();
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.isVirtual());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.zipCode.plusfour", (String)specifiedAttributeOverride.getName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedName());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedTable());
        EclipseLink2_0JavaEntityTests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaEntityTests.assertEquals((int)255, (int)specifiedAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaEntityTests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getScale());
    }

    public void testNestedVirtualAssociationOverrides() throws Exception {
        this.createTestMappedSuperclassCustomer();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.LongTimeCustomer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().specifiedClassRefs();
        specifiedClassRefs.next();
        JavaPersistentType longTimeCustomerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        AssociationOverrideContainer attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAssociationOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)1, (int)attributeOverrideContainer.virtualOverridesSize());
        ListIterator virtualAssociationOverrides = attributeOverrideContainer.virtualOverrides();
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.state", (String)virtualAssociationOverride.getName());
    }

    public void testNestedVirtualAssociationOverridesElementCollection() throws Exception {
        this.createTestMappedSuperclassCustomerWithElementCollection();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.LongTimeCustomer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().specifiedClassRefs();
        specifiedClassRefs.next();
        JavaPersistentType longTimeCustomerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        AssociationOverrideContainer attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAssociationOverrideContainer();
        EclipseLink2_0JavaEntityTests.assertEquals((int)1, (int)attributeOverrideContainer.virtualOverridesSize());
        ListIterator virtualAssociationOverrides = attributeOverrideContainer.virtualOverrides();
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        EclipseLink2_0JavaEntityTests.assertEquals((String)"address.state", (String)virtualAssociationOverride.getName());
    }

    public void testSetSpecifiedCacheable() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableHolder2_0)this.getJavaEntity()).getCacheable();
        Cacheable2_0Annotation cacheableAnnotation = (Cacheable2_0Annotation)this.getJavaPersistentType().getResourcePersistentType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheableAnnotation);
        cacheable.setSpecifiedCacheable(Boolean.FALSE);
        cacheableAnnotation = (Cacheable2_0Annotation)this.getJavaPersistentType().getResourcePersistentType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.FALSE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.FALSE, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable(false)", cu);
        cacheable.setSpecifiedCacheable(Boolean.TRUE);
        cacheableAnnotation = (Cacheable2_0Annotation)this.getJavaPersistentType().getResourcePersistentType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable", cu);
        cacheable.setSpecifiedCacheable(null);
        cacheableAnnotation = (Cacheable2_0Annotation)this.getJavaPersistentType().getResourcePersistentType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheableAnnotation);
        this.assertSourceDoesNotContain("@Cacheable", cu);
    }

    public void testGetSpecifiedCacheable() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableHolder2_0)this.getJavaEntity()).getCacheable();
        Cacheable2_0Annotation cacheableAnnotation = (Cacheable2_0Annotation)this.getJavaPersistentType().getResourcePersistentType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheableAnnotation);
        this.getJavaPersistentType().getResourcePersistentType().addAnnotation("javax.persistence.Cacheable");
        this.getJpaProject().synchronizeContextModel();
        cacheableAnnotation = (Cacheable2_0Annotation)this.getJavaPersistentType().getResourcePersistentType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable", cu);
        cacheableAnnotation.setValue(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.FALSE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.FALSE, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable(false)", cu);
        cacheableAnnotation.setValue(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable(true)", cu);
        cacheableAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable", cu);
        this.getJavaPersistentType().getResourcePersistentType().removeAnnotation("javax.persistence.Cacheable");
        cacheableAnnotation = (Cacheable2_0Annotation)this.getJavaPersistentType().getResourcePersistentType().getAnnotation("javax.persistence.Cacheable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals(null, (Object)cacheableAnnotation);
        this.assertSourceDoesNotContain("@Cacheable", cu);
    }

    public void testIsDefaultCacheable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableHolder2_0)this.getJavaEntity()).getCacheable();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        EclipseLink2_0JavaEntityTests.assertEquals((Object)SharedCacheMode.DISABLE_SELECTIVE, (Object)persistenceUnit.getSharedCacheMode());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode.ALL);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode.NONE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode.ENABLE_SELECTIVE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode.DISABLE_SELECTIVE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode.UNSPECIFIED);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
    }

    public void testInheritedIsDefaultCacheable() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 subCacheable = ((CacheableHolder2_0)this.getJavaEntity()).getCacheable();
        Cacheable2_0 cacheable = ((CacheableHolder2_0)this.getJavaEntity().getParentEntity()).getCacheable();
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        EclipseLinkPersistenceUnit persistenceUnit2_0 = this.getPersistenceUnit();
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.NONE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(null);
        cacheable.setSpecifiedCacheable(Boolean.FALSE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.DISABLE_SELECTIVE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        cacheable.setSpecifiedCacheable(Boolean.FALSE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.ENABLE_SELECTIVE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        cacheable.setSpecifiedCacheable(Boolean.TRUE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.NONE);
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaEntityTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
    }
}

