/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArithmeticFactor
extends AbstractExpression {
    private AbstractExpression expression;

    ArithmeticFactor(AbstractExpression parent, String arithmeticFactor) {
        super(parent, arithmeticFactor);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression(this.getText()));
        if (this.expression != null) {
            children.add(this.expression);
        }
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return ArithmeticFactor.queryBNF("arithmetic_factor");
    }

    @Override
    boolean handleAggregate(JPQLQueryBNF queryBNF) {
        return false;
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasMinusSign() {
        return this.getText().charAt(0) == '-';
    }

    public boolean hasPlusSign() {
        return this.getText().charAt(0) == '+';
    }

    @Override
    boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        char character = wordParser.character();
        return wordParser.isArithmeticSymbol(character) || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward(1);
        wordParser.skipLeadingWhitespace();
        this.expression = this.parse(wordParser, this.getQueryBNF(), tolerant);
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append(this.getText());
        if (this.expression != null) {
            this.expression.toParsedText(writer, includeVirtual);
        }
    }
}

