/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.BidiFilter;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class BidiFilterTests
extends TestCase {
    public BidiFilterTests(String name) {
        super(name);
    }

    public void testNullBidiFilter_accept() throws Exception {
        BidiFilterTests.assertTrue((boolean)BidiFilter.Null.instance().accept((Object)"foo"));
    }

    public void testNullBidiFilter_reverseAccept() throws Exception {
        BidiFilterTests.assertTrue((boolean)BidiFilter.Null.instance().reverseAccept((Object)"foo"));
    }

    public void testNullBidiFilter_toString() throws Exception {
        BidiFilterTests.assertNotNull((Object)BidiFilter.Null.instance().toString());
    }

    public void testNullBidiFilter_serialization() throws Exception {
        BidiFilter xxx = TestTools.serialize(BidiFilter.Null.instance());
        BidiFilterTests.assertSame((Object)BidiFilter.Null.instance(), (Object)xxx);
    }

    public void testOpaqueBidiFilter_accept() throws Exception {
        BidiFilterTests.assertFalse((boolean)BidiFilter.Opaque.instance().accept((Object)"foo"));
    }

    public void testOpaqueBidiFilter_reverseAccept() throws Exception {
        BidiFilterTests.assertFalse((boolean)BidiFilter.Opaque.instance().reverseAccept((Object)"foo"));
    }

    public void testOpaqueBidiFilter_toString() throws Exception {
        BidiFilterTests.assertNotNull((Object)BidiFilter.Opaque.instance().toString());
    }

    public void testOpaqueBidiFilter_serialization() throws Exception {
        BidiFilter xxx = TestTools.serialize(BidiFilter.Opaque.instance());
        BidiFilterTests.assertSame((Object)BidiFilter.Opaque.instance(), (Object)xxx);
    }

    public void testDisabledBidiFilter_accept() throws Exception {
        boolean exCaught = false;
        try {
            BidiFilter.Disabled.instance().accept((Object)"foo");
            BidiFilterTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        BidiFilterTests.assertTrue((boolean)exCaught);
    }

    public void testDisabledBidiFilter_reverseAccept() throws Exception {
        boolean exCaught = false;
        try {
            BidiFilter.Disabled.instance().reverseAccept((Object)"foo");
            BidiFilterTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        BidiFilterTests.assertTrue((boolean)exCaught);
    }

    public void testDisabledBidiFilter_toString() throws Exception {
        BidiFilterTests.assertNotNull((Object)BidiFilter.Disabled.instance().toString());
    }

    public void testDisabledBidiFilter_serialization() throws Exception {
        BidiFilter xxx = TestTools.serialize(BidiFilter.Disabled.instance());
        BidiFilterTests.assertSame((Object)BidiFilter.Disabled.instance(), (Object)xxx);
    }
}

