/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.relation;

import java.util.Iterator;
import java.util.Properties;
import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnsAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ManyToManyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ManyToOneAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.NestableJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.OneToManyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateRelationsTest {
    private IJPAEditorFeatureProvider featureProvider;
    final String TEST_PROJECT = "Test";
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    IEclipseFacade eclipseFacade = null;
    private static final int MAX_NUM_OF_ITERATIONS = 250;
    JavaPersistentType t1 = null;
    ICompilationUnit cu1 = null;
    JavaPersistentType t2 = null;
    ICompilationUnit cu2 = null;
    private IJPAEditorFeatureProvider featureProvider20;
    private JpaProject jpa20Project;

    @Before
    public void setUp() throws Exception {
        JptJpaCorePlugin.getJpaProjectManager();
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        IFile entity = this.factory.createEntity(this.jpaProject, "org.eclipse.Entity1");
        Thread.sleep(2000L);
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement(null)).andReturn((Object)CreateRelationsTest.getPersistentType(entity));
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit((JavaPersistentType)EasyMock.isA(JavaPersistentType.class))).andReturn((Object)JavaCore.createCompilationUnitFrom((IFile)entity)).anyTimes();
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourcePersistentType customerType = this.jpaProject.getJavaResourcePersistentType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        this.t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        int c = 0;
        while (this.t1 == null && c < 250) {
            this.jpaProject.update(null);
            Thread.sleep(200L);
            this.t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
            ++c;
        }
        EasyMock.expect((Object)this.featureProvider.getPictogramElementForBusinessObject((Object)this.t1)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        this.cu1 = JavaCore.createCompilationUnitFrom((IFile)customerFile);
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit(this.t1)).andStubReturn((Object)this.cu1);
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourcePersistentType addressType = this.jpaProject.getJavaResourcePersistentType("com.Address");
        Assert.assertNotNull((Object)customerType);
        this.t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        c = 0;
        while (this.t2 == null && c < 250) {
            this.jpaProject.update(null);
            Thread.sleep(200L);
            this.t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
            ++c;
        }
        EasyMock.expect((Object)this.featureProvider.getPictogramElementForBusinessObject((Object)this.t2)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        this.cu2 = JavaCore.createCompilationUnitFrom((IFile)addressFile);
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit(this.t2)).andStubReturn((Object)this.cu2);
        Properties props = new Properties();
        props.setProperty(JPADiagramPropertyPage.PROP_COLLECTION_TYPE.getLocalName(), "collection");
        EasyMock.expect((Object)this.featureProvider.loadProperties(this.jpaProject.getProject())).andStubReturn((Object)props);
        EasyMock.replay((Object[])new Object[]{this.featureProvider});
        this.jpa20Project = this.factory.createJPA20Project("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpa20Project);
        IFile entity20 = this.factory.createEntity(this.jpa20Project, "org.eclipse.Entity1");
        Thread.sleep(2000L);
        this.featureProvider20 = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider20.getBusinessObjectForPictogramElement(null)).andReturn((Object)CreateRelationsTest.getPersistentType(entity20));
        EasyMock.expect((Object)this.featureProvider20.getCompilationUnit((JavaPersistentType)EasyMock.isA(JavaPersistentType.class))).andReturn((Object)JavaCore.createCompilationUnitFrom((IFile)entity20)).anyTimes();
    }

    public static JavaPersistentType getPersistentType(IFile file) {
        JpaFile jpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        Iterator<JpaStructureNode> iterator = CreateRelationsTest.getRootNodes(jpaFile).iterator();
        if (iterator.hasNext()) {
            JpaStructureNode node = iterator.next();
            JavaPersistentType entity = (JavaPersistentType)node;
            return entity;
        }
        return null;
    }

    private static Iterable<JpaStructureNode> getRootNodes(JpaFile jpaFile) {
        if (jpaFile == null) {
            return EmptyIterable.instance();
        }
        return jpaFile.getRootStructureNodes();
    }

    public ICompilationUnit createCompilationUnitFrom(IFile file) {
        return JavaCore.createCompilationUnitFrom((IFile)file);
    }

    @Test
    public void testCreateOneToOneUnidirRelation() throws Exception {
        OneToOneUniDirRelation rel = new OneToOneUniDirRelation(this.featureProvider, this.t1, this.t2, "address", true, this.cu1, this.cu2);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)this.t1, (Object)rel.getOwner());
        Assert.assertSame((Object)this.t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = this.t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        OneToOneAnnotation an = (OneToOneAnnotation)ownerAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.OneToOne");
        Assert.assertNotNull((Object)an);
        Assert.assertNull((Object)an.getMappedBy());
    }

    @Test
    public void testCreateOneToOneBidirRelation() throws Exception {
        OneToOneBiDirRelation rel = new OneToOneBiDirRelation(this.featureProvider, this.t1, this.t2, "address", "customer", true, this.cu1, this.cu2);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)this.t1, (Object)rel.getOwner());
        Assert.assertSame((Object)this.t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = this.t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        OneToOneAnnotation an = (OneToOneAnnotation)ownerAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.OneToOne");
        Assert.assertNotNull((Object)an);
        Assert.assertNull((Object)an.getMappedBy());
        JavaPersistentAttribute inverseAt = this.t2.getAttributeNamed("customer");
        Assert.assertNotNull((Object)inverseAt);
        an = (OneToOneAnnotation)inverseAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.OneToOne");
        Assert.assertNotNull((Object)an);
        Assert.assertEquals((Object)"address", (Object)an.getMappedBy());
    }

    @Test
    public void testCreateOneToManyUnidirRelation() throws Exception {
        OneToManyUniDirRelation rel = new OneToManyUniDirRelation(this.featureProvider, this.t1, this.t2, "address", true, this.cu1, this.cu2);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)this.t1, (Object)rel.getOwner());
        Assert.assertSame((Object)this.t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = this.t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        OneToManyAnnotation an = (OneToManyAnnotation)ownerAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.OneToMany");
        Assert.assertNull((Object)an.getMappedBy());
    }

    @Test
    public void testCreateManyToOneUnidirRelation() throws Exception {
        ManyToOneUniDirRelation rel = new ManyToOneUniDirRelation(this.featureProvider, this.t1, this.t2, "address", true, this.cu1, this.cu2);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)this.t1, (Object)rel.getOwner());
        Assert.assertSame((Object)this.t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = this.t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        ManyToOneAnnotation an = (ManyToOneAnnotation)ownerAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.ManyToOne");
        Assert.assertNotNull((Object)an);
    }

    @Test
    public void testCreateManyToOneBidirRelation() throws Exception {
        ManyToOneBiDirRelation rel = new ManyToOneBiDirRelation(this.featureProvider, this.t1, this.t2, "address", "customer", true, this.cu1, this.cu2);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)this.t1, (Object)rel.getOwner());
        Assert.assertSame((Object)this.t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = this.t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        ManyToOneAnnotation an = (ManyToOneAnnotation)ownerAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.ManyToOne");
        Assert.assertNotNull((Object)an);
        Assert.assertEquals((Object)"customer", (Object)rel.getInverseAttributeName());
        JavaPersistentAttribute inverseAt = this.t2.getAttributeNamed("customer");
        Assert.assertNotNull((Object)inverseAt);
        OneToManyAnnotation an1 = (OneToManyAnnotation)inverseAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.OneToMany");
        Assert.assertNotNull((Object)an1);
        Assert.assertEquals((Object)"address", (Object)an1.getMappedBy());
    }

    @Test
    public void testCreateManyToManyUnidirRelation() throws Exception {
        ManyToManyUniDirRelation rel = new ManyToManyUniDirRelation(this.featureProvider, this.t1, this.t2, "address", true, this.cu1, this.cu2);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)this.t1, (Object)rel.getOwner());
        Assert.assertSame((Object)this.t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = this.t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        ManyToManyAnnotation an = (ManyToManyAnnotation)ownerAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.ManyToMany");
        Assert.assertNotNull((Object)an);
        Assert.assertNull((Object)an.getMappedBy());
    }

    @Test
    public void testCreateManyToManyBidirRelation() throws Exception {
        ManyToManyBiDirRelation rel = new ManyToManyBiDirRelation(this.featureProvider, this.t1, this.t2, "address", "customer", true, this.createCompilationUnitFrom((IFile)this.t1.getResource()), this.createCompilationUnitFrom((IFile)this.t2.getResource()));
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)this.t1, (Object)rel.getOwner());
        Assert.assertSame((Object)this.t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = this.t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        ManyToManyAnnotation an = (ManyToManyAnnotation)ownerAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.ManyToMany");
        Assert.assertNotNull((Object)an);
        Assert.assertNull((Object)an.getMappedBy());
        JavaPersistentAttribute inverseAt = this.t2.getAttributeNamed("customer");
        Assert.assertNotNull((Object)inverseAt);
        an = (ManyToManyAnnotation)inverseAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.ManyToMany");
        Assert.assertNotNull((Object)an);
        Assert.assertEquals((Object)"address", (Object)an.getMappedBy());
    }

    @Test
    public void testCreateOneToManyUnidirRelation20() throws Exception {
        Assert.assertNotNull((Object)this.jpa20Project);
        IFile customerFile = this.factory.createEntityInProject(this.jpa20Project.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createEntityInProject(this.jpa20Project.getProject(), new String[]{"com"}, "Address");
        this.jpa20Project.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourcePersistentType customerType = this.jpa20Project.getJavaResourcePersistentType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, customerType.getQualifiedName());
        int c = 0;
        while (t1 == null && c < 250) {
            Thread.sleep(200L);
            this.jpa20Project.update(null);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, customerType.getQualifiedName());
            ++c;
        }
        EasyMock.expect((Object)this.featureProvider20.getPictogramElementForBusinessObject((Object)t1)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        ICompilationUnit cu1 = JavaCore.createCompilationUnitFrom((IFile)customerFile);
        EasyMock.expect((Object)this.featureProvider20.getCompilationUnit(t1)).andStubReturn((Object)cu1);
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourcePersistentType addressType = this.jpa20Project.getJavaResourcePersistentType("com.Address");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, addressType.getQualifiedName());
        while (t2 == null && c < 250) {
            Thread.sleep(200L);
            this.jpa20Project.update(null);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, addressType.getQualifiedName());
            ++c;
        }
        EasyMock.expect((Object)this.featureProvider20.getPictogramElementForBusinessObject((Object)t2)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        ICompilationUnit cu2 = JavaCore.createCompilationUnitFrom((IFile)addressFile);
        EasyMock.expect((Object)this.featureProvider20.getCompilationUnit(t2)).andStubReturn((Object)cu2);
        Properties props = new Properties();
        props.setProperty(JPADiagramPropertyPage.PROP_COLLECTION_TYPE.getLocalName(), "list");
        EasyMock.expect((Object)this.featureProvider20.loadProperties(this.jpa20Project.getProject())).andReturn((Object)props);
        EasyMock.replay((Object[])new Object[]{this.featureProvider20});
        OneToManyUniDirRelation rel = new OneToManyUniDirRelation(this.featureProvider20, t1, t2, "address", true, cu1, cu2);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        Annotation o1 = ownerAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.OneToMany");
        Assert.assertNotNull((Object)o1);
        Annotation o2 = ownerAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.JoinColumn");
        Assert.assertNotNull((Object)o2);
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)o2;
        Assert.assertNotNull((Object)joinColumn.getName());
        Assert.assertNotNull((Object)joinColumn.getReferencedColumnName());
        Assert.assertEquals((Object)"Customer_id", (Object)joinColumn.getName());
        Assert.assertEquals((Object)"id", (Object)joinColumn.getReferencedColumnName());
    }

    @Test
    public void testCreateOneToManyUnidirIDClassRelation20() throws Exception {
        Assert.assertNotNull((Object)this.jpa20Project);
        IFile simpleEmployeeFile = this.factory.createIdClassInProject(this.jpa20Project.getProject(), new String[]{"com", "test"}, "Employee");
        IFile employeeFile = this.factory.createEntityWithCompositePKInProject(this.jpa20Project.getProject(), new String[]{"com", "test"}, "Employee");
        IFile projectFile = this.factory.createEntityInProject(this.jpa20Project.getProject(), new String[]{"com"}, "Project");
        this.jpa20Project.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)simpleEmployeeFile.exists());
        Assert.assertTrue((boolean)employeeFile.exists());
        JavaResourcePersistentType employeeType = this.jpa20Project.getJavaResourcePersistentType("com.test.Employee");
        Assert.assertNotNull((Object)employeeType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, employeeType.getQualifiedName());
        int c = 0;
        while (t1 == null && c < 250) {
            Thread.sleep(200L);
            this.jpa20Project.update(null);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, employeeType.getQualifiedName());
            ++c;
        }
        EasyMock.expect((Object)this.featureProvider20.getPictogramElementForBusinessObject((Object)t1)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        ICompilationUnit cu1 = JavaCore.createCompilationUnitFrom((IFile)employeeFile);
        EasyMock.expect((Object)this.featureProvider20.getCompilationUnit(t1)).andStubReturn((Object)cu1);
        Assert.assertTrue((boolean)projectFile.exists());
        JavaResourcePersistentType projectType = this.jpa20Project.getJavaResourcePersistentType("com.Project");
        Assert.assertNotNull((Object)employeeType);
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, projectType.getQualifiedName());
        while (t2 == null && c < 250) {
            Thread.sleep(200L);
            this.jpa20Project.update(null);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, projectType.getQualifiedName());
            ++c;
        }
        EasyMock.expect((Object)this.featureProvider20.getPictogramElementForBusinessObject((Object)t2)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        ICompilationUnit cu2 = JavaCore.createCompilationUnitFrom((IFile)projectFile);
        EasyMock.expect((Object)this.featureProvider20.getCompilationUnit(t2)).andStubReturn((Object)cu2);
        Properties props = new Properties();
        props.setProperty(JPADiagramPropertyPage.PROP_COLLECTION_TYPE.getLocalName(), "list");
        EasyMock.expect((Object)this.featureProvider20.loadProperties(this.jpa20Project.getProject())).andReturn((Object)props);
        EasyMock.replay((Object[])new Object[]{this.featureProvider20});
        OneToManyUniDirRelation rel = new OneToManyUniDirRelation(this.featureProvider20, t1, t2, "project", true, cu1, cu2);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"project", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = t1.getAttributeNamed("project");
        Assert.assertNotNull((Object)ownerAt);
        Annotation o1 = ownerAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.OneToMany");
        Assert.assertNotNull((Object)o1);
        Annotation o2 = ownerAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.JoinColumns");
        Assert.assertNotNull((Object)o2);
        JoinColumnsAnnotation joinColumns = (JoinColumnsAnnotation)o2;
        Assert.assertEquals((long)2L, (long)joinColumns.getNestedAnnotationsSize());
        Assert.assertEquals((Object)"javax.persistence.JoinColumn", (Object)joinColumns.getNestedAnnotationName());
    }

    @Test
    public void testCreateOneToManyUnidirEmbeddedRelation20() throws Exception {
        Assert.assertNotNull((Object)this.jpa20Project);
        IFile simpleEmployeeFile = this.factory.createEmbeddedClassInProject(this.jpa20Project.getProject(), new String[]{"com", "test"}, "EmployeerId");
        IFile employeeFile = this.factory.createEntityWithEmbeddedPKInProject(this.jpa20Project.getProject(), new String[]{"com", "test"}, "Employeer");
        IFile projectFile = this.factory.createEntityInProject(this.jpa20Project.getProject(), new String[]{"com"}, "Person");
        this.jpa20Project.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)simpleEmployeeFile.exists());
        Assert.assertTrue((boolean)employeeFile.exists());
        JavaResourcePersistentType employeeType = this.jpa20Project.getJavaResourcePersistentType("com.test.Employeer");
        Assert.assertNotNull((Object)employeeType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, employeeType.getQualifiedName());
        int c = 0;
        while (t1 == null && c < 250) {
            Thread.sleep(200L);
            this.jpa20Project.update(null);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, employeeType.getQualifiedName());
            ++c;
        }
        EasyMock.expect((Object)this.featureProvider20.getPictogramElementForBusinessObject((Object)t1)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        ICompilationUnit cu1 = JavaCore.createCompilationUnitFrom((IFile)employeeFile);
        EasyMock.expect((Object)this.featureProvider20.getCompilationUnit(t1)).andStubReturn((Object)cu1);
        Embeddable emb = JpaArtifactFactory.instance().getPersistenceUnit(t1).getEmbeddable("com.test.EmployeerId");
        Iterator embIt = emb.allAttributeMappings();
        int c1 = 0;
        while (!embIt.hasNext() && c1 < 250) {
            Thread.sleep(200L);
            this.jpa20Project.update(null);
            emb.update();
            embIt = emb.allAttributeMappings();
            ++c1;
        }
        Assert.assertTrue((boolean)projectFile.exists());
        JavaResourcePersistentType projectType = this.jpa20Project.getJavaResourcePersistentType("com.Person");
        Assert.assertNotNull((Object)employeeType);
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, projectType.getQualifiedName());
        while (t2 == null && c < 250) {
            Thread.sleep(200L);
            this.jpa20Project.update(null);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, projectType.getQualifiedName());
            ++c;
        }
        EasyMock.expect((Object)this.featureProvider20.getPictogramElementForBusinessObject((Object)t2)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        ICompilationUnit cu2 = JavaCore.createCompilationUnitFrom((IFile)projectFile);
        EasyMock.expect((Object)this.featureProvider20.getCompilationUnit(t2)).andStubReturn((Object)cu2);
        Properties props = new Properties();
        props.setProperty(JPADiagramPropertyPage.PROP_COLLECTION_TYPE.getLocalName(), "list");
        EasyMock.expect((Object)this.featureProvider20.loadProperties(this.jpa20Project.getProject())).andReturn((Object)props);
        EasyMock.replay((Object[])new Object[]{this.featureProvider20});
        OneToManyUniDirRelation rel = new OneToManyUniDirRelation(this.featureProvider20, t1, t2, "person", true, cu1, cu2);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"person", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = t1.getAttributeNamed("person");
        Assert.assertNotNull((Object)ownerAt);
        Annotation o1 = ownerAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.OneToMany");
        Assert.assertNotNull((Object)o1);
        Annotation o2 = ownerAt.getResourcePersistentAttribute().getAnnotation("javax.persistence.JoinColumns");
        Assert.assertNotNull((Object)o2);
        JoinColumnsAnnotation joinColumns = (JoinColumnsAnnotation)o2;
        Assert.assertEquals((long)1L, (long)joinColumns.getNestedAnnotationsSize());
        Assert.assertEquals((Object)"javax.persistence.JoinColumn", (Object)joinColumns.getNestedAnnotationName());
        Iterable nestedAnnotations = joinColumns.getNestedAnnotations();
        for (NestableJoinColumnAnnotation joinColumn : nestedAnnotations) {
            Assert.assertEquals((Object)"Employeer_firstName", (Object)joinColumn.getName());
            Assert.assertEquals((Object)"firstName", (Object)joinColumn.getReferencedColumnName());
        }
    }
}

