/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.preferences.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposoalCatigoriesConfigurationRegistry;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.sse.ui.preferences.CodeAssistCyclingConfigurationBlock;
import org.eclipse.wst.sse.ui.preferences.ICompletionProposalCategoriesConfigurationWriter;

public class JSPContentAssistPreferencePage
extends AbstractPreferencePage
implements IWorkbenchPreferencePage {
    private static final String JSP_CONTENT_TYPE_ID = "org.eclipse.jst.jsp.core.jspsource";
    private Button fAutoImport;
    private CodeAssistCyclingConfigurationBlock fConfigurationBlock;

    protected Control createContents(Composite parent) {
        Composite composite = super.createComposite(parent, 1);
        this.createContentsForAutoInsertionGroup(composite);
        this.createContentsForCyclingGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    protected void performDefaults() {
        this.performDefaultsForAutoInsertionGroup();
        this.performDefaultsForCyclingGroup();
        this.validateValues();
        this.enableValues();
        super.performDefaults();
    }

    protected void initializeValues() {
        this.initializeValuesForAutoInsertionGroup();
        this.initializeValuesForCyclingGroup();
    }

    protected void storeValues() {
        this.storeValuesForAutoInsertionGroup();
        this.storeValuesForCyclingGroup();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JSPUIPlugin.getDefault().getPreferenceStore();
    }

    private void createContentsForAutoInsertionGroup(Composite parent) {
        Group group = this.createGroup(parent, 2);
        group.setText(JSPUIMessages.JSPCodeAssist_Insertion);
        this.fAutoImport = this.createCheckBox((Composite)group, JSPUIMessages.JSPCodeAssist_Auto_Import);
        ((GridData)this.fAutoImport.getLayoutData()).horizontalSpan = 2;
    }

    private void createContentsForCyclingGroup(Composite parent) {
        ICompletionProposalCategoriesConfigurationWriter configurationWriter = CompletionProposoalCatigoriesConfigurationRegistry.getDefault().getWritableConfiguration(JSP_CONTENT_TYPE_ID);
        if (configurationWriter != null) {
            this.fConfigurationBlock = new CodeAssistCyclingConfigurationBlock(JSP_CONTENT_TYPE_ID, configurationWriter);
            this.fConfigurationBlock.createContents(parent, JSPUIMessages.Cycling_UI);
        } else {
            Logger.log((int)4, (String)"There should be an ICompletionProposalCategoriesConfigurationWriter specified for the JSP content type, but can't fine it, thus can't create user preference block for editing proposal categories preferences.");
        }
    }

    private void storeValuesForAutoInsertionGroup() {
        this.getPreferenceStore().setValue("autoImportinsertion", this.fAutoImport != null ? this.fAutoImport.getSelection() : false);
    }

    private void storeValuesForCyclingGroup() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.storeValues();
        }
    }

    private void initializeValuesForAutoInsertionGroup() {
        this.initCheckbox(this.fAutoImport, "autoImportinsertion");
    }

    private void initializeValuesForCyclingGroup() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.initializeValues();
        }
    }

    private void performDefaultsForAutoInsertionGroup() {
        this.defaultCheckbox(this.fAutoImport, "autoImportinsertion");
    }

    private void performDefaultsForCyclingGroup() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performDefaults();
        }
    }
}

