/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.OneToManyAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetch;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkOneToManyMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkOneToManyRelationship;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkPrivateOwned;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkJoinFetchAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.JoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaOneToManyMappingTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithPrivateOwnedOneToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "org.eclipse.persistence.annotations.PrivateOwned"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
                sb.append("@PrivateOwned").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithJoinFetchOneToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "org.eclipse.persistence.annotations.JoinFetch"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
                sb.append("@JoinFetch").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithDefaultOneToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("implements java.io.Serializable");
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("private java.util.Collection<AnnotationTestType> myTypes;").append(CR);
                sb.append(CR);
            }
        });
    }

    public EclipseLinkJavaOneToManyMappingTests(String name) {
        super(name);
    }

    public void testGetPrivateOwned() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        EclipseLinkPrivateOwned privateOwnable = oneToManyMapping.getPrivateOwned();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testSetPrivateOwned() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        EclipseLinkPrivateOwned privateOwnable = oneToManyMapping.getPrivateOwned();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
        privateOwnable.setPrivateOwned(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.PrivateOwned"));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)privateOwnable.isPrivateOwned());
        privateOwnable.setPrivateOwned(true);
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.PrivateOwned"));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testPrivateOwnedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        EclipseLinkPrivateOwned privateOwnable = oneToManyMapping.getPrivateOwned();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.PrivateOwned");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)privateOwnable.isPrivateOwned());
        attributeResource.addAnnotation("org.eclipse.persistence.annotations.PrivateOwned");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testGetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getMapping();
        EclipseLinkJoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJoinFetchAnnotation joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(JoinFetchType.INNER);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(JoinFetchType.OUTER);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)contextJoinFetch.getValue());
    }

    public void testSetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getMapping();
        EclipseLinkJoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJoinFetchAnnotation joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.INNER);
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(null);
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.JoinFetch"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.INNER);
        joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceAttribute.getAnnotation("javax.persistence.OneToMany");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToManyMapping mapping = (EclipseLinkOneToManyMapping)contextAttribute.getMapping();
        EclipseLinkOneToManyRelationship rel = mapping.getRelationship();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinColumn();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToMappedBy();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinTable();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceAttribute.getAnnotation("javax.persistence.OneToMany");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToManyMapping mapping = (EclipseLinkOneToManyMapping)contextAttribute.getMapping();
        EclipseLinkOneToManyRelationship rel = mapping.getRelationship();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        annotation.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceAttribute.addAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceAttribute.addAnnotation("javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        annotation.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceAttribute.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceAttribute.removeAnnotation("javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testDefaultOneToMany() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"basic", (String)((JavaPersistentAttribute)attributes.next()).getDefaultMappingKey());
    }

    public void testDefaultOneToManySetFetch() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.setSpecifiedFetch(FetchType.LAZY);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)specifiedOneToManyMapping.getFetch());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY, (Object)annotation.getFetch());
    }

    public void testDefaultOneToManySetTargetEntity() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.setSpecifiedTargetEntity("Foo");
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)specifiedOneToManyMapping.getSpecifiedTargetEntity());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)annotation.getTargetEntity());
    }

    public void testDefaultOneToManySetMappedBy() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("Foo");
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)specifiedOneToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)annotation.getMappedBy());
    }

    public void testDefaultOneToManySetCascadeAll() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setAll(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isAll());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeAll());
    }

    public void testDefaultOneToManySetCascadeMerge() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setMerge(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isMerge());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeMerge());
    }

    public void testDefaultOneToManySetCascadePersist() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setPersist(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isPersist());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadePersist());
    }

    public void testDefaultOneToManySetCascadeRefresh() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setRefresh(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isRefresh());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeRefresh());
    }

    public void testDefaultOneToManySetCascadeRemove() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setRemove(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isRemove());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeRemove());
    }
}

