/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkStructConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaStructConverterTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithConvertAndStructConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.StructConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @StructConverter(name=\"foo\"");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndStructConverterClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.StructConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @StructConverter(converter=\"Foo\"");
            }
        });
    }

    public EclipseLinkJavaStructConverterTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithConvertAndStructConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkStructConverter converter = (EclipseLinkStructConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"foo", (String)converter.getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithConvertAndStructConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkStructConverter converter = (EclipseLinkStructConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"foo", (String)converter.getName());
        converter.setName("bar");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"bar", (String)converter.getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkStructConverterAnnotation converterAnnotation = (EclipseLinkStructConverterAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.StructConverter");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
        converter.setName(null);
        EclipseLinkJavaStructConverterTests.assertEquals(null, (String)converter.getName());
        converterAnnotation = (EclipseLinkStructConverterAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.StructConverter");
        EclipseLinkJavaStructConverterTests.assertEquals(null, (String)converterAnnotation.getName());
        converter.setName("bar");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"bar", (String)converter.getName());
        converterAnnotation = (EclipseLinkStructConverterAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.StructConverter");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
    }

    public void testGetNameUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndStructConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkStructConverter converter = (EclipseLinkStructConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"foo", (String)converter.getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkStructConverterAnnotation converterAnnotation = (EclipseLinkStructConverterAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.StructConverter");
        converterAnnotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"bar", (String)converter.getName());
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.StructConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaStructConverterTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        converterAnnotation = (EclipseLinkStructConverterAnnotation)attributeResource.addAnnotation("org.eclipse.persistence.annotations.StructConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaStructConverterTests.assertNotNull((Object)eclipseLinkConvert.getConverter());
        converterAnnotation.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"FOO", (String)eclipseLinkConvert.getConverter().getName());
    }

    public void testGetConverterClass() throws Exception {
        this.createTestEntityWithConvertAndStructConverterClass();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkStructConverter converter = (EclipseLinkStructConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
    }

    public void testSetConverterClass() throws Exception {
        this.createTestEntityWithConvertAndStructConverterClass();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkStructConverter converter = (EclipseLinkStructConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
        converter.setConverterClass("Bar");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Bar", (String)converter.getConverterClass());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkStructConverterAnnotation converterAnnotation = (EclipseLinkStructConverterAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.StructConverter");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getConverter());
        converter.setConverterClass(null);
        EclipseLinkJavaStructConverterTests.assertEquals(null, (String)converter.getConverterClass());
        converterAnnotation = (EclipseLinkStructConverterAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.StructConverter");
        EclipseLinkJavaStructConverterTests.assertEquals(null, (String)converterAnnotation.getConverter());
        converter.setConverterClass("Bar");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Bar", (String)converter.getConverterClass());
        converterAnnotation = (EclipseLinkStructConverterAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.StructConverter");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getConverter());
    }

    public void testGetConverterClassUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndStructConverterClass();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkStructConverter converter = (EclipseLinkStructConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkStructConverterAnnotation converterAnnotation = (EclipseLinkStructConverterAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.StructConverter");
        converterAnnotation.setConverter("Bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Bar", (String)converter.getConverterClass());
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.StructConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaStructConverterTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        converterAnnotation = (EclipseLinkStructConverterAnnotation)attributeResource.addAnnotation("org.eclipse.persistence.annotations.StructConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaStructConverterTests.assertNotNull((Object)eclipseLinkConvert.getConverter());
        converterAnnotation.setConverter("FooBar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"FooBar", (String)((EclipseLinkStructConverter)eclipseLinkConvert.getConverter()).getConverterClass());
    }
}

