/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.util.EmptyStackException;
import org.eclipse.jpt.common.utility.internal.SimpleStack;
import org.eclipse.jpt.common.utility.internal.Stack;
import org.eclipse.jpt.common.utility.internal.SynchronizedStack;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.common.utility.tests.internal.SimpleStackTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedStackTests
extends SimpleStackTests {
    private volatile SynchronizedStack<String> ss;
    volatile boolean timeoutOccurred;
    volatile long startTime;
    volatile long endTime;
    volatile Object poppedObject;
    static final String ITEM_1 = new String();
    static final String ITEM_2 = new String();

    public SynchronizedStackTests(String name) {
        super(name);
    }

    @Override
    Stack<String> buildStack() {
        return new SynchronizedStack();
    }

    @Override
    public void testClone() {
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.ss = new SynchronizedStack();
        this.timeoutOccurred = false;
        this.startTime = 0L;
        this.endTime = 0L;
        this.poppedObject = null;
    }

    public void testConcurrentAccess() throws Exception {
        this.verifyConcurrentAccess(new SlowSimpleStack<String>(), "second");
        this.verifyConcurrentAccess(new SlowSynchronizedStack<String>(), "first");
    }

    private void verifyConcurrentAccess(SlowStack<String> slowStack, String expected) throws Exception {
        slowStack.push("first");
        slowStack.push("second");
        Thread thread = this.buildThread(this.buildRunnable(slowStack));
        thread.start();
        Thread.sleep(TWO_TICKS);
        SynchronizedStackTests.assertEquals((String)expected, (String)((String)slowStack.pop()));
        thread.join();
        SynchronizedStackTests.assertTrue((boolean)slowStack.isEmpty());
    }

    private Runnable buildRunnable(final SlowStack<String> slowStack) {
        return new Runnable(){

            public void run() {
                slowStack.slowPop();
            }
        };
    }

    public void testWaitToPop() throws Exception {
        this.verifyWaitToPop(0L);
        SynchronizedStackTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.poppedObject);
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToPopTimeout() throws Exception {
        this.verifyWaitToPop(TICK);
        SynchronizedStackTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertNull((Object)this.poppedObject);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.ss.peek());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToPop(long timeout) throws Exception {
        Runnable r1 = this.buildRunnable(this.buildPushCommand(), this.ss, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitToPopCommand(timeout), this.ss, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    public void testWaitToPush() throws Exception {
        this.verifyWaitToPush(0L);
        SynchronizedStackTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.poppedObject);
        SynchronizedStackTests.assertFalse((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertSame((Object)ITEM_2, (Object)this.ss.peek());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToPushTimeout() throws Exception {
        this.verifyWaitToPush(TICK);
        SynchronizedStackTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.poppedObject);
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToPush(long timeout) throws Exception {
        this.ss.push((Object)ITEM_1);
        Runnable r1 = this.buildRunnable(this.buildPopCommand(), this.ss, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitToPushCommand(timeout), this.ss, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildPushCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedStack<String> synchronizedStack) {
                synchronizedStack.push((Object)ITEM_1);
            }
        };
    }

    private Command buildWaitToPopCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedStack<String> synchronizedStack) throws InterruptedException {
                SynchronizedStackTests.this.startTime = System.currentTimeMillis();
                try {
                    SynchronizedStackTests.this.poppedObject = synchronizedStack.waitToPop(timeout);
                }
                catch (EmptyStackException emptyStackException) {
                    SynchronizedStackTests.this.timeoutOccurred = true;
                }
                SynchronizedStackTests.this.endTime = System.currentTimeMillis();
            }
        };
    }

    private Command buildPopCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedStack<String> synchronizedStack) {
                SynchronizedStackTests.this.poppedObject = synchronizedStack.pop();
            }
        };
    }

    private Command buildWaitToPushCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedStack<String> synchronizedStack) throws InterruptedException {
                SynchronizedStackTests.this.startTime = System.currentTimeMillis();
                SynchronizedStackTests.this.timeoutOccurred = !synchronizedStack.waitToPush((Object)ITEM_2, timeout);
                SynchronizedStackTests.this.endTime = System.currentTimeMillis();
            }
        };
    }

    private Runnable buildRunnable(final Command command, final SynchronizedStack<String> synchronizedStack, final long sleep) {
        return new MultiThreadedTestCase.TestRunnable(this){

            protected void run_() throws Throwable {
                if (sleep != 0L) {
                    Thread.sleep(sleep);
                }
                command.execute((SynchronizedStack<String>)synchronizedStack);
            }
        };
    }

    long calculateElapsedTime() {
        return this.endTime - this.startTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Command {
        public void execute(SynchronizedStack<String> var1) throws InterruptedException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SlowSimpleStack<E>
    extends SimpleStack<E>
    implements SlowStack<E> {
        SlowSimpleStack() {
        }

        @Override
        public Object slowPop() {
            try {
                Thread.sleep(5L * TICK);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return this.pop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SlowStack<E>
    extends Stack<E> {
        public Object slowPop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SlowSynchronizedStack<E>
    extends SynchronizedStack<E>
    implements SlowStack<E> {
        SlowSynchronizedStack() {
        }

        @Override
        public synchronized Object slowPop() {
            try {
                Thread.sleep(5L * TICK);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return this.pop();
        }
    }
}

