/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyRelationship;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.ManyToManyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.OrderByAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaManyToManyMappingTests
extends ContextModelTestCase {
    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithCollectionManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private Collection addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithNonCollectionManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private Address addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidMapManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestDepartment() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("import java.util.Map;");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.ManyToMany").append(";");
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Department").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private Map<Integer, Employee> employees;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Department.java", sourceWriter);
    }

    private void createTestEmployee() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Employee").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int empId;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Employee.java", sourceWriter);
    }

    public JavaManyToManyMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaManyToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Version"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToOne"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testUpdateSpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ManyToManyAnnotation manyToManyAnnotation = (ManyToManyAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToMany");
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedTargetEntity());
        JavaManyToManyMappingTests.assertNull((Object)manyToManyAnnotation.getTargetEntity());
        manyToManyAnnotation.setTargetEntity("newTargetEntity");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToManyMapping.getSpecifiedTargetEntity());
        JavaManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToManyAnnotation.getTargetEntity());
        manyToManyAnnotation.setTargetEntity(null);
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedTargetEntity());
        JavaManyToManyMappingTests.assertNull((Object)manyToManyAnnotation.getTargetEntity());
    }

    public void testModifySpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToMany");
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedTargetEntity());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity("newTargetEntity");
        JavaManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToManyMapping.getSpecifiedTargetEntity());
        JavaManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToMany.getTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedTargetEntity());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToMany");
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getFetch());
        manyToMany.setFetch(org.eclipse.jpt.jpa.core.resource.java.FetchType.EAGER);
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.EAGER, (Object)manyToMany.getFetch());
        manyToMany.setFetch(org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY);
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY, (Object)manyToMany.getFetch());
        manyToMany.setFetch(null);
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToMany");
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getFetch());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        JavaManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.EAGER, (Object)manyToMany.getFetch());
        manyToManyMapping.setSpecifiedFetch(FetchType.LAZY);
        JavaManyToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY, (Object)manyToMany.getFetch());
        manyToManyMapping.setSpecifiedFetch(null);
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getFetch());
    }

    public void testUpdateMappedBy() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToMany");
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
        manyToMany.setMappedBy("newMappedBy");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)manyToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        JavaManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)manyToMany.getMappedBy());
        manyToMany.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
    }

    public void testModifyMappedBy() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToMany");
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
        manyToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("newTargetEntity");
        JavaManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        JavaManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToMany.getMappedBy());
        manyToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute(null);
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        ManyToManyAnnotation annotation = (ManyToManyAnnotation)resourceAttribute.getAnnotation("javax.persistence.ManyToMany");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping mapping = (ManyToManyMapping)contextAttribute.getMapping();
        ManyToManyRelationship rel = mapping.getRelationship();
        JavaManyToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaManyToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        JavaManyToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToMappedBy();
        JavaManyToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        JavaManyToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        JavaManyToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinTable();
        JavaManyToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaManyToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        JavaManyToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        ManyToManyAnnotation annotation = (ManyToManyAnnotation)resourceAttribute.getAnnotation("javax.persistence.ManyToMany");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping mapping = (ManyToManyMapping)contextAttribute.getMapping();
        ManyToManyRelationship rel = mapping.getRelationship();
        JavaManyToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaManyToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        JavaManyToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        annotation.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        JavaManyToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        JavaManyToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceAttribute.addAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        JavaManyToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        JavaManyToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        annotation.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaManyToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        JavaManyToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceAttribute.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaManyToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        JavaManyToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        JavaManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        JavaManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        JavaManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = manyToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        JavaManyToManyMappingTests.assertNull((Object)stateFooMapping);
    }

    public void testDefaultTargetEntity() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaManyToManyMappingTests.assertEquals((String)"test.Address", (String)manyToManyMapping.getDefaultTargetEntity());
        this.addXmlClassRef("test.Address");
        JavaManyToManyMappingTests.assertEquals((String)"test.Address", (String)manyToManyMapping.getDefaultTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        JavaManyToManyMappingTests.assertEquals((String)"test.Address", (String)manyToManyMapping.getDefaultTargetEntity());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaPersistentType addressPersistentType = addressClassRef.getJavaPersistentType();
        addressPersistentType.setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaManyToManyMappingTests.assertEquals((String)"test.Address", (String)manyToManyMapping.getDefaultTargetEntity());
    }

    public void testDefaultTargetEntityCollectionType() throws Exception {
        this.createTestEntityWithCollectionManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getDefaultTargetEntity());
    }

    public void testDefaultTargetEntityNonCollectionType() throws Exception {
        this.createTestEntityWithNonCollectionManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getDefaultTargetEntity());
    }

    public void testTargetEntity() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaManyToManyMappingTests.assertEquals((String)"test.Address", (String)manyToManyMapping.getTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        JavaManyToManyMappingTests.assertEquals((String)"foo", (String)manyToManyMapping.getTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        JavaManyToManyMappingTests.assertEquals((String)"test.Address", (String)manyToManyMapping.getTargetEntity());
    }

    public void testResolvedTargetEntity() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getResolvedTargetEntity());
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.Address");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaTypeMapping addressTypeMapping = addressClassRef.getJavaPersistentType().getMapping();
        JavaManyToManyMappingTests.assertEquals((Object)addressTypeMapping, (Object)manyToManyMapping.getResolvedTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getResolvedTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity("test.Address");
        JavaManyToManyMappingTests.assertEquals((Object)addressTypeMapping, (Object)manyToManyMapping.getResolvedTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        JavaManyToManyMappingTests.assertEquals((Object)addressTypeMapping, (Object)manyToManyMapping.getResolvedTargetEntity());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
        attributeResource.addAnnotation("javax.persistence.MapKey");
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        JavaManyToManyMappingTests.assertNotNull((Object)mapKey);
        mapKey.setName("myMapKey");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertEquals((String)"myMapKey", (String)manyToManyMapping.getSpecifiedMapKey());
        JavaManyToManyMappingTests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        mapKey.setName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        JavaManyToManyMappingTests.assertNull((Object)mapKey.getName());
        mapKey.setName("myMapKey");
        attributeResource.removeAnnotation("javax.persistence.MapKey");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
    }

    public void testModifyMapKey() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
        manyToManyMapping.setSpecifiedMapKey("myMapKey");
        MapKeyAnnotation mapKeyAnnotation = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        JavaManyToManyMappingTests.assertEquals((String)"myMapKey", (String)manyToManyMapping.getSpecifiedMapKey());
        JavaManyToManyMappingTests.assertEquals((String)"myMapKey", (String)mapKeyAnnotation.getName());
        manyToManyMapping.setSpecifiedMapKey(null);
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        mapKeyAnnotation = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        JavaManyToManyMappingTests.assertNull((Object)mapKeyAnnotation.getName());
        manyToManyMapping.setNoMapKey(true);
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping javaManyToManyMapping = (JavaManyToManyMapping)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = javaManyToManyMapping.candidateMapKeyNames();
        JavaManyToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        JavaManyToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping javaManyToManyMapping = (JavaManyToManyMapping)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = javaManyToManyMapping.candidateMapKeyNames();
        JavaManyToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaManyToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = javaManyToManyMapping.candidateMapKeyNames();
        JavaManyToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        JavaManyToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testUpdateOrderBy() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getOrderable().getSpecifiedOrderBy());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        attributeResource.addAnnotation("javax.persistence.OrderBy");
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        orderBy.setValue("newOrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)manyToManyMapping.getOrderable().getSpecifiedOrderBy());
        JavaManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)orderBy.getValue());
        attributeResource.removeAnnotation("javax.persistence.OrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getOrderable().getSpecifiedOrderBy());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testModifyOrderBy() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getOrderable().getSpecifiedOrderBy());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("newOrderBy");
        JavaManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)manyToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        JavaManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)orderBy.getValue());
        manyToManyMapping.getOrderable().setSpecifiedOrderBy(null);
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getOrderable().getSpecifiedOrderBy());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testUpdateNoOrdering() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertTrue((boolean)manyToManyMapping.getOrderable().isNoOrdering());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        attributeResource.addAnnotation("javax.persistence.OrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.getOrderable().isNoOrdering());
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        orderBy.setValue("newOrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.getOrderable().isNoOrdering());
        attributeResource.removeAnnotation("javax.persistence.OrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertTrue((boolean)manyToManyMapping.getOrderable().isNoOrdering());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testModifyNoOrdering() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertTrue((boolean)manyToManyMapping.getOrderable().isNoOrdering());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testUpdatePkOrdering() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.getOrderable().isPkOrdering());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        attributeResource.addAnnotation("javax.persistence.OrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertTrue((boolean)manyToManyMapping.getOrderable().isPkOrdering());
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        orderBy.setValue("newOrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.getOrderable().isPkOrdering());
        attributeResource.removeAnnotation("javax.persistence.OrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.getOrderable().isPkOrdering());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testUpdateCustomOrdering() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.getOrderable().isCustomOrdering());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        attributeResource.addAnnotation("javax.persistence.OrderBy");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.getOrderable().isCustomOrdering());
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        orderBy.setValue("newOrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertTrue((boolean)manyToManyMapping.getOrderable().isCustomOrdering());
        attributeResource.removeAnnotation("javax.persistence.OrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.getOrderable().isCustomOrdering());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testDefaultTargetEntityForMap() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.addXmlClassRef("test.Department");
        this.addXmlClassRef("test.Employee");
        JavaPersistentType departmentPersistentType = this.getJavaPersistentType();
        ManyToManyMapping employeesMapping = (ManyToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        JavaManyToManyMappingTests.assertEquals((String)"test.Employee", (String)employeesMapping.getTargetEntity());
    }
}

