/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaOneToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.Cascade2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToManyRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrphanRemovalHolder2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOneToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOneToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOneToManyRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOrphanRemovable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOrphanRemovalHolder2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOneToMany;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericOrmOneToManyMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericOrmOneToManyMapping2_0Tests(String name) {
        super(name);
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityWithValidOneToManyMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.convertToSpecified();
        }
    }

    private ICompilationUnit createTestEntityWithValidMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    private String abbr;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithValidGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.FetchType", "javax.persistence.CascadeType", "javax.persistence.OrderBy"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany(fetch=FetchType.EAGER, targetEntity=Address.class, orphanRemoval = true, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.DETACH})");
                sb.append(CR);
                sb.append("    @OrderBy(\"city\"");
                sb.append(CR);
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addSpecifiedAttribute("oneToMany", "addresses");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        ReadOnlyPersistentAttribute persistentAttribute = (ReadOnlyPersistentAttribute)ormPersistentType.attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.name", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.name", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.name");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"name", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addSpecifiedAttribute("oneToMany", "addresses");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        ReadOnlyPersistentAttribute persistentAttribute = (ReadOnlyPersistentAttribute)ormPersistentType.attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.name", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.name", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.name");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"name", (String)stateFooMapping.getName());
    }

    private OrmOrphanRemovable2_0 getOrphanRemovalOf(OneToManyMapping2_0 oneToManyMapping) {
        return ((OrmOrphanRemovalHolder2_0)oneToManyMapping).getOrphanRemoval();
    }

    public void testUpdateSpecifiedOrphanRemoval() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        OrmOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf((OneToManyMapping2_0)ormOneToManyMapping);
        XmlOneToMany oneToManyResource = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToManyMapping2_0Tests.assertEquals(null, (Object)oneToManyResource.getOrphanRemoval());
        oneToManyResource.setOrphanRemoval(Boolean.TRUE);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToManyResource.getOrphanRemoval());
        oneToManyResource.setOrphanRemoval(Boolean.FALSE);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)oneToManyResource.getOrphanRemoval());
    }

    public void testModifySpecifiedOrphanRemoval() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        OrmOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf((OneToManyMapping2_0)ormOneToManyMapping);
        XmlOneToMany oneToManyResource = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToManyMapping2_0Tests.assertEquals(null, (Object)oneToManyResource.getOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToManyResource.getOrphanRemoval());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.FALSE);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)oneToManyResource.getOrphanRemoval());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testUpdateMapKey() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKey());
        oneToMany.setMapKey(OrmFactory.eINSTANCE.createMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)oneToMany.getMapKey());
        oneToMany.getMapKey().setName("myMapKey");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)oneToMany.getMapKey().getName());
        oneToMany.getMapKey().setName(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKey().getName());
        oneToMany.getMapKey().setName("myMapKey");
        oneToMany.setMapKey(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKey());
    }

    public void testUpdateVirtualMapKey() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isPkMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isCustomMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)oneToManyMapping.isNoMapKey());
        javaOneToManyMapping.setPkMapKey(true);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)oneToManyMapping.getMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)oneToManyMapping.isPkMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isCustomMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isNoMapKey());
        javaOneToManyMapping.setCustomMapKey(true);
        javaOneToManyMapping.setSpecifiedMapKey("city");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)oneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)oneToManyMapping.getMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isPkMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)oneToManyMapping.isCustomMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isNoMapKey());
    }

    public void testModifyMapKey() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKey());
        ormOneToManyMapping.setSpecifiedMapKey("myMapKey");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)oneToMany.getMapKey().getName());
        ormOneToManyMapping.setSpecifiedMapKey(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKey().getName());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = oneToManyMapping.candidateMapKeyNames();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = oneToManyMapping.candidateMapKeyNames();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaOneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = oneToManyMapping.candidateMapKeyNames();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
        ormPersistentType.getAttributeNamed("addresses").convertToSpecified();
        oneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        mapKeyNames = oneToManyMapping.candidateMapKeyNames();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = oneToManyMapping.candidateMapKeyNames();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("String");
        mapKeyNames = oneToManyMapping.candidateMapKeyNames();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKeyClass());
        oneToMany.setMapKeyClass(OrmFactory.eINSTANCE.createXmlClassReference());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)oneToMany.getMapKeyClass());
        oneToMany.getMapKeyClass().setClassName("String");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"String", (String)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"String", (String)oneToMany.getMapKeyClass().getClassName());
        oneToMany.getMapKeyClass().setClassName(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKeyClass().getClassName());
        oneToMany.getMapKeyClass().setClassName("String");
        oneToMany.setMapKeyClass(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKeyClass());
    }

    public void testUpdateVirtualMapKeyClass() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"java.lang.String", (String)oneToManyMapping.getMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"java.lang.String", (String)oneToManyMapping.getDefaultMapKeyClass());
        javaOneToManyMapping.setSpecifiedMapKeyClass("Integer");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"Integer", (String)oneToManyMapping.getMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"Integer", (String)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"java.lang.String", (String)oneToManyMapping.getDefaultMapKeyClass());
    }

    public void testModifyMapKeyClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKeyClass());
        ormOneToManyMapping.setSpecifiedMapKeyClass("String");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"String", (String)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"String", (String)oneToMany.getMapKeyClass().getClassName());
        ormOneToManyMapping.setSpecifiedMapKeyClass(null);
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToMany.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintQueue");
        this.getEntityMappings().addPersistentType("entity", "test.PrintJob");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "jobs");
        OrmOneToManyMapping oneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        oneToManyMapping.getRelationship().setStrategyToMappedBy();
        oneToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("queue");
        Orderable2_0 orderable = (Orderable2_0)oneToManyMapping.getOrderable();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        orderable.setOrderColumnOrdering(true);
        OrderColumn2_0 orderColumn = orderable.getOrderColumn();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals(null, (String)orderColumn.getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)orderColumn.getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"PrintJob", (String)orderColumn.getTable());
        orderColumn.setSpecifiedName("FOO");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)orderColumn.getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)orderColumn.getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"PrintJob", (String)orderColumn.getTable());
        OrmPersistentType printJobPersistentType = (OrmPersistentType)this.getPersistenceUnit().getPersistentType("test.PrintJob");
        ((Entity)printJobPersistentType.getMapping()).getTable().setSpecifiedName("MY_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"MY_TABLE", (String)orderColumn.getTable());
    }

    public void testVirtualOrderColumn() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintQueue");
        this.getEntityMappings().addPersistentType("entity", "test.PrintJob");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "jobs");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        Orderable2_0 orderable = (Orderable2_0)oneToManyMapping.getOrderable();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        ((Orderable2_0)javaOneToManyMapping.getOrderable()).setOrderColumnOrdering(true);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("jobs");
        oneToManyMapping = (OneToManyMapping)ormPersistentAttribute2.getMapping();
        orderable = (Orderable2_0)oneToManyMapping.getOrderable();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)orderable.isNoOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"PrintJob", (String)orderable.getOrderColumn().getTable());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)orderable.getOrderColumn().getName());
        ((Orderable2_0)javaOneToManyMapping.getOrderable()).getOrderColumn().setSpecifiedName("FOO");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"PrintJob", (String)orderable.getOrderColumn().getTable());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)orderable.getOrderColumn().getName());
    }

    private void createTestEntityPrintQueue() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OneToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintQueue").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany(mappedBy=\"queue\")").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<PrintJob> jobs;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintQueue.java", sourceWriter);
    }

    private void createTestEntityPrintJob() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToOne");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintJob").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private PrintQueue queue;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintJob.java", sourceWriter);
    }

    public void testVirtualMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmReadOnlyPersistentAttribute addressesPersistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OneToManyMapping2_0 virtualAddressesMapping = (OneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        Column virtualColumn = virtualAddressesMapping.getMapKeyColumn();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)virtualColumn.getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualColumn.getTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)virtualColumn.getColumnDefinition());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)virtualColumn.isInsertable());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)virtualColumn.isUpdatable());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)virtualColumn.isNullable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)virtualColumn.isUnique());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)255, (int)virtualColumn.getLength());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)0, (int)virtualColumn.getPrecision());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)0, (int)virtualColumn.getScale());
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedTable("FOO_TABLE");
        javaOneToManyMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)virtualColumn.getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO_TABLE", (String)virtualColumn.getTable());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualColumn.getColumnDefinition());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)virtualColumn.isInsertable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)virtualColumn.isUpdatable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)virtualColumn.isNullable());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)virtualColumn.isUnique());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)45, (int)virtualColumn.getLength());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)46, (int)virtualColumn.getPrecision());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)47, (int)virtualColumn.getScale());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        addressesPersistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)addressesPersistentAttribute.getMappingKey());
    }

    public void testNullMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute addressesPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "addresses");
        OrmOneToManyMapping2_0 addressesVirtualMapping = (OrmOneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        Column ormColumn = addressesVirtualMapping.getMapKeyColumn();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedTable("FOO_TABLE");
        javaOneToManyMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)ormColumn.getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormColumn.getDefaultTable());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getColumnDefinition());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedNullable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedUnique());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedLength());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedScale());
    }

    public void testVirtualMapKeyColumnTable() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmReadOnlyPersistentAttribute addressesPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OneToManyMapping2_0 virtualAddressesMapping = (OneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        Column virtualColumn = virtualAddressesMapping.getMapKeyColumn();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualColumn.getTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)virtualColumn.getSpecifiedTable());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ORM_TABLE_Address", (String)virtualColumn.getTable());
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaOneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"JAVA_JOIN_TABLE", (String)virtualColumn.getTable());
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedTable("JAVA_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"JAVA_TABLE", (String)virtualColumn.getTable());
        addressesPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "addresses");
        OneToManyMapping2_0 specifiedAddressesMapping = (OneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        Column specifiedColumn = specifiedAddressesMapping.getMapKeyColumn();
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)specifiedColumn.getSpecifiedTable());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ORM_TABLE_Address", (String)specifiedColumn.getDefaultTable());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("addresses");
        OrmOneToManyMapping2_0 contextMapping = (OrmOneToManyMapping2_0)contextAttribute.getMapping();
        OrmOneToManyRelationship2_0 rel = (OrmOneToManyRelationship2_0)contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToMany resourceMapping = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinColumn();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToMappedBy();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinTable();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("addresses");
        OrmOneToManyMapping2_0 contextMapping = (OrmOneToManyMapping2_0)contextAttribute.getMapping();
        OrmOneToManyRelationship2_0 rel = (OrmOneToManyRelationship2_0)contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToMany resourceMapping = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.setJoinTable(null);
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testTargetForeignKeyJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType ormTargetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmReadOnlyPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)persistentAttribute.getJavaPersistentAttribute().getMapping();
        OneToManyRelationship2_0 rr = (OneToManyRelationship2_0)javaOneToManyMapping.getRelationship();
        rr.setStrategyToJoinColumn();
        JoinColumn joinColumn = (JoinColumn)rr.getJoinColumnStrategy().joinColumns().next();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)persistentAttribute.isVirtual());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)joinColumn.getDefaultTable());
        JavaEntity addressEntity = (JavaEntity)ormTargetPersistentType.getJavaPersistentType().getMapping();
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
        persistentAttribute.convertToSpecified();
        persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        oneToManyMapping = (OrmOneToManyMapping2_0)persistentAttribute.getMapping();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.isVirtual());
        rr = (OneToManyRelationship2_0)oneToManyMapping.getRelationship();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rr.strategyIsJoinColumn());
        rr.setStrategyToJoinColumn();
        joinColumn = (JoinColumn)rr.getJoinColumnStrategy().specifiedJoinColumns().next();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.isVirtual());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
        OrmEntity ormAddressEntity = (OrmEntity)ormTargetPersistentType.getMapping();
        ormAddressEntity.getTable().setSpecifiedName("ORM_ADDRESS_PRIMARY_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
        joinColumn.setSpecifiedName("FOO");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)joinColumn.getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
    }

    public void testGetMapKeyColumnJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType ormTargetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmReadOnlyPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)persistentAttribute.getJavaPersistentAttribute().getMapping();
        OneToManyRelationship2_0 rr = (OneToManyRelationship2_0)javaOneToManyMapping.getRelationship();
        rr.setStrategyToJoinColumn();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)persistentAttribute.isVirtual());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)oneToManyMapping.getMapKeyColumn().getTable());
        JavaEntity addressEntity = (JavaEntity)ormTargetPersistentType.getJavaPersistentType().getMapping();
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getDefaultTable());
        persistentAttribute.convertToSpecified();
        persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        oneToManyMapping = (OrmOneToManyMapping2_0)persistentAttribute.getMapping();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.isVirtual());
        rr = (OneToManyRelationship2_0)oneToManyMapping.getRelationship();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rr.strategyIsJoinColumn());
        rr.setStrategyToJoinColumn();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTable());
        OrmEntity ormAddressEntity = (OrmEntity)ormTargetPersistentType.getMapping();
        ormAddressEntity.getTable().setSpecifiedName("ORM_ADDRESS_PRIMARY_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTable());
        oneToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getDefaultTable());
    }

    public void testOrderColumnDefaultsJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType ormTargetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmReadOnlyPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)persistentAttribute.getJavaPersistentAttribute().getMapping();
        OneToManyRelationship2_0 rr = (OneToManyRelationship2_0)javaOneToManyMapping.getRelationship();
        rr.setStrategyToJoinColumn();
        ((Orderable2_0)javaOneToManyMapping.getOrderable()).setOrderColumnOrdering(true);
        OrderColumn2_0 orderColumn = ((Orderable2_0)oneToManyMapping.getOrderable()).getOrderColumn();
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)orderColumn.getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getDefaultName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)orderColumn.getTable());
        JavaEntity addressEntity = (JavaEntity)ormTargetPersistentType.getJavaPersistentType().getMapping();
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTable());
        persistentAttribute.convertToSpecified();
        persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        oneToManyMapping = (OrmOneToManyMapping2_0)persistentAttribute.getMapping();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.isVirtual());
        rr = (OneToManyRelationship2_0)oneToManyMapping.getRelationship();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)rr.strategyIsJoinColumn());
        rr.setStrategyToJoinColumn();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)((Orderable2_0)oneToManyMapping.getOrderable()).isOrderColumnOrdering());
        ((Orderable2_0)oneToManyMapping.getOrderable()).setOrderColumnOrdering(true);
        orderColumn = ((Orderable2_0)oneToManyMapping.getOrderable()).getOrderColumn();
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)orderColumn.getSpecifiedName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTable());
        OrmEntity ormAddressEntity = (OrmEntity)ormTargetPersistentType.getMapping();
        ormAddressEntity.getTable().setSpecifiedName("ORM_ADDRESS_PRIMARY_TABLE");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTable());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OneToManyMapping virtualOneToManyMapping = (OneToManyMapping)virtualPersistentAttribute.getMapping();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"address", (String)virtualOneToManyMapping.getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)FetchType.EAGER, (Object)virtualOneToManyMapping.getSpecifiedFetch());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)virtualOneToManyMapping.getSpecifiedTargetEntity());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)virtualOneToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        Cascade2_0 cascade = (Cascade2_0)virtualOneToManyMapping.getCascade();
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)cascade.isAll());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)cascade.isMerge());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)cascade.isPersist());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)cascade.isRemove());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)cascade.isRefresh());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)cascade.isDetach());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)virtualOneToManyMapping.getOrderable().isCustomOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"city", (String)virtualOneToManyMapping.getOrderable().getSpecifiedOrderBy());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)((OrphanRemovalHolder2_0)virtualOneToManyMapping).getOrphanRemoval().isOrphanRemoval());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmOneToManyMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)virtualPersistentAttribute.getMappingKey());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        virtualPersistentAttribute.convertToSpecified("oneToMany");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"address", (String)ormOneToManyMapping.getName());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToManyMapping.getFetch());
        GenericOrmOneToManyMapping2_0Tests.assertEquals((String)"test.Address", (String)ormOneToManyMapping.getTargetEntity());
        GenericOrmOneToManyMapping2_0Tests.assertNull((Object)ormOneToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        Cascade2_0 cascade = (Cascade2_0)ormOneToManyMapping.getCascade();
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)cascade.isAll());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)cascade.isMerge());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)cascade.isPersist());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)cascade.isRemove());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)cascade.isRefresh());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)cascade.isDetach());
        GenericOrmOneToManyMapping2_0Tests.assertTrue((boolean)ormOneToManyMapping.getOrderable().isNoOrdering());
        GenericOrmOneToManyMapping2_0Tests.assertEquals(null, (String)ormOneToManyMapping.getOrderable().getSpecifiedOrderBy());
        GenericOrmOneToManyMapping2_0Tests.assertFalse((boolean)((OrmOrphanRemovalHolder2_0)ormOneToManyMapping).getOrphanRemoval().isOrphanRemoval());
    }
}

