/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class MapKeyColumn2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String COLUMN_TABLE = "MY_TABLE";
    private static final String COLUMN_COLUMN_DEFINITION = "COLUMN_DEFINITION";

    public MapKeyColumn2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestColumn() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyColumn");
            }
        });
    }

    private ICompilationUnit createTestColumnWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyColumn(name = \"MY_COLUMN\")");
            }
        });
    }

    private ICompilationUnit createTestColumnWithTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyColumn(table = \"MY_TABLE\")");
            }
        });
    }

    private ICompilationUnit createTestColumnWithColumnDefinition() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyColumn(columnDefinition = \"COLUMN_DEFINITION\")");
            }
        });
    }

    private ICompilationUnit createTestColumnWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyColumn(" + booleanElement + " = true)");
            }
        });
    }

    private ICompilationUnit createTestColumnWithIntElement(final String intElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyColumn(" + intElement + " = 5)");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyColumn2_0AnnotationTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getName());
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getNullable());
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getInsertable());
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getUnique());
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getUpdatable());
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getTable());
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getName());
        column.setName("Foo");
        MapKeyColumn2_0AnnotationTests.assertEquals((String)"Foo", (String)column.getName());
        this.assertSourceContains("@MapKeyColumn(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName(null);
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getName());
        this.assertSourceDoesNotContain("@MapKeyColumn(", cu);
    }

    public void testGetTable() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertEquals((String)COLUMN_TABLE, (String)column.getTable());
    }

    public void testSetTable() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getTable());
        column.setTable("Foo");
        MapKeyColumn2_0AnnotationTests.assertEquals((String)"Foo", (String)column.getTable());
        this.assertSourceContains("@MapKeyColumn(table = \"Foo\")", cu);
        column.setTable(null);
        this.assertSourceDoesNotContain("@MapKeyColumn(", cu);
    }

    public void testGetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithColumnDefinition();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertEquals((String)COLUMN_COLUMN_DEFINITION, (String)column.getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getColumnDefinition());
        column.setColumnDefinition("Foo");
        MapKeyColumn2_0AnnotationTests.assertEquals((String)"Foo", (String)column.getColumnDefinition());
        this.assertSourceContains("@MapKeyColumn(columnDefinition = \"Foo\")", cu);
        column.setColumnDefinition(null);
        this.assertSourceDoesNotContain("@MapKeyColumn(", cu);
    }

    public void testGetUnique() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithBooleanElement("unique");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)column.getUnique());
    }

    public void testSetUnique() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getUnique());
        column.setUnique(Boolean.FALSE);
        MapKeyColumn2_0AnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)column.getUnique());
        this.assertSourceContains("@MapKeyColumn(unique = false)", cu);
        column.setUnique(null);
        this.assertSourceDoesNotContain("@MapKeyColumn(", cu);
    }

    public void testGetNullable() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithBooleanElement("nullable");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)column.getNullable());
    }

    public void testSetNullable() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getNullable());
        column.setNullable(Boolean.FALSE);
        MapKeyColumn2_0AnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)column.getNullable());
        this.assertSourceContains("@MapKeyColumn(nullable = false)", cu);
        column.setNullable(null);
        this.assertSourceDoesNotContain("@MapKeyColumn(", cu);
    }

    public void testGetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithBooleanElement("insertable");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)column.getInsertable());
    }

    public void testSetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getInsertable());
        column.setInsertable(Boolean.FALSE);
        MapKeyColumn2_0AnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)column.getInsertable());
        this.assertSourceContains("@MapKeyColumn(insertable = false)", cu);
        column.setInsertable(null);
        this.assertSourceDoesNotContain("@MapKeyColumn(", cu);
    }

    public void testGetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithBooleanElement("updatable");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)column.getUpdatable());
    }

    public void testSetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getUpdatable());
        column.setUpdatable(Boolean.FALSE);
        MapKeyColumn2_0AnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)column.getUpdatable());
        this.assertSourceContains("@MapKeyColumn(updatable = false)", cu);
        column.setUpdatable(null);
        this.assertSourceDoesNotContain("@MapKeyColumn(", cu);
    }

    public void testGetLength() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithIntElement("length");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertEquals((Object)5, (Object)column.getLength());
    }

    public void testSetLength() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getLength());
        column.setLength(Integer.valueOf(5));
        MapKeyColumn2_0AnnotationTests.assertEquals((Object)5, (Object)column.getLength());
        this.assertSourceContains("@MapKeyColumn(length = 5)", cu);
        column.setLength(null);
        this.assertSourceDoesNotContain("@MapKeyColumn(", cu);
    }

    public void testGetPrecision() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithIntElement("precision");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertEquals((Object)5, (Object)column.getPrecision());
    }

    public void testSetPrecision() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyColumn2_0AnnotationTests.assertEquals(null, (Object)column.getPrecision());
        column.setPrecision(Integer.valueOf(5));
        MapKeyColumn2_0AnnotationTests.assertEquals((Object)5, (Object)column.getPrecision());
        this.assertSourceContains("@MapKeyColumn(precision = 5)", cu);
        column.setPrecision(null);
        this.assertSourceDoesNotContain("@MapKeyColumn(", cu);
    }

    public void testGetScale() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithIntElement("scale");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertEquals((Object)5, (Object)column.getScale());
    }

    public void testSetScale() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyColumn");
        MapKeyColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyColumn2_0AnnotationTests.assertNull((Object)column.getScale());
        column.setScale(Integer.valueOf(5));
        MapKeyColumn2_0AnnotationTests.assertEquals((Object)5, (Object)column.getScale());
        this.assertSourceContains("@MapKeyColumn(scale = 5)", cu);
        column.setScale(null);
        this.assertSourceDoesNotContain("@MapKeyColumn(", cu);
    }
}

