/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class JoinColumnsTests
extends JpaJavaResourceModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String COLUMN_TABLE = "MY_TABLE";
    private static final String COLUMN_COLUMN_DEFINITION = "COLUMN_DEFINITION";
    private static final String COLUMN_REFERENCED_COLUMN_NAME = "MY_REF_COLUMN_NAME";

    public JoinColumnsTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestJoinColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinColumn", "javax.persistence.JoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumns(@JoinColumn)");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinColumn", "javax.persistence.JoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumns(@JoinColumn(name = \"MY_COLUMN\"))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinColumn", "javax.persistence.JoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumns(@JoinColumn(table = \"MY_TABLE\"))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithReferencedColumnName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinColumn", "javax.persistence.JoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumns(@JoinColumn(referencedColumnName = \"MY_REF_COLUMN_NAME\"))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithColumnDefinition() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinColumn", "javax.persistence.JoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumns(@JoinColumn(columnDefinition = \"COLUMN_DEFINITION\"))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinColumn", "javax.persistence.JoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumns(@JoinColumn(" + booleanElement + " = true))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumn() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinColumn", "javax.persistence.JoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\")");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getName());
        JoinColumnsTests.assertNull((Object)column.getNullable());
        JoinColumnsTests.assertNull((Object)column.getInsertable());
        JoinColumnsTests.assertNull((Object)column.getUnique());
        JoinColumnsTests.assertNull((Object)column.getUpdatable());
        JoinColumnsTests.assertNull((Object)column.getTable());
        JoinColumnsTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getName());
        column.setName("Foo");
        JoinColumnsTests.assertEquals((String)"Foo", (String)column.getName());
        this.assertSourceContains("@JoinColumns(@JoinColumn(name = \"Foo\"))", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName(null);
        JoinColumnsTests.assertNull((Object)column.getName());
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testGetTable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertEquals((String)COLUMN_TABLE, (String)column.getTable());
    }

    public void testSetTable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getTable());
        column.setTable("Foo");
        JoinColumnsTests.assertEquals((String)"Foo", (String)column.getTable());
        this.assertSourceContains("@JoinColumns(@JoinColumn(table = \"Foo\"))", cu);
        column.setTable(null);
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testGetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithReferencedColumnName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertEquals((String)COLUMN_REFERENCED_COLUMN_NAME, (String)column.getReferencedColumnName());
    }

    public void testSetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getReferencedColumnName());
        column.setReferencedColumnName("Foo");
        JoinColumnsTests.assertEquals((String)"Foo", (String)column.getReferencedColumnName());
        this.assertSourceContains("@JoinColumns(@JoinColumn(referencedColumnName = \"Foo\"))", cu);
        column.setReferencedColumnName(null);
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testGetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithColumnDefinition();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertEquals((String)COLUMN_COLUMN_DEFINITION, (String)column.getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getColumnDefinition());
        column.setColumnDefinition("Foo");
        JoinColumnsTests.assertEquals((String)"Foo", (String)column.getColumnDefinition());
        this.assertSourceContains("@JoinColumns(@JoinColumn(columnDefinition = \"Foo\"))", cu);
        column.setColumnDefinition(null);
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testGetUnique() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("unique");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertTrue((boolean)column.getUnique());
    }

    public void testSetUnique() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getUnique());
        column.setUnique(Boolean.FALSE);
        JoinColumnsTests.assertFalse((boolean)column.getUnique());
        this.assertSourceContains("@JoinColumns(@JoinColumn(unique = false))", cu);
        column.setUnique(null);
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testGetNullable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("nullable");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertTrue((boolean)column.getNullable());
    }

    public void testSetNullable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getNullable());
        column.setNullable(Boolean.FALSE);
        JoinColumnsTests.assertFalse((boolean)column.getNullable());
        this.assertSourceContains("@JoinColumns(@JoinColumn(nullable = false))", cu);
        column.setNullable(null);
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testGetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("insertable");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertTrue((boolean)column.getInsertable());
    }

    public void testSetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getInsertable());
        column.setInsertable(Boolean.FALSE);
        JoinColumnsTests.assertFalse((boolean)column.getInsertable());
        this.assertSourceContains("@JoinColumns(@JoinColumn(insertable = false))", cu);
        column.setInsertable(null);
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testGetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("updatable");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertTrue((boolean)column.getUpdatable());
    }

    public void testSetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns").next();
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getUpdatable());
        column.setUpdatable(Boolean.FALSE);
        JoinColumnsTests.assertFalse((boolean)column.getUpdatable());
        this.assertSourceContains("@JoinColumns(@JoinColumn(updatable = false))", cu);
        column.setUpdatable(null);
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testAddJoinColumnCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)attributeResource.addAnnotation(1, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumn.setName("FOO");
        this.assertSourceContains("@JoinColumns({@JoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", table = \"TABLE\", unique = false, nullable = false, insertable = false, updatable = false, referencedColumnName = \"REF_NAME\"),@JoinColumn(name = \"FOO\")})", cu);
        JoinColumnsTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumn"));
        JoinColumnsTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumns"));
        JoinColumnsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns")));
    }

    public void testAddJoinColumnToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)attributeResource.addAnnotation(1, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumn.setName("FOO");
        this.assertSourceContains("@JoinColumns({@JoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", table = \"TABLE\", unique = false, nullable = false, insertable = false, updatable = false, referencedColumnName = \"REF_NAME\"),@JoinColumn(name = \"FOO\")})", cu);
        joinColumn = (JoinColumnAnnotation)attributeResource.addAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumn.setName("BAZ");
        this.assertSourceContains("@JoinColumns({@JoinColumn(name = \"BAZ\"),@JoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", table = \"TABLE\", unique = false, nullable = false, insertable = false, updatable = false, referencedColumnName = \"REF_NAME\"), @JoinColumn(name = \"FOO\")})", cu);
        Iterator joinColumns = attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JoinColumnsTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        JoinColumnsTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        JoinColumnsTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        JoinColumnsTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumn"));
        JoinColumnsTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumns"));
        JoinColumnsTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns")));
    }

    public void testRemoveJoinColumnCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)attributeResource.addAnnotation(1, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumn.setName("FOO");
        this.assertSourceContains("@JoinColumns({@JoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", table = \"TABLE\", unique = false, nullable = false, insertable = false, updatable = false, referencedColumnName = \"REF_NAME\"),@JoinColumn(name = \"FOO\")})", cu);
        attributeResource.removeAnnotation(1, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        this.assertSourceContains("@JoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", table = \"TABLE\", unique = false, nullable = false, insertable = false, updatable = false, referencedColumnName = \"REF_NAME\")", cu);
    }
}

