/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class MapKeyTests
extends JpaJavaResourceModelTestCase {
    public MapKeyTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMapKey() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKey"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKey");
            }
        });
    }

    private ICompilationUnit createTestMapKeyWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKey"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKey(name = \"key\")");
            }
        });
    }

    public void testMapKey() throws Exception {
        ICompilationUnit cu = this.createTestMapKey();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        MapKeyTests.assertNotNull((Object)mapKey);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        MapKeyTests.assertEquals((String)"key", (String)mapKey.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestMapKey();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        mapKey.setName("foo");
        this.assertSourceContains("@MapKey(name = \"foo\")", cu);
        mapKey.setName(null);
        this.assertSourceContains("@MapKey", cu);
        this.assertSourceDoesNotContain("@MapKey(name = \"foo\")", cu);
    }
}

