/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class NamedQueryTests
extends JpaJavaResourceModelTestCase {
    private static final String QUERY_NAME = "myQuery";
    private static final String QUERY_QUERY = "SELECT name FROM Employee";

    public NamedQueryTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestNamedQuery() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedQuery");
            }
        });
    }

    private ICompilationUnit createTestNamedQueryWithName() throws Exception {
        return this.createTestNamedQueryWithStringElement("name", QUERY_NAME);
    }

    private ICompilationUnit createTestNamedQueryWithQuery() throws Exception {
        return this.createTestNamedQueryWithStringElement("query", QUERY_QUERY);
    }

    private ICompilationUnit createTestNamedQueryWithStringElement(final String elementName, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedQuery(" + elementName + " = \"" + value + "\")");
            }
        });
    }

    private ICompilationUnit createTestNamedQueryWithQueryHints() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedQuery", "javax.persistence.QueryHint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedQuery(hints = {@QueryHint(name = \"BAR\", value = \"FOO\"), @QueryHint})");
            }
        });
    }

    public void testNamedQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery");
        NamedQueryTests.assertNotNull((Object)namedQuery);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery");
        NamedQueryTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery");
        NamedQueryTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
        namedQuery.setName("foo");
        NamedQueryTests.assertEquals((String)"foo", (String)namedQuery.getName());
        this.assertSourceContains("@NamedQuery(name = \"foo\")", cu);
        namedQuery.setName(null);
        NamedQueryTests.assertNull((Object)namedQuery.getName());
        this.assertSourceDoesNotContain("@NamedQuery(", cu);
    }

    public void testGetQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery");
        NamedQueryTests.assertEquals((String)QUERY_QUERY, (String)namedQuery.getQuery());
    }

    public void testSetQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery");
        NamedQueryTests.assertEquals((String)QUERY_QUERY, (String)namedQuery.getQuery());
        namedQuery.setQuery("foo");
        NamedQueryTests.assertEquals((String)"foo", (String)namedQuery.getQuery());
        this.assertSourceContains("@NamedQuery(query = \"foo\")", cu);
        namedQuery.setQuery(null);
        NamedQueryTests.assertNull((Object)namedQuery.getQuery());
        this.assertSourceDoesNotContain("@NamedQuery(", cu);
    }

    public void testHints() throws Exception {
        ICompilationUnit cu = this.createTestNamedQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery");
        NamedQueryTests.assertEquals((int)0, (int)namedQuery.hintsSize());
    }

    public void testHints2() throws Exception {
        ICompilationUnit cu = this.createTestNamedQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery");
        namedQuery.addHint(0);
        namedQuery.addHint(1);
        NamedQueryTests.assertEquals((int)2, (int)namedQuery.hintsSize());
    }

    public void testHints3() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery");
        NamedQueryTests.assertEquals((int)2, (int)namedQuery.hintsSize());
        ListIterator iterator = namedQuery.hints();
        NamedQueryTests.assertEquals((String)"BAR", (String)((QueryHintAnnotation)iterator.next()).getName());
        NamedQueryTests.assertNull((Object)((QueryHintAnnotation)iterator.next()).getName());
    }

    public void testAddHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery");
        namedQuery.addHint(0).setName("FOO");
        namedQuery.addHint(1);
        QueryHintAnnotation queryHint = namedQuery.addHint(0);
        queryHint.setName("BAR");
        NamedQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedQueryTests.assertEquals((String)"FOO", (String)namedQuery.hintAt(1).getName());
        NamedQueryTests.assertNull((Object)namedQuery.hintAt(2).getName());
        this.assertSourceContains("@NamedQuery(hints = {@QueryHint(name = \"BAR\"),@QueryHint(name = \"FOO\"), @QueryHint})", cu);
    }

    public void testRemoveHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery");
        namedQuery.addHint(0).setName("BAZ");
        NamedQueryTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedQueryTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedQueryTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        namedQuery.removeHint(2);
        NamedQueryTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedQueryTests.assertEquals((int)2, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedQuery(hints = {@QueryHint(name = \"BAZ\"), @QueryHint(name = \"BAR\", value = \"FOO\")})", cu);
        namedQuery.removeHint(0);
        NamedQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedQueryTests.assertEquals((int)1, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedQuery(hints = @QueryHint(name = \"BAR\", value = \"FOO\"))", cu);
        namedQuery.removeHint(0);
        NamedQueryTests.assertEquals((int)0, (int)namedQuery.hintsSize());
        this.assertSourceDoesNotContain("@NamedQuery(", cu);
    }

    public void testMoveHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery");
        namedQuery.addHint(0).setName("BAZ");
        NamedQueryTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedQueryTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedQueryTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        namedQuery.moveHint(2, 0);
        NamedQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedQueryTests.assertNull((Object)namedQuery.hintAt(1).getName());
        NamedQueryTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(2).getName());
        NamedQueryTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedQuery(hints = {@QueryHint(name = \"BAR\", value = \"FOO\"), @QueryHint, @QueryHint(name = \"BAZ\")})", cu);
    }

    public void testMoveHint2() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery");
        namedQuery.addHint(0).setName("BAZ");
        NamedQueryTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedQueryTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedQueryTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        namedQuery.moveHint(0, 2);
        NamedQueryTests.assertNull((Object)namedQuery.hintAt(0).getName());
        NamedQueryTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(1).getName());
        NamedQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(2).getName());
        NamedQueryTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedQuery(hints = {@QueryHint, @QueryHint(name = \"BAZ\"), @QueryHint(name = \"BAR\", value = \"FOO\")})", cu);
    }
}

