/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class TableGeneratorTests
extends JpaJavaResourceModelTestCase {
    private static final String GENERATOR_NAME = "MY_GENERATOR";
    private static final String GENERATOR_TABLE = "MY_TABLE";
    private static final String GENERATOR_CATALOG = "MY_CATALOG";
    private static final String GENERATOR_SCHEMA = "MY_SCHEMA";
    private static final String GENERATOR_PK_COLUMN_NAME = "MY_PK_COLUMN_NAME";
    private static final String GENERATOR_VALUE_COLUMN_NAME = "MY_VALUE_COLUMN_NAME";
    private static final String GENERATOR_PK_COLUMN_VALUE = "MY_PK_COLUMN_VALUE";
    private static final Integer GENERATOR_ALLOCATION_SIZE = 5;
    private static final Integer GENERATOR_INITIAL_VALUE = 5;

    public TableGeneratorTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestTableGeneratorOnField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.TableGenerator"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@TableGenerator");
            }
        });
    }

    private ICompilationUnit createTestTableGeneratorOnType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.TableGenerator"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@TableGenerator");
            }
        });
    }

    private ICompilationUnit createTestTableGeneratorWithName() throws Exception {
        return this.createTestTableGeneratorWithStringElement("name", GENERATOR_NAME);
    }

    private ICompilationUnit createTestTableGeneratorWithTable() throws Exception {
        return this.createTestTableGeneratorWithStringElement("table", GENERATOR_TABLE);
    }

    private ICompilationUnit createTestTableGeneratorWithCatalog() throws Exception {
        return this.createTestTableGeneratorWithStringElement("catalog", GENERATOR_CATALOG);
    }

    private ICompilationUnit createTestTableGeneratorWithSchema() throws Exception {
        return this.createTestTableGeneratorWithStringElement("schema", GENERATOR_SCHEMA);
    }

    private ICompilationUnit createTestTableGeneratorWithPkColumnName() throws Exception {
        return this.createTestTableGeneratorWithStringElement("pkColumnName", GENERATOR_PK_COLUMN_NAME);
    }

    private ICompilationUnit createTestTableGeneratorWithValueColumnName() throws Exception {
        return this.createTestTableGeneratorWithStringElement("valueColumnName", GENERATOR_VALUE_COLUMN_NAME);
    }

    private ICompilationUnit createTestTableGeneratorWithPkColumnValue() throws Exception {
        return this.createTestTableGeneratorWithStringElement("pkColumnValue", GENERATOR_PK_COLUMN_VALUE);
    }

    private ICompilationUnit createTestTableGeneratorWithStringElement(final String elementName, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.TableGenerator"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@TableGenerator(" + elementName + " = \"" + value + "\")");
            }
        });
    }

    private ICompilationUnit createTestTableGeneratorWithAllocationSize() throws Exception {
        return this.createTestTableGeneratorWithIntElement("allocationSize", GENERATOR_ALLOCATION_SIZE);
    }

    private ICompilationUnit createTestTableGeneratorWithInitialValue() throws Exception {
        return this.createTestTableGeneratorWithIntElement("initialValue", GENERATOR_INITIAL_VALUE);
    }

    private ICompilationUnit createTestTableGeneratorWithIntElement(final String elementName, final int value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.TableGenerator"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@TableGenerator(" + elementName + " = " + value + ")");
            }
        });
    }

    private ICompilationUnit createTestTableGeneratorWithUniqueConstraints() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.TableGenerator", "javax.persistence.UniqueConstraint"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@TableGenerator(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"})})");
            }
        });
    }

    public void testTableGeneratorOnField() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertNotNull((Object)tableGenerator);
    }

    public void testTableGeneratorOnType() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorOnType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)typeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertNotNull((Object)tableGenerator);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((String)GENERATOR_NAME, (String)tableGenerator.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((String)GENERATOR_NAME, (String)tableGenerator.getName());
        tableGenerator.setName("foo");
        TableGeneratorTests.assertEquals((String)"foo", (String)tableGenerator.getName());
        this.assertSourceContains("@TableGenerator(name = \"foo\")", cu);
        tableGenerator.setName(null);
        TableGeneratorTests.assertNull((Object)tableGenerator.getName());
        this.assertSourceDoesNotContain("@TableGenerator(", cu);
    }

    public void testGetTable() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((String)GENERATOR_TABLE, (String)tableGenerator.getTable());
    }

    public void testSetTable() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((String)GENERATOR_TABLE, (String)tableGenerator.getTable());
        tableGenerator.setTable("foo");
        TableGeneratorTests.assertEquals((String)"foo", (String)tableGenerator.getTable());
        this.assertSourceContains("@TableGenerator(table = \"foo\")", cu);
        tableGenerator.setTable(null);
        TableGeneratorTests.assertNull((Object)tableGenerator.getTable());
        this.assertSourceDoesNotContain("@TableGenerator(", cu);
    }

    public void testGetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithCatalog();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((String)GENERATOR_CATALOG, (String)tableGenerator.getCatalog());
    }

    public void testSetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithCatalog();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((String)GENERATOR_CATALOG, (String)tableGenerator.getCatalog());
        tableGenerator.setCatalog("foo");
        TableGeneratorTests.assertEquals((String)"foo", (String)tableGenerator.getCatalog());
        this.assertSourceContains("@TableGenerator(catalog = \"foo\")", cu);
        tableGenerator.setCatalog(null);
        TableGeneratorTests.assertNull((Object)tableGenerator.getCatalog());
        this.assertSourceDoesNotContain("@TableGenerator(", cu);
    }

    public void testGetSchema() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithSchema();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((String)GENERATOR_SCHEMA, (String)tableGenerator.getSchema());
    }

    public void testSetSchema() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithSchema();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((String)GENERATOR_SCHEMA, (String)tableGenerator.getSchema());
        tableGenerator.setSchema("foo");
        TableGeneratorTests.assertEquals((String)"foo", (String)tableGenerator.getSchema());
        this.assertSourceContains("@TableGenerator(schema = \"foo\")", cu);
        tableGenerator.setSchema(null);
        TableGeneratorTests.assertNull((Object)tableGenerator.getSchema());
        this.assertSourceDoesNotContain("@TableGenerator(", cu);
    }

    public void testGetPkColumnName() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithPkColumnName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((String)GENERATOR_PK_COLUMN_NAME, (String)tableGenerator.getPkColumnName());
    }

    public void testSetPkColumnName() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithPkColumnName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((String)GENERATOR_PK_COLUMN_NAME, (String)tableGenerator.getPkColumnName());
        tableGenerator.setPkColumnName("foo");
        TableGeneratorTests.assertEquals((String)"foo", (String)tableGenerator.getPkColumnName());
        this.assertSourceContains("@TableGenerator(pkColumnName = \"foo\")", cu);
        tableGenerator.setPkColumnName(null);
        TableGeneratorTests.assertNull((Object)tableGenerator.getPkColumnName());
        this.assertSourceDoesNotContain("@TableGenerator(", cu);
    }

    public void testGetValueColumnName() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithValueColumnName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((String)GENERATOR_VALUE_COLUMN_NAME, (String)tableGenerator.getValueColumnName());
    }

    public void testSetValueColumnName() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithValueColumnName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((String)GENERATOR_VALUE_COLUMN_NAME, (String)tableGenerator.getValueColumnName());
        tableGenerator.setValueColumnName("foo");
        TableGeneratorTests.assertEquals((String)"foo", (String)tableGenerator.getValueColumnName());
        this.assertSourceContains("@TableGenerator(valueColumnName = \"foo\")", cu);
        tableGenerator.setValueColumnName(null);
        TableGeneratorTests.assertNull((Object)tableGenerator.getValueColumnName());
        this.assertSourceDoesNotContain("@TableGenerator(", cu);
    }

    public void testGetPkColumnValue() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithPkColumnValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((String)GENERATOR_PK_COLUMN_VALUE, (String)tableGenerator.getPkColumnValue());
    }

    public void testSetPkColumnValue() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithPkColumnValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((String)GENERATOR_PK_COLUMN_VALUE, (String)tableGenerator.getPkColumnValue());
        tableGenerator.setPkColumnValue("foo");
        TableGeneratorTests.assertEquals((String)"foo", (String)tableGenerator.getPkColumnValue());
        this.assertSourceContains("@TableGenerator(pkColumnValue = \"foo\")", cu);
        tableGenerator.setPkColumnValue(null);
        TableGeneratorTests.assertNull((Object)tableGenerator.getPkColumnValue());
        this.assertSourceDoesNotContain("@TableGenerator(", cu);
    }

    public void testGetAllocationSize() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithAllocationSize();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((Object)GENERATOR_ALLOCATION_SIZE, (Object)tableGenerator.getAllocationSize());
    }

    public void testSetAllocationSize() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithAllocationSize();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((Object)GENERATOR_ALLOCATION_SIZE, (Object)tableGenerator.getAllocationSize());
        tableGenerator.setAllocationSize(Integer.valueOf(500));
        TableGeneratorTests.assertEquals((Object)500, (Object)tableGenerator.getAllocationSize());
        this.assertSourceContains("@TableGenerator(allocationSize = 500)", cu);
        tableGenerator.setAllocationSize(null);
        this.assertSourceDoesNotContain("@TableGenerator(", cu);
        tableGenerator.setAllocationSize(Integer.valueOf(0));
        this.assertSourceContains("@TableGenerator(allocationSize = 0)", cu);
    }

    public void testGetInitialValue() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithInitialValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((Object)GENERATOR_INITIAL_VALUE, (Object)tableGenerator.getInitialValue());
    }

    public void testSetInitialValue() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithInitialValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((Object)GENERATOR_INITIAL_VALUE, (Object)tableGenerator.getInitialValue());
        tableGenerator.setInitialValue(Integer.valueOf(500));
        TableGeneratorTests.assertEquals((Object)500, (Object)tableGenerator.getInitialValue());
        this.assertSourceContains("@TableGenerator(initialValue = 500)", cu);
        tableGenerator.setInitialValue(null);
        this.assertSourceDoesNotContain("@TableGenerator(", cu);
        tableGenerator.setInitialValue(Integer.valueOf(0));
        this.assertSourceContains("@TableGenerator(initialValue = 0)", cu);
    }

    public void testUniqueConstraints() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((int)0, (int)tableGenerator.uniqueConstraintsSize());
    }

    public void testUniqueConstraints2() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.addUniqueConstraint(0);
        tableGenerator.addUniqueConstraint(1);
        TableGeneratorTests.assertEquals((int)2, (int)tableGenerator.uniqueConstraintsSize());
    }

    public void testUniqueConstraints3() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        TableGeneratorTests.assertEquals((int)3, (int)tableGenerator.uniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.addUniqueConstraint(0).addColumnName("FOO");
        tableGenerator.addUniqueConstraint(1);
        tableGenerator.addUniqueConstraint(0).addColumnName("BAR");
        TableGeneratorTests.assertEquals((String)"BAR", (String)((String)tableGenerator.uniqueConstraintAt(0).columnNames().next()));
        TableGeneratorTests.assertEquals((String)"FOO", (String)((String)tableGenerator.uniqueConstraintAt(1).columnNames().next()));
        TableGeneratorTests.assertEquals((int)0, (int)tableGenerator.uniqueConstraintAt(2).columnNamesSize());
        TableGeneratorTests.assertEquals((int)3, (int)tableGenerator.uniqueConstraintsSize());
        this.assertSourceContains("@TableGenerator(uniqueConstraints = {@UniqueConstraint(columnNames = \"BAR\"),@UniqueConstraint(columnNames = \"FOO\"), @UniqueConstraint})", cu);
    }

    public void testRemoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.removeUniqueConstraint(1);
        this.assertSourceContains("@TableGenerator(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"BAZ\"})})", cu);
        tableGenerator.removeUniqueConstraint(0);
        this.assertSourceContains("@TableGenerator(uniqueConstraints = @UniqueConstraint(columnNames = {\"BAZ\"}))", cu);
        tableGenerator.removeUniqueConstraint(0);
        this.assertSourceDoesNotContain("@TableGenerator(", cu);
    }

    public void testMoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.moveUniqueConstraint(2, 0);
        this.assertSourceContains("@TableGenerator(uniqueConstraints = {@UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"}), @UniqueConstraint(columnNames = {\"BAR\"})})", cu);
    }

    public void testMoveUniqueConstraint2() throws Exception {
        ICompilationUnit cu = this.createTestTableGeneratorWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.moveUniqueConstraint(0, 2);
        this.assertSourceContains("@TableGenerator(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAZ\"}), @UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"})})", cu);
    }
}

