/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.relation;

import java.util.HashSet;
import java.util.Iterator;
import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.OwnableRelationshipMappingAnnotation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateRelationsInFieldAnnotatedEntitiesTest {
    private IJPAEditorFeatureProvider featureProvider;
    final String TEST_PROJECT = "Test";
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    IEclipseFacade eclipseFacade = null;

    @Before
    public void setUp() throws Exception {
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        IFile entity = this.factory.createEntity(this.jpaProject, "org.eclipse.Entity1");
        Thread.sleep(2000L);
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement(null)).andReturn((Object)CreateRelationsInFieldAnnotatedEntitiesTest.getPersistentType(entity));
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit((JavaPersistentType)EasyMock.isA(JavaPersistentType.class))).andReturn((Object)JavaCore.createCompilationUnitFrom((IFile)entity)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.featureProvider});
    }

    public static JavaPersistentType getPersistentType(IFile file) {
        JpaFile jpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        Iterator<JpaStructureNode> iterator = CreateRelationsInFieldAnnotatedEntitiesTest.getRootNodes(jpaFile).iterator();
        if (iterator.hasNext()) {
            JpaStructureNode node = iterator.next();
            JavaPersistentType entity = (JavaPersistentType)node;
            return entity;
        }
        return null;
    }

    private static Iterable<JpaStructureNode> getRootNodes(JpaFile jpaFile) {
        if (jpaFile == null) {
            return EmptyIterable.instance();
        }
        return jpaFile.getRootStructureNodes();
    }

    public ICompilationUnit createCompilationUnitFrom(IFile file) {
        return JavaCore.createCompilationUnitFrom((IFile)file);
    }

    @Test
    public void testCreateOneToOneUnidirRelation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourcePersistentType customerType = this.jpaProject.getJavaResourcePersistentType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourcePersistentType addressType = this.jpaProject.getJavaResourcePersistentType("com.Address");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom((IFile)t1.getResource());
        OneToOneUniDirRelation rel = new OneToOneUniDirRelation(this.featureProvider, t1, t2, "address", true, cu1, this.createCompilationUnitFrom((IFile)t2.getResource()));
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        HashSet annotations = JpaArtifactFactory.instance().getAnnotationNames(ownerAt);
        Assert.assertTrue((boolean)annotations.contains("OneToOne"));
        Assert.assertNull((Object)((OwnableRelationshipMappingAnnotation)ownerAt.getMapping()).getMappedBy());
        Assert.assertTrue((boolean)cu1.isWorkingCopy());
        IType javaType = cu1.findPrimaryType();
        IField f = javaType.getField("address");
        Assert.assertTrue((boolean)f.exists());
    }

    @Test
    public void testCreateOneToOneBidirRelation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourcePersistentType customerType = this.jpaProject.getJavaResourcePersistentType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourcePersistentType addressType = this.jpaProject.getJavaResourcePersistentType("com.Address");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom((IFile)t1.getResource());
        ICompilationUnit cu2 = this.createCompilationUnitFrom((IFile)t2.getResource());
        OneToOneBiDirRelation rel = new OneToOneBiDirRelation(this.featureProvider, t1, t2, "address", "customer", true, cu1, cu2);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        HashSet annotations = JpaArtifactFactory.instance().getAnnotationNames(ownerAt);
        Assert.assertTrue((boolean)annotations.contains("OneToOne"));
        Assert.assertNull((Object)((OwnableRelationshipMappingAnnotation)ownerAt.getMapping()).getMappedBy());
        JavaPersistentAttribute inverseAt = t2.getAttributeNamed("customer");
        Assert.assertNotNull((Object)inverseAt);
        annotations = JpaArtifactFactory.instance().getAnnotationNames(inverseAt);
        Assert.assertTrue((boolean)annotations.contains("OneToOne"));
        Assert.assertEquals((Object)"address", (Object)((OwnableRelationshipMappingAnnotation)inverseAt.getMapping()).getMappedBy());
        Assert.assertTrue((boolean)cu1.isWorkingCopy());
        Assert.assertTrue((boolean)cu2.isWorkingCopy());
        IType javaType1 = cu1.findPrimaryType();
        IField f1 = javaType1.getField("address");
        Assert.assertTrue((boolean)f1.exists());
        IType javaType2 = cu2.findPrimaryType();
        IField f2 = javaType2.getField("customer");
        Assert.assertTrue((boolean)f2.exists());
    }

    @Test
    public void testCreateOneToManyUnidirRelation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourcePersistentType customerType = this.jpaProject.getJavaResourcePersistentType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourcePersistentType addressType = this.jpaProject.getJavaResourcePersistentType("com.Address");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom((IFile)t1.getResource());
        OneToManyUniDirRelation rel = new OneToManyUniDirRelation(this.featureProvider, t1, t2, "address", true, cu1, this.createCompilationUnitFrom((IFile)t2.getResource()));
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        HashSet annotations = JpaArtifactFactory.instance().getAnnotationNames(ownerAt);
        Assert.assertTrue((boolean)annotations.contains("OneToMany"));
        Assert.assertNull((Object)((OwnableRelationshipMappingAnnotation)ownerAt.getMapping()).getMappedBy());
        Assert.assertTrue((boolean)cu1.isWorkingCopy());
        IType javaType1 = cu1.findPrimaryType();
        IField f1 = javaType1.getField("address");
        Assert.assertTrue((boolean)f1.exists());
    }

    @Test
    public void testCreateManyToOneUnidirRelation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourcePersistentType customerType = this.jpaProject.getJavaResourcePersistentType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourcePersistentType addressType = this.jpaProject.getJavaResourcePersistentType("com.Address");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom((IFile)t1.getResource());
        ManyToOneUniDirRelation rel = new ManyToOneUniDirRelation(this.featureProvider, t1, t2, "address", true, cu1, this.createCompilationUnitFrom((IFile)t2.getResource()));
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        HashSet annotations = JpaArtifactFactory.instance().getAnnotationNames(ownerAt);
        Assert.assertTrue((boolean)annotations.contains("ManyToOne"));
        Assert.assertTrue((boolean)cu1.isWorkingCopy());
        IType javaType1 = cu1.findPrimaryType();
        IField f1 = javaType1.getField("address");
        Assert.assertTrue((boolean)f1.exists());
    }

    @Test
    public void testCreateManyToOneBidirRelation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourcePersistentType customerType = this.jpaProject.getJavaResourcePersistentType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourcePersistentType addressType = this.jpaProject.getJavaResourcePersistentType("com.Address");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom((IFile)t1.getResource());
        ICompilationUnit cu2 = this.createCompilationUnitFrom((IFile)t2.getResource());
        ManyToOneBiDirRelation rel = new ManyToOneBiDirRelation(this.featureProvider, t1, t2, "address", "customer", true, cu1, cu2);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        HashSet annotations = JpaArtifactFactory.instance().getAnnotationNames(ownerAt);
        Assert.assertTrue((boolean)annotations.contains("ManyToOne"));
        JavaPersistentAttribute inverseAt = t2.getAttributeNamed("customer");
        Assert.assertNotNull((Object)inverseAt);
        annotations = JpaArtifactFactory.instance().getAnnotationNames(inverseAt);
        Assert.assertTrue((boolean)annotations.contains("OneToMany"));
        Assert.assertEquals((Object)"address", (Object)((OwnableRelationshipMappingAnnotation)inverseAt.getMapping()).getMappedBy());
        Assert.assertTrue((boolean)cu1.isWorkingCopy());
        Assert.assertTrue((boolean)cu2.isWorkingCopy());
        IType javaType1 = cu1.findPrimaryType();
        IField f1 = javaType1.getField("address");
        Assert.assertTrue((boolean)f1.exists());
        IType javaType2 = cu2.findPrimaryType();
        IField f2 = javaType2.getField("customer");
        Assert.assertTrue((boolean)f2.exists());
    }

    @Test
    public void testCreateManyToManyUnidirRelation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourcePersistentType customerType = this.jpaProject.getJavaResourcePersistentType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourcePersistentType addressType = this.jpaProject.getJavaResourcePersistentType("com.Address");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom((IFile)t1.getResource());
        ManyToManyUniDirRelation rel = new ManyToManyUniDirRelation(this.featureProvider, t1, t2, "address", true, cu1, this.createCompilationUnitFrom((IFile)t2.getResource()));
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        HashSet annotations = JpaArtifactFactory.instance().getAnnotationNames(ownerAt);
        Assert.assertTrue((boolean)annotations.contains("ManyToMany"));
        Assert.assertNull((Object)((OwnableRelationshipMappingAnnotation)ownerAt.getMapping()).getMappedBy());
        Assert.assertTrue((boolean)cu1.isWorkingCopy());
        IType javaType1 = cu1.findPrimaryType();
        IField f1 = javaType1.getField("address");
        Assert.assertTrue((boolean)f1.exists());
    }

    @Test
    public void testCreateManyToManyBidirRelation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourcePersistentType customerType = this.jpaProject.getJavaResourcePersistentType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourcePersistentType addressType = this.jpaProject.getJavaResourcePersistentType("com.Address");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom((IFile)t1.getResource());
        ICompilationUnit cu2 = this.createCompilationUnitFrom((IFile)t2.getResource());
        ManyToManyBiDirRelation rel = new ManyToManyBiDirRelation(this.featureProvider, t1, t2, "address", "customer", true, cu1, cu2);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        JavaPersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        HashSet annotations = JpaArtifactFactory.instance().getAnnotationNames(ownerAt);
        Assert.assertTrue((boolean)annotations.contains("ManyToMany"));
        Assert.assertNull((Object)((OwnableRelationshipMappingAnnotation)ownerAt.getMapping()).getMappedBy());
        JavaPersistentAttribute inverseAt = t2.getAttributeNamed("customer");
        Assert.assertNotNull((Object)inverseAt);
        annotations = JpaArtifactFactory.instance().getAnnotationNames(inverseAt);
        Assert.assertTrue((boolean)annotations.contains("ManyToMany"));
        Assert.assertEquals((Object)"address", (Object)((OwnableRelationshipMappingAnnotation)inverseAt.getMapping()).getMappedBy());
        Assert.assertTrue((boolean)cu1.isWorkingCopy());
        Assert.assertTrue((boolean)cu2.isWorkingCopy());
        IType javaType1 = cu1.findPrimaryType();
        IField f1 = javaType1.getField("address");
        Assert.assertTrue((boolean)f1.exists());
        IType javaType2 = cu2.findPrimaryType();
        IField f2 = javaType2.getField("customer");
        Assert.assertTrue((boolean)f2.exists());
    }
}

