/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbElementFactoryMethod;
import org.eclipse.jpt.jaxb.core.context.JaxbRegistry;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementDeclAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaElementFactoryMethodTests
extends JaxbContextModelTestCase {
    public GenericJavaElementFactoryMethodTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlRegistry() throws Exception {
        return this.createTestType("test", "ObjectFactory.java", "ObjectFactory", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlRegistry", "javax.xml.bind.annotation.XmlElementDecl", "javax.xml.bind.JAXBElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlRegistry");
            }

            public void appendGetNameMethodAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementDecl").append(CR);
                sb.append("    JAXBElement<AnnotationTestType> createFoo(AnnotationTestType value) {return null}").append(CR);
                sb.append(CR);
                sb.append("    @XmlElementDecl(name=\"bar\")").append(CR);
                sb.append("    JAXBElement createBar(Object value) {return null}").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTypeWithXmlType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType").append(CR);
            }
        });
    }

    public void testModifyElementName() throws Exception {
        this.createTypeWithXmlType();
        this.createTypeWithXmlRegistry();
        JaxbRegistry contextRegistry = (JaxbRegistry)CollectionTools.get((Iterable)this.getContextRoot().getRegistries(), (int)0);
        Iterator elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getElementName());
        elementFactoryMethod.setElementName("bar");
        XmlElementDeclAnnotation elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementDeclAnnotation.getName());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementFactoryMethod.getElementName());
        elementFactoryMethod.setElementName(null);
        elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementDeclAnnotation.getName());
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getElementName());
    }

    public void testUpdateElementName() throws Exception {
        this.createTypeWithXmlType();
        this.createTypeWithXmlRegistry();
        JaxbRegistry contextRegistry = (JaxbRegistry)CollectionTools.get((Iterable)this.getContextRoot().getRegistries(), (int)0);
        GenericJavaElementFactoryMethodTests.assertEquals((int)2, (int)contextRegistry.getElementFactoryMethodsSize());
        Iterator elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getElementName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.addXmlElementDeclMemberValuePair(declaration, "name", "foo");
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((String)"foo", (String)elementFactoryMethod.getElementName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.removeXmlElementDeclAnnotation(declaration);
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((int)1, (int)contextRegistry.getElementFactoryMethodsSize());
    }

    public void testModifyDefaultValue() throws Exception {
        this.createTypeWithXmlType();
        this.createTypeWithXmlRegistry();
        JaxbRegistry contextRegistry = (JaxbRegistry)CollectionTools.get((Iterable)this.getContextRoot().getRegistries(), (int)0);
        Iterator elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getDefaultValue());
        elementFactoryMethod.setDefaultValue("bar");
        XmlElementDeclAnnotation elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementDeclAnnotation.getDefaultValue());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementFactoryMethod.getDefaultValue());
        elementFactoryMethod.setDefaultValue(null);
        elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementDeclAnnotation.getDefaultValue());
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getDefaultValue());
    }

    public void testUpdateDefaultValue() throws Exception {
        this.createTypeWithXmlType();
        this.createTypeWithXmlRegistry();
        JaxbRegistry contextRegistry = (JaxbRegistry)CollectionTools.get((Iterable)this.getContextRoot().getRegistries(), (int)0);
        GenericJavaElementFactoryMethodTests.assertEquals((int)2, (int)contextRegistry.getElementFactoryMethodsSize());
        Iterator elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getDefaultValue());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.addXmlElementDeclMemberValuePair(declaration, "defaultValue", "foo");
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((String)"foo", (String)elementFactoryMethod.getDefaultValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.removeXmlElementDeclAnnotation(declaration);
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((int)1, (int)contextRegistry.getElementFactoryMethodsSize());
    }

    public void testModifyScope() throws Exception {
        this.createTypeWithXmlType();
        this.createTypeWithXmlRegistry();
        JaxbRegistry contextRegistry = (JaxbRegistry)CollectionTools.get((Iterable)this.getContextRoot().getRegistries(), (int)0);
        Iterator elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getScope());
        elementFactoryMethod.setScope("Bar");
        XmlElementDeclAnnotation elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertEquals((String)"Bar", (String)elementDeclAnnotation.getScope());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"Bar", (String)elementFactoryMethod.getScope());
        elementFactoryMethod.setScope(null);
        elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementDeclAnnotation.getScope());
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getScope());
    }

    public void testUpdateScope() throws Exception {
        this.createTypeWithXmlType();
        this.createTypeWithXmlRegistry();
        JaxbRegistry contextRegistry = (JaxbRegistry)CollectionTools.get((Iterable)this.getContextRoot().getRegistries(), (int)0);
        GenericJavaElementFactoryMethodTests.assertEquals((int)2, (int)contextRegistry.getElementFactoryMethodsSize());
        Iterator elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getScope());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.addXmlElementDeclTypeMemberValuePair(declaration, "scope", "Foo");
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((String)"Foo", (String)elementFactoryMethod.getScope());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.removeXmlElementDeclAnnotation(declaration);
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((int)1, (int)contextRegistry.getElementFactoryMethodsSize());
    }

    public void testModifySubstitutionHeadName() throws Exception {
        this.createTypeWithXmlType();
        this.createTypeWithXmlRegistry();
        JaxbRegistry contextRegistry = (JaxbRegistry)CollectionTools.get((Iterable)this.getContextRoot().getRegistries(), (int)0);
        Iterator elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getSubstitutionHeadName());
        elementFactoryMethod.setSubstitutionHeadName("bar");
        XmlElementDeclAnnotation elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementDeclAnnotation.getSubstitutionHeadName());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementFactoryMethod.getSubstitutionHeadName());
        elementFactoryMethod.setSubstitutionHeadName(null);
        elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementDeclAnnotation.getSubstitutionHeadName());
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getSubstitutionHeadName());
    }

    public void testUpdateSubstitutionHeadName() throws Exception {
        this.createTypeWithXmlType();
        this.createTypeWithXmlRegistry();
        JaxbRegistry contextRegistry = (JaxbRegistry)CollectionTools.get((Iterable)this.getContextRoot().getRegistries(), (int)0);
        GenericJavaElementFactoryMethodTests.assertEquals((int)2, (int)contextRegistry.getElementFactoryMethodsSize());
        Iterator elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getSubstitutionHeadName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.addXmlElementDeclMemberValuePair(declaration, "substitutionHeadName", "foo");
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((String)"foo", (String)elementFactoryMethod.getSubstitutionHeadName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.removeXmlElementDeclAnnotation(declaration);
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((int)1, (int)contextRegistry.getElementFactoryMethodsSize());
    }

    public void testModifySubstitutionHeadNamespace() throws Exception {
        this.createTypeWithXmlType();
        this.createTypeWithXmlRegistry();
        JaxbRegistry contextRegistry = (JaxbRegistry)CollectionTools.get((Iterable)this.getContextRoot().getRegistries(), (int)0);
        Iterator elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getSubstitutionHeadNamespace());
        elementFactoryMethod.setSubstitutionHeadNamespace("bar");
        XmlElementDeclAnnotation elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementDeclAnnotation.getSubstitutionHeadNamespace());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementFactoryMethod.getSubstitutionHeadNamespace());
        elementFactoryMethod.setSubstitutionHeadNamespace(null);
        elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementDeclAnnotation.getSubstitutionHeadNamespace());
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getSubstitutionHeadNamespace());
    }

    public void testUpdateSubstitutionHeadNamespace() throws Exception {
        this.createTypeWithXmlType();
        this.createTypeWithXmlRegistry();
        JaxbRegistry contextRegistry = (JaxbRegistry)CollectionTools.get((Iterable)this.getContextRoot().getRegistries(), (int)0);
        GenericJavaElementFactoryMethodTests.assertEquals((int)2, (int)contextRegistry.getElementFactoryMethodsSize());
        Iterator elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getSubstitutionHeadNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.addXmlElementDeclMemberValuePair(declaration, "substitutionHeadNamespace", "foo");
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((String)"foo", (String)elementFactoryMethod.getSubstitutionHeadNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.removeXmlElementDeclAnnotation(declaration);
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((int)1, (int)contextRegistry.getElementFactoryMethodsSize());
    }

    public void testModifyNamespace() throws Exception {
        this.createTypeWithXmlType();
        this.createTypeWithXmlRegistry();
        JaxbRegistry contextRegistry = (JaxbRegistry)CollectionTools.get((Iterable)this.getContextRoot().getRegistries(), (int)0);
        Iterator elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getNamespace());
        elementFactoryMethod.setNamespace("bar");
        XmlElementDeclAnnotation elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementDeclAnnotation.getNamespace());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementFactoryMethod.getNamespace());
        elementFactoryMethod.setNamespace(null);
        elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementDeclAnnotation.getNamespace());
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getNamespace());
    }

    public void testUpdateNamespace() throws Exception {
        this.createTypeWithXmlType();
        this.createTypeWithXmlRegistry();
        JaxbRegistry contextRegistry = (JaxbRegistry)CollectionTools.get((Iterable)this.getContextRoot().getRegistries(), (int)0);
        GenericJavaElementFactoryMethodTests.assertEquals((int)2, (int)contextRegistry.getElementFactoryMethodsSize());
        Iterator elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.addXmlElementDeclMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((String)"foo", (String)elementFactoryMethod.getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.removeXmlElementDeclAnnotation(declaration);
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((int)1, (int)contextRegistry.getElementFactoryMethodsSize());
    }

    protected void addXmlElementDeclMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementDeclAnnotation(declaration), name, value);
    }

    protected Annotation getXmlElementDeclAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlElementDecl");
    }

    protected void removeXmlElementDeclAnnotation(ModifiedDeclaration declaration) {
        this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElementDecl");
    }

    protected void addXmlElementDeclTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementDeclAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }
}

