/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.beans.Introspector;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumConstant;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentEnum;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.jaxb.core.resource.java.XmlEnumAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRootElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTypeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaPersistentEnumTests
extends JaxbContextModelTestCase {
    public GenericJavaPersistentEnumTests(String name) {
        super(name);
    }

    private ICompilationUnit createEnumWithXmlType() throws Exception {
        return this.createTestEnum((AnnotationTestCase.EnumAnnotationWriter)new AnnotationTestCase.DefaultEnumAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlEnum"});
            }

            public void appendEnumAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType @XmlEnum");
            }
        });
    }

    public void testModifyFactoryClass() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getFactoryClass());
        contextEnum.setFactoryClass("foo");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getFactoryClass());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getFactoryClass());
        contextEnum.setFactoryClass(null);
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentEnumTests.assertNull((Object)xmlTypeAnnotation.getFactoryClass());
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getFactoryClass());
        resourceEnum.removeAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getFactoryClass());
    }

    public void testUpdateFactoryClass() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getFactoryClass());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlType");
                GenericJavaPersistentEnumTests.this.addXmlTypeTypeMemberValuePair(declaration, "factoryClass", "Foo");
            }
        });
        GenericJavaPersistentEnumTests.assertEquals((String)"Foo", (String)contextEnum.getFactoryClass());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlTypeAnnotation = (NormalAnnotation)GenericJavaPersistentEnumTests.this.getXmlTypeAnnotation(declaration);
                GenericJavaPersistentEnumTests.this.values(xmlTypeAnnotation).remove(0);
            }
        });
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getFactoryClass());
    }

    public void testModifyFactoryMethod() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getFactoryMethod());
        contextEnum.setFactoryMethod("foo");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getFactoryMethod());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getFactoryMethod());
        contextEnum.setFactoryMethod(null);
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentEnumTests.assertNull((Object)xmlTypeAnnotation.getFactoryMethod());
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getFactoryMethod());
        resourceEnum.removeAnnotation("javax.xml.bind.annotation.XmlType");
        contextEnum.setFactoryMethod("foo");
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getFactoryMethod());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getFactoryMethod());
    }

    public void testUpdateFactoryMethod() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getFactoryMethod());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlType");
                GenericJavaPersistentEnumTests.this.addXmlTypeMemberValuePair(declaration, "factoryMethod", "foo");
            }
        });
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getFactoryMethod());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlTypeAnnotation = (NormalAnnotation)GenericJavaPersistentEnumTests.this.getXmlTypeAnnotation(declaration);
                GenericJavaPersistentEnumTests.this.values(xmlTypeAnnotation).remove(0);
            }
        });
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getFactoryMethod());
    }

    public void testModifySchemaTypeName() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        String defaultXmlTypeName = Introspector.decapitalize("AnnotationTestType");
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getSpecifiedXmlTypeName());
        GenericJavaPersistentEnumTests.assertEquals((String)defaultXmlTypeName, (String)contextEnum.getDefaultXmlTypeName());
        GenericJavaPersistentEnumTests.assertEquals((String)defaultXmlTypeName, (String)contextEnum.getXmlTypeName());
        contextEnum.setSpecifiedXmlTypeName("foo");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getName());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getSpecifiedXmlTypeName());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getXmlTypeName());
        contextEnum.setSpecifiedXmlTypeName(null);
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentEnumTests.assertNull((Object)xmlTypeAnnotation.getName());
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getSpecifiedXmlTypeName());
        GenericJavaPersistentEnumTests.assertEquals((String)defaultXmlTypeName, (String)contextEnum.getXmlTypeName());
        resourceEnum.removeAnnotation("javax.xml.bind.annotation.XmlType");
        contextEnum.setSpecifiedXmlTypeName("foo");
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getName());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getSpecifiedXmlTypeName());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getXmlTypeName());
    }

    public void testUpdateSchemaTypeName() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        String defaultXmlTypeName = Introspector.decapitalize("AnnotationTestType");
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getSpecifiedXmlTypeName());
        GenericJavaPersistentEnumTests.assertEquals((String)defaultXmlTypeName, (String)contextEnum.getDefaultXmlTypeName());
        GenericJavaPersistentEnumTests.assertEquals((String)defaultXmlTypeName, (String)contextEnum.getXmlTypeName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlType");
                GenericJavaPersistentEnumTests.this.addXmlTypeMemberValuePair(declaration, "name", "foo");
            }
        });
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getSpecifiedXmlTypeName());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getXmlTypeName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlTypeAnnotation = (NormalAnnotation)GenericJavaPersistentEnumTests.this.getXmlTypeAnnotation(declaration);
                GenericJavaPersistentEnumTests.this.values(xmlTypeAnnotation).remove(0);
            }
        });
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getSpecifiedXmlTypeName());
        GenericJavaPersistentEnumTests.assertEquals((String)defaultXmlTypeName, (String)contextEnum.getXmlTypeName());
    }

    public void testModifyNamespace() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getSpecifiedNamespace());
        GenericJavaPersistentEnumTests.assertEquals((String)"", (String)contextEnum.getDefaultNamespace());
        GenericJavaPersistentEnumTests.assertEquals((String)"", (String)contextEnum.getNamespace());
        contextEnum.setSpecifiedNamespace("foo");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getNamespace());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getSpecifiedNamespace());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getNamespace());
        contextEnum.setSpecifiedNamespace(null);
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentEnumTests.assertNull((Object)xmlTypeAnnotation.getNamespace());
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getSpecifiedNamespace());
        GenericJavaPersistentEnumTests.assertEquals((String)"", (String)contextEnum.getNamespace());
        resourceEnum.removeAnnotation("javax.xml.bind.annotation.XmlType");
        contextEnum.setSpecifiedNamespace("foo");
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getNamespace());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getSpecifiedNamespace());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getNamespace());
    }

    public void testUpdateNamespace() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getSpecifiedNamespace());
        GenericJavaPersistentEnumTests.assertEquals((String)"", (String)contextEnum.getDefaultNamespace());
        GenericJavaPersistentEnumTests.assertEquals((String)"", (String)contextEnum.getNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlType");
                GenericJavaPersistentEnumTests.this.addXmlTypeMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getSpecifiedNamespace());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlTypeAnnotation = (NormalAnnotation)GenericJavaPersistentEnumTests.this.getXmlTypeAnnotation(declaration);
                GenericJavaPersistentEnumTests.this.values(xmlTypeAnnotation).remove(0);
            }
        });
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getSpecifiedNamespace());
        GenericJavaPersistentEnumTests.assertEquals((String)"", (String)contextEnum.getNamespace());
    }

    public void testGetPropOrder() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        ListIterator props = contextEnum.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertFalse((boolean)props.hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.addProp(declaration, 0, "bar");
                GenericJavaPersistentEnumTests.this.addProp(declaration, 1, "foo");
            }
        });
        props = contextEnum.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertFalse((boolean)props.hasNext());
    }

    protected void addProp(ModifiedDeclaration declaration, int index, String prop) {
        this.addArrayElement(declaration, "javax.xml.bind.annotation.XmlType", index, "propOrder", (Expression)this.newStringLiteral(declaration.getAst(), prop));
    }

    public void testGetPropOrderSize() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        GenericJavaPersistentEnumTests.assertEquals((int)0, (int)contextEnum.getPropOrderSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.addProp(declaration, 0, "bar");
                GenericJavaPersistentEnumTests.this.addProp(declaration, 1, "foo");
            }
        });
        GenericJavaPersistentEnumTests.assertEquals((int)2, (int)contextEnum.getPropOrderSize());
    }

    public void testAddProp() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        contextEnum.addProp(0, "bar");
        contextEnum.addProp(0, "foo");
        contextEnum.addProp(0, "baz");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        ListIterator props = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertFalse((boolean)props.hasNext());
    }

    public void testAddProp2() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        contextEnum.addProp(0, "bar");
        contextEnum.addProp(1, "foo");
        contextEnum.addProp(0, "baz");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        ListIterator props = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertFalse((boolean)props.hasNext());
    }

    public void testRemoveProp() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        contextEnum.addProp(0, "bar");
        contextEnum.addProp(1, "foo");
        contextEnum.addProp(2, "baz");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        contextEnum.removeProp(1);
        ListIterator resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertEquals((String)"bar", (String)((String)resourceProps.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"baz", (String)((String)resourceProps.next()));
        GenericJavaPersistentEnumTests.assertFalse((boolean)resourceProps.hasNext());
        contextEnum.removeProp(1);
        resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertEquals((String)"bar", (String)((String)resourceProps.next()));
        GenericJavaPersistentEnumTests.assertFalse((boolean)resourceProps.hasNext());
        contextEnum.removeProp(0);
        resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertFalse((boolean)resourceProps.hasNext());
    }

    public void testMoveProp() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        contextEnum.addProp(0, "bar");
        contextEnum.addProp(1, "foo");
        contextEnum.addProp(2, "baz");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentEnumTests.assertEquals((int)3, (int)xmlTypeAnnotation.getPropOrderSize());
        contextEnum.moveProp(2, 0);
        ListIterator props = contextEnum.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertFalse((boolean)props.hasNext());
        ListIterator resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)((String)resourceProps.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"baz", (String)((String)resourceProps.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"bar", (String)((String)resourceProps.next()));
        contextEnum.moveProp(0, 1);
        props = contextEnum.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertFalse((boolean)props.hasNext());
        resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertEquals((String)"baz", (String)((String)resourceProps.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)((String)resourceProps.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"bar", (String)((String)resourceProps.next()));
    }

    public void testSyncXmlNsPrefixes() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        ListIterator props = contextEnum.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertFalse((boolean)props.hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.addProp(declaration, 0, "bar");
                GenericJavaPersistentEnumTests.this.addProp(declaration, 1, "foo");
                GenericJavaPersistentEnumTests.this.addProp(declaration, 2, "baz");
            }
        });
        props = contextEnum.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertTrue((boolean)props.hasNext());
        GenericJavaPersistentEnumTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.moveProp(declaration, 2, 0);
            }
        });
        props = contextEnum.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertTrue((boolean)props.hasNext());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.moveProp(declaration, 0, 1);
            }
        });
        props = contextEnum.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertTrue((boolean)props.hasNext());
        GenericJavaPersistentEnumTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.removeProp(declaration, 1);
            }
        });
        props = contextEnum.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertTrue((boolean)props.hasNext());
        GenericJavaPersistentEnumTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.removeProp(declaration, 1);
            }
        });
        props = contextEnum.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertTrue((boolean)props.hasNext());
        GenericJavaPersistentEnumTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentEnumTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.removeProp(declaration, 0);
            }
        });
        props = contextEnum.getPropOrder().iterator();
        GenericJavaPersistentEnumTests.assertFalse((boolean)props.hasNext());
    }

    protected void addXmlTypeMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlTypeAnnotation(declaration), name, value);
    }

    protected void addXmlTypeTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlTypeAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected void addXmlEnumTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlEnumAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected Annotation getXmlTypeAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlType");
    }

    protected Annotation getXmlEnumAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlEnum");
    }

    protected void moveProp(ModifiedDeclaration declaration, int targetIndex, int sourceIndex) {
        this.moveArrayElement((NormalAnnotation)this.getXmlTypeAnnotation(declaration), "propOrder", targetIndex, sourceIndex);
    }

    protected void removeProp(ModifiedDeclaration declaration, int index) {
        this.removeArrayElement((NormalAnnotation)this.getXmlTypeAnnotation(declaration), "propOrder", index);
    }

    public void testModifyXmlRootElement() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getRootElement());
        GenericJavaPersistentEnumTests.assertFalse((boolean)contextEnum.isRootElement());
        contextEnum.setRootElement("foo");
        XmlRootElementAnnotation xmlRootElementAnnotation = (XmlRootElementAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)xmlRootElementAnnotation.getName());
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getRootElement().getName());
        GenericJavaPersistentEnumTests.assertTrue((boolean)contextEnum.isRootElement());
        contextEnum.setRootElement(null);
        xmlRootElementAnnotation = (XmlRootElementAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaPersistentEnumTests.assertNull((Object)xmlRootElementAnnotation);
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getRootElement());
        GenericJavaPersistentEnumTests.assertFalse((boolean)contextEnum.isRootElement());
    }

    public void testUpdateXmlRootElement() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getRootElement());
        GenericJavaPersistentEnumTests.assertFalse((boolean)contextEnum.isRootElement());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation annotation = GenericJavaPersistentEnumTests.this.addNormalAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlRootElement");
                GenericJavaPersistentEnumTests.this.addMemberValuePair(annotation, "name", "foo");
            }
        });
        GenericJavaPersistentEnumTests.assertEquals((String)"foo", (String)contextEnum.getRootElement().getName());
        GenericJavaPersistentEnumTests.assertTrue((boolean)contextEnum.isRootElement());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlRootElement");
            }
        });
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getRootElement());
        GenericJavaPersistentEnumTests.assertFalse((boolean)contextEnum.isRootElement());
    }

    public void testModifyEnumType() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getEnumType());
        contextEnum.setEnumType("Integer");
        XmlEnumAnnotation xmlEnumAnnotation = (XmlEnumAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlEnum");
        GenericJavaPersistentEnumTests.assertEquals((String)"Integer", (String)xmlEnumAnnotation.getValue());
        GenericJavaPersistentEnumTests.assertEquals((String)"Integer", (String)contextEnum.getEnumType());
        contextEnum.setEnumType(null);
        xmlEnumAnnotation = (XmlEnumAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlEnum");
        GenericJavaPersistentEnumTests.assertNull((Object)xmlEnumAnnotation.getValue());
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getEnumType());
        resourceEnum.addAnnotation("javax.xml.bind.annotation.XmlType");
        resourceEnum.removeAnnotation("javax.xml.bind.annotation.XmlEnum");
        contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getEnumType());
    }

    public void testUpdateEnumType() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getEnumType());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.addXmlEnumTypeMemberValuePair(declaration, "value", "String");
            }
        });
        GenericJavaPersistentEnumTests.assertEquals((String)"String", (String)contextEnum.getEnumType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlEnumAnnotation = (NormalAnnotation)GenericJavaPersistentEnumTests.this.getXmlEnumAnnotation(declaration);
                GenericJavaPersistentEnumTests.this.values(xmlEnumAnnotation).remove(0);
            }
        });
        GenericJavaPersistentEnumTests.assertNull((Object)contextEnum.getEnumType());
    }

    public void testUpdateEnumConstants() throws Exception {
        this.createEnumWithXmlType();
        JaxbPersistentEnum contextEnum = (JaxbPersistentEnum)CollectionTools.get((Iterable)this.getContextRoot().getPersistentEnums(), (int)0);
        JavaResourceEnum resourceEnum = contextEnum.getJavaResourceType();
        GenericJavaPersistentEnumTests.assertEquals((int)2, (int)contextEnum.getEnumConstantsSize());
        Iterator enumConstants = contextEnum.getEnumConstants().iterator();
        JaxbEnumConstant enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaPersistentEnumTests.assertEquals((String)"SUNDAY", (String)enumConstant.getName());
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaPersistentEnumTests.assertEquals((String)"MONDAY", (String)enumConstant.getName());
        GenericJavaPersistentEnumTests.assertFalse((boolean)enumConstants.hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.addEnumConstant((EnumDeclaration)declaration.getDeclaration(), "TUESDAY");
                GenericJavaPersistentEnumTests.this.addEnumConstant((EnumDeclaration)declaration.getDeclaration(), "WEDNESDAY");
            }
        });
        GenericJavaPersistentEnumTests.assertEquals((int)4, (int)contextEnum.getEnumConstantsSize());
        enumConstants = contextEnum.getEnumConstants().iterator();
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaPersistentEnumTests.assertEquals((String)"SUNDAY", (String)enumConstant.getName());
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaPersistentEnumTests.assertEquals((String)"MONDAY", (String)enumConstant.getName());
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaPersistentEnumTests.assertEquals((String)"TUESDAY", (String)enumConstant.getName());
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaPersistentEnumTests.assertEquals((String)"WEDNESDAY", (String)enumConstant.getName());
        GenericJavaPersistentEnumTests.assertFalse((boolean)enumConstants.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.removeEnumConstant((EnumDeclaration)declaration.getDeclaration(), "SUNDAY");
            }
        });
        GenericJavaPersistentEnumTests.assertEquals((int)3, (int)contextEnum.getEnumConstantsSize());
        enumConstants = contextEnum.getEnumConstants().iterator();
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaPersistentEnumTests.assertEquals((String)"MONDAY", (String)enumConstant.getName());
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaPersistentEnumTests.assertEquals((String)"TUESDAY", (String)enumConstant.getName());
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaPersistentEnumTests.assertEquals((String)"WEDNESDAY", (String)enumConstant.getName());
        GenericJavaPersistentEnumTests.assertFalse((boolean)enumConstants.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.removeEnumConstant((EnumDeclaration)declaration.getDeclaration(), "TUESDAY");
                GenericJavaPersistentEnumTests.this.removeEnumConstant((EnumDeclaration)declaration.getDeclaration(), "MONDAY");
            }
        });
        GenericJavaPersistentEnumTests.assertEquals((int)1, (int)contextEnum.getEnumConstantsSize());
        enumConstants = contextEnum.getEnumConstants().iterator();
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaPersistentEnumTests.assertEquals((String)"WEDNESDAY", (String)enumConstant.getName());
        GenericJavaPersistentEnumTests.assertFalse((boolean)enumConstants.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentEnumTests.this.removeEnumConstant((EnumDeclaration)declaration.getDeclaration(), "WEDNESDAY");
            }
        });
        GenericJavaPersistentEnumTests.assertEquals((int)0, (int)contextEnum.getEnumConstantsSize());
        GenericJavaPersistentEnumTests.assertFalse((boolean)contextEnum.getEnumConstants().iterator().hasNext());
    }
}

