/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentClass;
import org.eclipse.jpt.jaxb.core.context.XmlAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlElementMapping;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAttachmentRefAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDREFAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlListAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaTypeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlElementMappingTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlElementMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlElement() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElement");
            }
        });
    }

    public void testModifyName() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedName());
        GenericJavaXmlElementMappingTests.assertEquals((String)"id", (String)xmlElementMapping.getDefaultName());
        GenericJavaXmlElementMappingTests.assertEquals((String)"id", (String)xmlElementMapping.getName());
        xmlElementMapping.setSpecifiedName("foo");
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElementAnnotation.getName());
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElementMapping.getSpecifiedName());
        GenericJavaXmlElementMappingTests.assertEquals((String)"id", (String)xmlElementMapping.getDefaultName());
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElementMapping.getName());
        xmlElementMapping.setSpecifiedName(null);
        xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementAnnotation.getName());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedName());
    }

    public void testUpdateName() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addXmlElementMemberValuePair(declaration, "name", "foo");
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElementMapping.getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlElementMappingTests.this.getXmlElementAnnotation(declaration);
                GenericJavaXmlElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedName());
    }

    public void testModifyNamespace() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedNamespace());
        xmlElementMapping.setSpecifiedNamespace("foo");
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElementAnnotation.getNamespace());
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElementMapping.getNamespace());
        xmlElementMapping.setSpecifiedNamespace(null);
        xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementAnnotation.getNamespace());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedNamespace());
    }

    public void testUpdateNamespace() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addXmlElementMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElementMapping.getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlElementMappingTests.this.getXmlElementAnnotation(declaration);
                GenericJavaXmlElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedNamespace());
    }

    public void testModifyRequired() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isDefaultRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isRequired());
        xmlElementMapping.setSpecifiedRequired(Boolean.TRUE);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementAnnotation.getRequired());
        GenericJavaXmlElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementMapping.getSpecifiedRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isDefaultRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)true, (boolean)xmlElementMapping.isRequired());
        xmlElementMapping.setSpecifiedRequired(null);
        xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementAnnotation.getName());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isDefaultRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isRequired());
    }

    public void testUpdateRequired() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isDefaultRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isRequired());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addXmlElementMemberValuePair(declaration, "required", true);
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementMapping.getSpecifiedRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isDefaultRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)true, (boolean)xmlElementMapping.isRequired());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlElementMappingTests.this.getXmlElementAnnotation(declaration);
                GenericJavaXmlElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isDefaultRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isRequired());
    }

    public void testModifyNillable() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isDefaultNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isNillable());
        xmlElementMapping.setSpecifiedNillable(Boolean.TRUE);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementAnnotation.getNillable());
        GenericJavaXmlElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementMapping.getSpecifiedNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isDefaultNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)true, (boolean)xmlElementMapping.isNillable());
        xmlElementMapping.setSpecifiedNillable(null);
        xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementAnnotation.getName());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isDefaultNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isNillable());
    }

    public void testUpdateNillable() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isDefaultNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isNillable());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addXmlElementMemberValuePair(declaration, "nillable", true);
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementMapping.getSpecifiedNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isDefaultNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)true, (boolean)xmlElementMapping.isNillable());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlElementMappingTests.this.getXmlElementAnnotation(declaration);
                GenericJavaXmlElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isDefaultNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElementMapping.isNillable());
    }

    public void testModifyDefaultValue() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getDefaultValue());
        xmlElementMapping.setDefaultValue("foo");
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElementAnnotation.getDefaultValue());
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElementMapping.getDefaultValue());
        xmlElementMapping.setDefaultValue(null);
        xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementAnnotation.getDefaultValue());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getDefaultValue());
    }

    public void testUpdateDefaultValue() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getDefaultValue());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addXmlElementMemberValuePair(declaration, "defaultValue", "foo");
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElementMapping.getDefaultValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlElementMappingTests.this.getXmlElementAnnotation(declaration);
                GenericJavaXmlElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getDefaultValue());
    }

    public void testModifyType() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedType());
        xmlElementMapping.setSpecifiedType("Foo");
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertEquals((String)"Foo", (String)xmlElementMapping.getSpecifiedType());
        GenericJavaXmlElementMappingTests.assertEquals((String)"Foo", (String)xmlElementMapping.getType());
        xmlElementMapping.setSpecifiedType(null);
        xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementAnnotation.getType());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedType());
    }

    public void testUpdateType() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedType());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addXmlElementTypeMemberValuePair(declaration, "type", "Foo");
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((String)"Foo", (String)xmlElementMapping.getType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlElementMappingTests.this.getXmlElementAnnotation(declaration);
                GenericJavaXmlElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getSpecifiedType());
    }

    public void testChangeMappingType() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping);
        GenericJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
        persistentAttribute.setMappingKey("xml-attribute");
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlAttributeMapping);
        GenericJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
        GenericJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        persistentAttribute.setMappingKey("xml-element");
        xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping);
        GenericJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
        GenericJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
    }

    public void testModifyXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
        xmlElementMapping.addXmlJavaTypeAdapter();
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlJavaTypeAdapterAnnotation);
        xmlElementMapping.removeXmlJavaTypeAdapter();
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
    }

    public void testUpdateXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlJavaTypeAdapterAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
    }

    public void testModifyXmlSchemaType() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        XmlSchemaTypeAnnotation xmlSchemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlSchemaType());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlSchemaTypeAnnotation);
        xmlElementMapping.addXmlSchemaType();
        xmlSchemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlSchemaType());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlSchemaTypeAnnotation);
        xmlElementMapping.removeXmlSchemaType();
        xmlSchemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
    }

    public void testUpdateXmlSchemaType() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        XmlSchemaTypeAnnotation xmlSchemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlSchemaType());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlSchemaTypeAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlSchemaType");
            }
        });
        xmlSchemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlSchemaType());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlSchemaTypeAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlSchemaType");
            }
        });
        xmlSchemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlSchemaType());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlSchemaTypeAnnotation);
    }

    protected void addXmlElementMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementAnnotation(declaration), name, value);
    }

    protected void addXmlElementMemberValuePair(ModifiedDeclaration declaration, String name, boolean value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementAnnotation(declaration), name, value);
    }

    protected void addXmlElementTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected Annotation getXmlElementAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlElement");
    }

    public void testModifyXmlElementWrapper() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlElementWrapper());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
        xmlElementMapping.addXmlElementWrapper();
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlElementWrapper());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementWrapperAnnotation);
        xmlElementMapping.removeXmlElementWrapper();
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
    }

    public void testUpdateXmlElementWrapper() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlElementWrapper());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElementWrapper");
            }
        });
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlElementWrapper());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementWrapperAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElementWrapper");
            }
        });
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlElementWrapper());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
    }

    public void testModifyXmlList() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        XmlListAnnotation xmlListAnnotation = (XmlListAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlList());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlListAnnotation);
        xmlElementMapping.addXmlList();
        xmlListAnnotation = (XmlListAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlList());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlListAnnotation);
        xmlElementMapping.removeXmlList();
        xmlListAnnotation = (XmlListAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList");
    }

    public void testUpdateXmlList() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        XmlListAnnotation xmlListAnnotation = (XmlListAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlList());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlListAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlList");
            }
        });
        xmlListAnnotation = (XmlListAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlList());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlListAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlList");
            }
        });
        xmlListAnnotation = (XmlListAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlList());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlListAnnotation);
    }

    public void testModifyXmlID() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        XmlIDAnnotation xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlID());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlIDAnnotation);
        xmlElementMapping.addXmlID();
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlID());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlIDAnnotation);
        xmlElementMapping.removeXmlID();
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
    }

    public void testUpdateXmlID() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        XmlIDAnnotation xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlID());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlIDAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlID");
            }
        });
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlID());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlIDAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlID");
            }
        });
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlID());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlIDAnnotation);
    }

    public void testModifyXmlIDREF() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        XmlIDREFAnnotation xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlIDREF());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlIDREFAnnotation);
        xmlElementMapping.addXmlIDREF();
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlIDREF());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlIDREFAnnotation);
        xmlElementMapping.removeXmlIDREF();
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
    }

    public void testUpdateXmlIDREF() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        XmlIDREFAnnotation xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlIDREF());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlIDREFAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlIDREF");
            }
        });
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlIDREF());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlIDREFAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlIDREF");
            }
        });
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlIDREF());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlIDREFAnnotation);
    }

    public void testModifyXmlAttachmentRef() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        XmlAttachmentRefAnnotation xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlAttachmentRef());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlAttachmentRefAnnotation);
        xmlElementMapping.addXmlAttachmentRef();
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlAttachmentRef());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlAttachmentRefAnnotation);
        xmlElementMapping.removeXmlAttachmentRef();
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
    }

    public void testUpdateXmlAttachmentRef() throws Exception {
        this.createTypeWithXmlElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getParent().getJavaResourceAttribute();
        XmlAttachmentRefAnnotation xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlAttachmentRef());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlAttachmentRefAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttachmentRef");
            }
        });
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlAttachmentRef());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlAttachmentRefAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttachmentRef");
            }
        });
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlAttachmentRef());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlAttachmentRefAnnotation);
    }
}

