/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceField;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlElementWrapperAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String XML_ELEMENT_WRAPPER_NAME = "elementName";
    private static final String XML_ELEMENT_WRAPPER_NAMESPACE = "XmlElementWrapperNamespace";

    public XmlElementWrapperAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlElementWrapper() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElementWrapper"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementWrapper");
            }
        });
    }

    private ICompilationUnit createTestXmlElementWrapperWithName() throws Exception {
        return this.createTestXmlElementWrapperWithStringElement("name", XML_ELEMENT_WRAPPER_NAME);
    }

    private ICompilationUnit createTestXmlElementWrapperWithNamespace() throws Exception {
        return this.createTestXmlElementWrapperWithStringElement("namespace", XML_ELEMENT_WRAPPER_NAMESPACE);
    }

    private ICompilationUnit createTestXmlElementWrapperWithStringElement(final String element, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElementWrapper"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementWrapper(" + element + " = \"" + value + "\")");
            }
        });
    }

    private ICompilationUnit createTestXmlElementWrapperWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElementWrapper"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementWrapper(" + booleanElement + " = true)");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWrapperWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        XmlElementWrapperAnnotationTests.assertTrue((xmlElementWrapperAnnotation != null ? 1 : 0) != 0);
        XmlElementWrapperAnnotationTests.assertEquals((String)XML_ELEMENT_WRAPPER_NAME, (String)xmlElementWrapperAnnotation.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWrapper();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        XmlElementWrapperAnnotationTests.assertTrue((xmlElementWrapperAnnotation != null ? 1 : 0) != 0);
        XmlElementWrapperAnnotationTests.assertNull((Object)xmlElementWrapperAnnotation.getName());
        XmlElementWrapperAnnotationTests.assertNull((Object)xmlElementWrapperAnnotation.getNamespace());
        XmlElementWrapperAnnotationTests.assertNull((Object)xmlElementWrapperAnnotation.getNillable());
        XmlElementWrapperAnnotationTests.assertNull((Object)xmlElementWrapperAnnotation.getRequired());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWrapper();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        XmlElementWrapperAnnotationTests.assertNull((Object)xmlElementWrapperAnnotation.getName());
        xmlElementWrapperAnnotation.setName(XML_ELEMENT_WRAPPER_NAME);
        XmlElementWrapperAnnotationTests.assertEquals((String)XML_ELEMENT_WRAPPER_NAME, (String)xmlElementWrapperAnnotation.getName());
        this.assertSourceContains("@XmlElementWrapper(name = \"elementName\")", cu);
        xmlElementWrapperAnnotation.setName(null);
        XmlElementWrapperAnnotationTests.assertNull((Object)xmlElementWrapperAnnotation.getName());
        this.assertSourceContains("@XmlElementWrapper", cu);
        this.assertSourceDoesNotContain("@XmlElementWrapper(name = \"elementName\")", cu);
    }

    public void testGetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWrapperWithNamespace();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        XmlElementWrapperAnnotationTests.assertTrue((xmlElementWrapperAnnotation != null ? 1 : 0) != 0);
        XmlElementWrapperAnnotationTests.assertEquals((String)XML_ELEMENT_WRAPPER_NAMESPACE, (String)xmlElementWrapperAnnotation.getNamespace());
    }

    public void testSetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWrapper();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        XmlElementWrapperAnnotationTests.assertNull((Object)xmlElementWrapperAnnotation.getNamespace());
        xmlElementWrapperAnnotation.setNamespace(XML_ELEMENT_WRAPPER_NAMESPACE);
        XmlElementWrapperAnnotationTests.assertEquals((String)XML_ELEMENT_WRAPPER_NAMESPACE, (String)xmlElementWrapperAnnotation.getNamespace());
        this.assertSourceContains("@XmlElementWrapper(namespace = \"XmlElementWrapperNamespace\")", cu);
        xmlElementWrapperAnnotation.setNamespace(null);
        XmlElementWrapperAnnotationTests.assertNull((Object)xmlElementWrapperAnnotation.getNamespace());
        this.assertSourceContains("@XmlElementWrapper", cu);
        this.assertSourceDoesNotContain("@XmlElementWrapper(namespace = \"XmlElementWrapperNamespace\")", cu);
    }

    public void testGetNillable() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWrapperWithBooleanElement("nillable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        XmlElementWrapperAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementWrapperAnnotation.getNillable());
    }

    public void testSetNillable() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWrapper();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        XmlElementWrapperAnnotationTests.assertNotNull((Object)xmlElementWrapperAnnotation);
        XmlElementWrapperAnnotationTests.assertNull((Object)xmlElementWrapperAnnotation.getNillable());
        xmlElementWrapperAnnotation.setNillable(Boolean.FALSE);
        XmlElementWrapperAnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)xmlElementWrapperAnnotation.getNillable());
        this.assertSourceContains("@XmlElementWrapper(nillable = false)", cu);
        xmlElementWrapperAnnotation.setNillable(null);
        this.assertSourceContains("@XmlElementWrapper", cu);
        this.assertSourceDoesNotContain("nillable", cu);
    }

    public void testGetRequired() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWrapperWithBooleanElement("required");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        XmlElementWrapperAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementWrapperAnnotation.getRequired());
    }

    public void testSetRequired() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementWrapper();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        XmlElementWrapperAnnotationTests.assertNotNull((Object)xmlElementWrapperAnnotation);
        XmlElementWrapperAnnotationTests.assertNull((Object)xmlElementWrapperAnnotation.getRequired());
        xmlElementWrapperAnnotation.setRequired(Boolean.FALSE);
        XmlElementWrapperAnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)xmlElementWrapperAnnotation.getRequired());
        this.assertSourceContains("@XmlElementWrapper(required = false)", cu);
        xmlElementWrapperAnnotation.setRequired(null);
        this.assertSourceContains("@XmlElementWrapper", cu);
        this.assertSourceDoesNotContain("required", cu);
    }
}

