/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSeeAlsoAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlSeeAlsoAnnotationTests
extends JaxbJavaResourceModelTestCase {
    public XmlSeeAlsoAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlSeeAlso() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlSeeAlso"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlSeeAlso");
            }
        });
    }

    private ICompilationUnit createTestXmlSeeAlsoWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlSeeAlso"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlSeeAlso(value = {Foo.class, Bar.class})");
            }
        });
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlSeeAlso();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlSeeAlsoAnnotation xmlSeeAlsoAnnotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        XmlSeeAlsoAnnotationTests.assertTrue((xmlSeeAlsoAnnotation != null ? 1 : 0) != 0);
        XmlSeeAlsoAnnotationTests.assertEquals((int)0, (int)xmlSeeAlsoAnnotation.getClassesSize());
    }

    public void testGetClasses() throws Exception {
        ICompilationUnit cu = this.createTestXmlSeeAlsoWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlSeeAlsoAnnotation xmlSeeAlsoAnnotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        XmlSeeAlsoAnnotationTests.assertTrue((xmlSeeAlsoAnnotation != null ? 1 : 0) != 0);
        ListIterator classes = xmlSeeAlsoAnnotation.getClasses().iterator();
        XmlSeeAlsoAnnotationTests.assertEquals((String)"Foo", (String)((String)classes.next()));
        XmlSeeAlsoAnnotationTests.assertEquals((String)"Bar", (String)((String)classes.next()));
    }

    public void testGetClassesSize() throws Exception {
        ICompilationUnit cu = this.createTestXmlSeeAlsoWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlSeeAlsoAnnotation xmlSeeAlsoAnnotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        XmlSeeAlsoAnnotationTests.assertTrue((xmlSeeAlsoAnnotation != null ? 1 : 0) != 0);
        XmlSeeAlsoAnnotationTests.assertEquals((int)2, (int)xmlSeeAlsoAnnotation.getClassesSize());
    }

    public void testAddClass() throws Exception {
        ICompilationUnit cu = this.createTestXmlSeeAlso();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlSeeAlsoAnnotation xmlSeeAlsoAnnotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        XmlSeeAlsoAnnotationTests.assertTrue((xmlSeeAlsoAnnotation != null ? 1 : 0) != 0);
        xmlSeeAlsoAnnotation.addClass("Fooo");
        xmlSeeAlsoAnnotation.addClass("Barrr");
        this.assertSourceContains("@XmlSeeAlso({ Fooo.class, Barrr.class })", cu);
    }

    public void testAddClassIndex() throws Exception {
        ICompilationUnit cu = this.createTestXmlSeeAlso();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlSeeAlsoAnnotation xmlSeeAlsoAnnotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        XmlSeeAlsoAnnotationTests.assertTrue((xmlSeeAlsoAnnotation != null ? 1 : 0) != 0);
        xmlSeeAlsoAnnotation.addClass(0, "Fooo");
        xmlSeeAlsoAnnotation.addClass(0, "Barr");
        xmlSeeAlsoAnnotation.addClass(1, "Blah");
        this.assertSourceContains("@XmlSeeAlso({ Barr.class, Blah.class, Fooo.class })", cu);
    }

    public void testRemoveClass() throws Exception {
        ICompilationUnit cu = this.createTestXmlSeeAlsoWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlSeeAlsoAnnotation xmlSeeAlsoAnnotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        XmlSeeAlsoAnnotationTests.assertTrue((xmlSeeAlsoAnnotation != null ? 1 : 0) != 0);
        xmlSeeAlsoAnnotation.removeClass(0);
        this.assertSourceContains("@XmlSeeAlso(value = Bar.class)", cu);
        xmlSeeAlsoAnnotation.removeClass(0);
        this.assertSourceContains("@XmlSeeAlso", cu);
        this.assertSourceDoesNotContain("value", cu);
    }

    public void testMoveClass() throws Exception {
        ICompilationUnit cu = this.createTestXmlSeeAlso();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlSeeAlsoAnnotation xmlSeeAlsoAnnotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        XmlSeeAlsoAnnotationTests.assertTrue((xmlSeeAlsoAnnotation != null ? 1 : 0) != 0);
        xmlSeeAlsoAnnotation.addClass("Fooo");
        xmlSeeAlsoAnnotation.addClass("Barr");
        xmlSeeAlsoAnnotation.addClass("Blah");
        this.assertSourceContains("@XmlSeeAlso({ Fooo.class, Barr.class, Blah.class })", cu);
        xmlSeeAlsoAnnotation.moveClass(0, 1);
        this.assertSourceContains("@XmlSeeAlso({ Barr.class, Fooo.class, Blah.class })", cu);
        xmlSeeAlsoAnnotation.moveClass(2, 1);
        this.assertSourceContains("@XmlSeeAlso({ Barr.class, Blah.class, Fooo.class })", cu);
    }
}

