/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.preferences;

import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposoalCatigoriesConfigurationRegistry;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.sse.ui.preferences.CodeAssistCyclingConfigurationBlock;
import org.eclipse.wst.sse.ui.preferences.ICompletionProposalCategoriesConfigurationWriter;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.preferences.XMLUIPreferenceNames;

public class XMLContentAssistPreferencePage
extends AbstractPreferencePage
implements IWorkbenchPreferencePage {
    private static final String XML_CONTENT_TYPE_ID = "org.eclipse.core.runtime.xml";
    private Button fAutoPropose;
    private Label fAutoProposeDelayLabel;
    private Text fAutoProposeDelay;
    private Label fAutoProposeLabel;
    private Text fAutoProposeText;
    private Combo fSuggestionStrategyCombo;
    private Vector fSuggestionStrategies = null;
    private CodeAssistCyclingConfigurationBlock fConfigurationBlock;

    protected Control createContents(Composite parent) {
        Composite composite = super.createComposite(parent, 1);
        this.createContentsForAutoActivationGroup(composite);
        this.createContentsForCyclingGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    protected void performDefaults() {
        this.performDefaultsForAutoActivationGroup();
        this.performDefaultsForCyclingGroup();
        this.validateValues();
        this.enableValues();
        super.performDefaults();
    }

    protected void initializeValues() {
        this.initializeValuesForAutoActivationGroup();
        this.initializeValuesForCyclingGroup();
    }

    protected void storeValues() {
        this.storeValuesForAutoActivationGroup();
        this.storeValuesForCyclingGroup();
    }

    protected void enableValues() {
        if (this.fAutoPropose != null) {
            if (this.fAutoPropose.getSelection()) {
                this.fAutoProposeDelayLabel.setEnabled(true);
                this.fAutoProposeDelay.setEnabled(true);
                this.fAutoProposeLabel.setEnabled(true);
                this.fAutoProposeText.setEnabled(true);
            } else {
                this.fAutoProposeDelayLabel.setEnabled(false);
                this.fAutoProposeDelay.setEnabled(false);
                this.fAutoProposeLabel.setEnabled(false);
                this.fAutoProposeText.setEnabled(false);
            }
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return XMLUIPlugin.getDefault().getPreferenceStore();
    }

    private void createContentsForAutoActivationGroup(Composite parent) {
        Group contentAssistGroup = this.createGroup(parent, 2);
        contentAssistGroup.setText(XMLUIMessages.XMLContentAssistPreferencePage_Auto_Activation_UI_);
        this.fAutoPropose = this.createCheckBox((Composite)contentAssistGroup, XMLUIMessages.Automatically_make_suggest_UI_);
        ((GridData)this.fAutoPropose.getLayoutData()).horizontalSpan = 2;
        this.fAutoPropose.addSelectionListener((SelectionListener)this);
        this.fAutoProposeDelayLabel = this.createLabel((Composite)contentAssistGroup, XMLUIMessages.Auto_Activation_Delay);
        this.fAutoProposeDelay = this.createTextField((Composite)contentAssistGroup);
        this.fAutoProposeDelay.setTextLimit(4);
        this.fAutoProposeDelay.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLContentAssistPreferencePage.this.verifyDelay();
            }
        });
        this.fAutoProposeLabel = this.createLabel((Composite)contentAssistGroup, XMLUIMessages.Prompt_when_these_characte_UI_);
        this.fAutoProposeText = this.createTextField((Composite)contentAssistGroup);
        this.createLabel((Composite)contentAssistGroup, XMLUIMessages.Suggestion_Strategy);
        this.fSuggestionStrategyCombo = new Combo((Composite)contentAssistGroup, 8);
        this.fSuggestionStrategies = new Vector();
        this.fSuggestionStrategyCombo.setLayoutData((Object)new GridData(768));
        this.fSuggestionStrategyCombo.add(XMLUIMessages.Suggestion_Strategy_Lax);
        this.fSuggestionStrategies.add("Lax");
        this.fSuggestionStrategyCombo.add(XMLUIMessages.Suggestion_Strategy_Strict);
        this.fSuggestionStrategies.add("Strict");
    }

    private void verifyDelay() {
        String text = this.fAutoProposeDelay.getText();
        boolean valid = true;
        try {
            int delay = Integer.parseInt(text);
            if (delay < 0) {
                valid = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            valid = false;
        }
        if (!valid) {
            if (text.trim().length() > 0) {
                this.setErrorMessage(NLS.bind((String)XMLUIMessages.Not_an_integer, (Object)text));
            } else {
                this.setErrorMessage(XMLUIMessages.Missing_integer);
            }
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    private void createContentsForCyclingGroup(Composite parent) {
        ICompletionProposalCategoriesConfigurationWriter configurationWriter = CompletionProposoalCatigoriesConfigurationRegistry.getDefault().getWritableConfiguration(XML_CONTENT_TYPE_ID);
        if (configurationWriter != null) {
            this.fConfigurationBlock = new CodeAssistCyclingConfigurationBlock(XML_CONTENT_TYPE_ID, configurationWriter);
            this.fConfigurationBlock.createContents(parent, XMLUIMessages.XMLContentAssistPreferencePage_Cycling_UI_);
        } else {
            Logger.log((int)4, (String)"There should be an ICompletionProposalCategoriesConfigurationWriter specified for the XML content type, but can't fine it, thus can't create user preference block for editing proposal categories preferences.");
        }
    }

    private void storeValuesForAutoActivationGroup() {
        this.getPreferenceStore().setValue(XMLUIPreferenceNames.AUTO_PROPOSE, this.fAutoPropose.getSelection());
        this.getPreferenceStore().setValue(XMLUIPreferenceNames.AUTO_PROPOSE_CODE, this.fAutoProposeText.getText());
        this.getPreferenceStore().setValue(XMLUIPreferenceNames.SUGGESTION_STRATEGY, this.getCurrentAutoActivationSuggestionStrategy());
        this.getPreferenceStore().setValue("autoProposeDelay", Integer.parseInt(this.fAutoProposeDelay.getText()));
    }

    private void storeValuesForCyclingGroup() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.storeValues();
        }
    }

    private void initializeValuesForAutoActivationGroup() {
        this.fAutoPropose.setSelection(this.getPreferenceStore().getBoolean(XMLUIPreferenceNames.AUTO_PROPOSE));
        this.fAutoProposeText.setText(this.getPreferenceStore().getString(XMLUIPreferenceNames.AUTO_PROPOSE_CODE));
        this.fAutoProposeDelay.setText(Integer.toString(this.getPreferenceStore().getInt("autoProposeDelay")));
        String suggestionStrategy = this.getPreferenceStore().getString(XMLUIPreferenceNames.SUGGESTION_STRATEGY);
        if (suggestionStrategy.length() > 0) {
            this.setCurrentAutoActivationSuggestionStrategy(suggestionStrategy);
        } else {
            this.setCurrentAutoActivationSuggestionStrategy("Lax");
        }
    }

    private void initializeValuesForCyclingGroup() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.initializeValues();
        }
    }

    private void performDefaultsForAutoActivationGroup() {
        this.fAutoPropose.setSelection(this.getPreferenceStore().getDefaultBoolean(XMLUIPreferenceNames.AUTO_PROPOSE));
        this.fAutoProposeText.setText(this.getPreferenceStore().getDefaultString(XMLUIPreferenceNames.AUTO_PROPOSE_CODE));
        this.fAutoProposeDelay.setText(Integer.toString(this.getPreferenceStore().getDefaultInt("autoProposeDelay")));
        String suggestionStrategy = this.getPreferenceStore().getDefaultString(XMLUIPreferenceNames.SUGGESTION_STRATEGY);
        if (suggestionStrategy.length() > 0) {
            this.setCurrentAutoActivationSuggestionStrategy(suggestionStrategy);
        } else {
            this.setCurrentAutoActivationSuggestionStrategy("Lax");
        }
    }

    private void performDefaultsForCyclingGroup() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performDefaults();
        }
    }

    private String getCurrentAutoActivationSuggestionStrategy() {
        int i = this.fSuggestionStrategyCombo.getSelectionIndex();
        if (i >= 0) {
            return (String)this.fSuggestionStrategies.elementAt(i);
        }
        return "";
    }

    private void setCurrentAutoActivationSuggestionStrategy(String strategy) {
        this.fSuggestionStrategyCombo.clearSelection();
        this.fSuggestionStrategyCombo.deselectAll();
        int i = this.fSuggestionStrategies.indexOf(strategy);
        if (i >= 0) {
            this.fSuggestionStrategyCombo.select(i);
        }
    }
}

