/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import java.util.Iterator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.swt.ColumnAdapter;
import org.eclipse.jpt.common.ui.internal.swt.TableModelAdapter;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AddRemoveTablePane<T extends Model>
extends AddRemovePane<T> {
    private boolean locked;
    private Table table;

    public AddRemoveTablePane(Pane<? extends T> parentPane, Composite parent, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, ITableLabelProvider labelProvider) {
        super(parentPane, parent, adapter, listHolder, selectedItemHolder, (IBaseLabelProvider)labelProvider);
    }

    public AddRemoveTablePane(Pane<? extends T> parentPane, Composite parent, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, ITableLabelProvider labelProvider, String helpId) {
        super(parentPane, parent, adapter, listHolder, selectedItemHolder, (IBaseLabelProvider)labelProvider, helpId);
    }

    public AddRemoveTablePane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, ITableLabelProvider labelProvider) {
        super(parentPane, subjectHolder, parent, adapter, listHolder, selectedItemHolder, (IBaseLabelProvider)labelProvider);
    }

    public AddRemoveTablePane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, ITableLabelProvider labelProvider, String helpId) {
        super(parentPane, subjectHolder, parent, adapter, listHolder, selectedItemHolder, (IBaseLabelProvider)labelProvider, helpId);
    }

    protected abstract ColumnAdapter<?> buildColumnAdapter();

    private WritablePropertyValueModel<Object> buildSelectedItemHolder() {
        return new SimplePropertyValueModel();
    }

    private PropertyChangeListener buildSelectedItemPropertyChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildSelectedItemPropertyChangeListener_());
    }

    private PropertyChangeListener buildSelectedItemPropertyChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                if (AddRemoveTablePane.this.table.isDisposed()) {
                    return;
                }
                if (!AddRemoveTablePane.this.locked) {
                    AddRemoveTablePane.this.locked = true;
                    try {
                        Object value = e.getNewValue();
                        AddRemoveTablePane.this.getSelectionModel().setSelectedValue(e.getNewValue());
                        int index = -1;
                        if (value != null) {
                            index = CollectionTools.indexOf((Iterator)AddRemoveTablePane.this.getListHolder().iterator(), (Object)value);
                        }
                        AddRemoveTablePane.this.table.select(index);
                        AddRemoveTablePane.this.updateButtons();
                    }
                    finally {
                        AddRemoveTablePane.this.locked = false;
                    }
                }
            }
        };
    }

    private TableModelAdapter.SelectionChangeListener<Object> buildSelectionListener() {
        return new TableModelAdapter.SelectionChangeListener<Object>(){

            @Override
            public void selectionChanged(TableModelAdapter.SelectionChangeEvent<Object> e) {
                AddRemoveTablePane.this.selectionChanged();
            }
        };
    }

    public Table getMainControl() {
        return this.table;
    }

    @Override
    protected void initializeMainComposite(Composite container, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, IBaseLabelProvider labelProvider, String helpId) {
        this.table = this.addUnmanagedTable(container, helpId);
        this.table.setHeaderVisible(true);
        TableModelAdapter<Object> tableModel = TableModelAdapter.adapt(listHolder, this.buildSelectedItemHolder(), this.table, this.buildColumnAdapter(), (ITableLabelProvider)labelProvider);
        tableModel.addSelectionChangeListener(this.buildSelectionListener());
        selectedItemHolder.addPropertyChangeListener("value", this.buildSelectedItemPropertyChangeListener());
    }

    private void selectionChanged() {
        if (this.locked) {
            return;
        }
        this.locked = true;
        try {
            WritablePropertyValueModel<Object> selectedItemHolder = this.getSelectedItemHolder();
            ObjectListSelectionModel selectionModel = this.getSelectionModel();
            int selectionCount = this.table.getSelectionCount();
            if (selectionCount == 0) {
                selectedItemHolder.setValue(null);
                selectionModel.clearSelection();
            } else if (selectionCount != 1) {
                selectedItemHolder.setValue(null);
                selectionModel.clearSelection();
                int[] nArray = this.table.getSelectionIndices();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    selectionModel.addSelectionInterval(index, index);
                    ++n2;
                }
            } else {
                int selectedIndex = this.table.getSelectionIndex();
                Object selectedItem = this.getListHolder().get(selectedIndex);
                selectedItemHolder.setValue(selectedItem);
                selectionModel.setSelectedValue(selectedItem);
            }
            this.updateButtons();
        }
        finally {
            this.locked = false;
        }
    }
}

