/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jface;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;

public class XmlMappingFileViewerFilter
extends ViewerFilter {
    private final JpaProject jpaProject;

    public XmlMappingFileViewerFilter(JpaProject jpaProject) {
        this.jpaProject = jpaProject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IFile) {
            return this.isMappingFile((IFile)element);
        }
        if (!(element instanceof IContainer)) return false;
        IContainer container = (IContainer)element;
        IProject project = this.jpaProject.getProject();
        if (!JptCommonCorePlugin.getResourceLocator((IProject)project).acceptResourceLocation(project, container)) return false;
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource resource = iResourceArray[n2];
                if (this.select(viewer, container, resource)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            JptJpaUiPlugin.log(ce);
        }
        return false;
    }

    private boolean isMappingFile(IFile file) {
        JpaFile jpaFile = this.jpaProject.getJpaFile(file);
        return jpaFile != null ? jpaFile.getContentType().isKindOf(JptJpaCorePlugin.MAPPING_FILE_CONTENT_TYPE) : false;
    }
}

