/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.platform.base;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.JpaPlatformUiProvider;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.MappingResourceUiDefinition;
import org.eclipse.jpt.jpa.ui.ResourceUiDefinition;
import org.eclipse.jpt.jpa.ui.details.DefaultMappingUiDefinition;
import org.eclipse.jpt.jpa.ui.details.JpaComposite;
import org.eclipse.jpt.jpa.ui.details.JpaDetailsPage;
import org.eclipse.jpt.jpa.ui.details.JpaDetailsProvider;
import org.eclipse.jpt.jpa.ui.details.MappingUiDefinition;
import org.eclipse.jpt.jpa.ui.internal.platform.base.EntitiesGenerator;
import org.eclipse.jpt.jpa.ui.navigator.JpaNavigatorProvider;
import org.eclipse.jpt.jpa.ui.structure.JpaStructureProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJpaPlatformUi
implements JpaPlatformUi {
    private final JpaNavigatorProvider navigatorProvider;
    private final JpaPlatformUiProvider platformUiProvider;

    protected BaseJpaPlatformUi(JpaNavigatorProvider navigatorProvider, JpaPlatformUiProvider platformUiProvider) {
        this.navigatorProvider = navigatorProvider;
        this.platformUiProvider = platformUiProvider;
    }

    @Override
    public JpaNavigatorProvider getNavigatorProvider() {
        return this.navigatorProvider;
    }

    @Override
    public JpaStructureProvider getStructureProvider(JpaFile jpaFile) {
        JptResourceType resourceType = jpaFile.getResourceModel().getResourceType();
        return resourceType == null ? null : this.getStructureProvider(resourceType);
    }

    protected JpaStructureProvider getStructureProvider(JptResourceType resourceType) {
        ResourceUiDefinition definition;
        try {
            definition = this.getResourceUiDefinition(resourceType);
        }
        catch (IllegalArgumentException iae) {
            JptJpaUiPlugin.log(iae);
            return null;
        }
        return definition.getStructureProvider();
    }

    @Override
    public JpaDetailsPage<? extends JpaStructureNode> buildJpaDetailsPage(Composite parent, JpaStructureNode structureNode, WidgetFactory widgetFactory) {
        JpaDetailsProvider jpaDetailsProvider = this.getDetailsProvider(structureNode);
        return jpaDetailsProvider == null ? null : jpaDetailsProvider.buildDetailsPage(parent, widgetFactory);
    }

    protected JpaDetailsProvider getDetailsProvider(JpaStructureNode structureNode) {
        for (JpaDetailsProvider provider : CollectionTools.iterable(this.detailsProviders())) {
            if (!provider.providesDetails(structureNode)) continue;
            return provider;
        }
        return null;
    }

    protected ListIterator<JpaDetailsProvider> detailsProviders() {
        return this.platformUiProvider.detailsProviders();
    }

    @Override
    public JpaComposite buildTypeMappingComposite(JptResourceType resourceType, String mappingKey, Composite parent, PropertyValueModel<TypeMapping> mappingHolder, WidgetFactory widgetFactory) {
        return this.getMappingResourceUiDefinition(resourceType).buildTypeMappingComposite(mappingKey, mappingHolder, parent, widgetFactory);
    }

    @Override
    public JpaComposite buildAttributeMappingComposite(JptResourceType resourceType, String mappingKey, Composite parent, PropertyValueModel<AttributeMapping> mappingHolder, WidgetFactory widgetFactory) {
        return this.getMappingResourceUiDefinition(resourceType).buildAttributeMappingComposite(mappingKey, mappingHolder, parent, widgetFactory);
    }

    @Override
    public DefaultMappingUiDefinition<ReadOnlyPersistentAttribute, ? extends AttributeMapping> getDefaultAttributeMappingUiDefinition(JptResourceType resourceType, String mappingKey) {
        return this.getMappingResourceUiDefinition(resourceType).getDefaultAttributeMappingUiDefinition(mappingKey);
    }

    @Override
    public Iterator<MappingUiDefinition<ReadOnlyPersistentAttribute, ? extends AttributeMapping>> attributeMappingUiDefinitions(JptResourceType resourceType) {
        return this.getMappingResourceUiDefinition(resourceType).attributeMappingUiDefinitions();
    }

    @Override
    public DefaultMappingUiDefinition<PersistentType, ? extends TypeMapping> getDefaultTypeMappingUiDefinition(JptResourceType resourceType) {
        return this.getMappingResourceUiDefinition(resourceType).getDefaultTypeMappingUiDefinition();
    }

    @Override
    public Iterator<MappingUiDefinition<PersistentType, ? extends TypeMapping>> typeMappingUiDefinitions(JptResourceType resourceType) {
        return this.getMappingResourceUiDefinition(resourceType).typeMappingUiDefinitions();
    }

    protected ListIterator<ResourceUiDefinition> resourceUiDefinitions() {
        return this.platformUiProvider.resourceUiDefinitions();
    }

    @Override
    public ResourceUiDefinition getResourceUiDefinition(JptResourceType resourceType) {
        for (ResourceUiDefinition definition : CollectionTools.iterable(this.resourceUiDefinitions())) {
            if (!definition.providesUi(resourceType)) continue;
            return definition;
        }
        throw new IllegalArgumentException("No resource UI definition for the resource type: " + resourceType);
    }

    public MappingResourceUiDefinition getMappingResourceUiDefinition(JptResourceType resourceType) {
        ResourceUiDefinition def = this.getResourceUiDefinition(resourceType);
        try {
            return (MappingResourceUiDefinition)def;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("No mapping resource UI definition for the resource type: " + resourceType, cce);
        }
    }

    @Override
    public void generateEntities(JpaProject project, IStructuredSelection selection) {
        EntitiesGenerator.generate(project, selection);
    }

    protected void displayMessage(String title, String message) {
        Shell currentShell = Display.getCurrent().getActiveShell();
        MessageDialog.openInformation((Shell)currentShell, (String)title, (String)message);
    }
}

