/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.modulecore;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.internal.modulecore.SingleRootUtil;
import org.eclipse.wst.common.componentcore.internal.flat.AbstractFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.ChildModuleReference;
import org.eclipse.wst.common.componentcore.internal.flat.FlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.FlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.FlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IChildModuleReference;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.IFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.VirtualComponentFlattenUtility;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleRootExportParticipant
extends AbstractFlattenParticipant {
    private SingleRootParticipantCallback callbackHandler = null;
    private IVirtualComponent rootComponent;
    private FlatVirtualComponent.FlatComponentTaskModel dataModel;
    private IFlattenParticipant[] delegates;
    private List<IChildModuleReference> children;
    private IFlatResource[] moduleResources = null;

    public SingleRootExportParticipant() {
    }

    public SingleRootExportParticipant(SingleRootParticipantCallback handler) {
        this();
        this.callbackHandler = handler;
    }

    public void initialize(IVirtualComponent component, FlatVirtualComponent.FlatComponentTaskModel dataModel, List<IFlatResource> resources) {
        this.rootComponent = component;
        this.dataModel = dataModel;
    }

    private void initializeDelegates() {
        this.delegates = this.callbackHandler != null ? this.callbackHandler.getDelegateParticipants() : new IFlattenParticipant[0];
    }

    public boolean canOptimize(IVirtualComponent component, FlatVirtualComponent.FlatComponentTaskModel dataModel) {
        return new SingleRootUtil(component, this.callbackHandler).isSingleRoot();
    }

    public void optimize(IVirtualComponent component, FlatVirtualComponent.FlatComponentTaskModel dataModel, List<IFlatResource> resources, List<IChildModuleReference> childModules) {
        try {
            resources.clear();
            childModules.clear();
            this.children = childModules;
            this.initializeDelegates();
            IContainer container = new SingleRootUtil(component, this.callbackHandler).getSingleRoot();
            this.moduleResources = this.getMembers(resources, container, (IPath)new Path(""));
            this.addChildModules(component);
            int size = this.moduleResources.length;
            int j = 0;
            while (j < size) {
                resources.add(this.moduleResources[j]);
                ++j;
            }
            int i = 0;
            while (i < this.delegates.length) {
                this.delegates[i].finalize(component, dataModel, resources);
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    protected IFlatResource[] getMembers(List<IFlatResource> members, IContainer cont, IPath path) throws CoreException {
        IResource[] res = cont.members();
        int size2 = res.length;
        ArrayList<FlatFile> list = new ArrayList<FlatFile>(size2);
        int j = 0;
        while (j < size2) {
            FlatFile mf;
            if (res[j] instanceof IContainer) {
                IContainer cc = (IContainer)res[j];
                mf = (FlatFolder)VirtualComponentFlattenUtility.getExistingModuleResource(members, (IPath)path.append(new Path(cc.getName()).makeRelative()));
                if (mf == null) {
                    mf = new FlatFolder(cc, cc.getName(), path);
                    FlatFolder parent = (FlatFolder)VirtualComponentFlattenUtility.getExistingModuleResource(members, (IPath)path);
                    if (path.isEmpty() || path.equals((Object)new Path("/"))) {
                        members.add((IFlatResource)mf);
                    } else {
                        if (parent == null) {
                            parent = VirtualComponentFlattenUtility.ensureParentExists(members, (IPath)path, (IContainer)cc);
                        }
                        VirtualComponentFlattenUtility.addMembersToModuleFolder((IFlatFolder)parent, (IFlatResource[])new IFlatResource[]{mf});
                    }
                }
                IFlatResource[] mr = this.getMembers(members, cc, path.append(cc.getName()));
                VirtualComponentFlattenUtility.addMembersToModuleFolder((IFlatFolder)mf, (IFlatResource[])mr);
            } else {
                IFile f = (IFile)res[j];
                mf = VirtualComponentFlattenUtility.createModuleFile((IFile)f, (IPath)path);
                if (this.shouldAddComponentFile(this.rootComponent, (IFlatFile)mf)) {
                    list.add(mf);
                }
            }
            ++j;
        }
        FlatResource[] mr = new FlatResource[list.size()];
        list.toArray(mr);
        return mr;
    }

    protected void addChildModules(IVirtualComponent vc) throws CoreException {
        ArrayList<Object> modResources = new ArrayList<Object>();
        modResources.addAll(Arrays.asList(this.moduleResources));
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("REQUESTED_REFERENCE_TYPE", "FLATTENABLE_REFERENCES");
        IVirtualReference[] allReferences = vc.getReferences(options);
        int i = 0;
        while (i < allReferences.length) {
            IVirtualReference reference = allReferences[i];
            if (reference.getDependencyType() == 0 && !this.shouldIgnoreReference(vc, reference)) {
                if (this.isChildModule(vc, reference)) {
                    ChildModuleReference cm = new ChildModuleReference(reference, (IPath)new Path(""));
                    ArrayList<IChildModuleReference> duplicates = new ArrayList<IChildModuleReference>();
                    for (IChildModuleReference tmp : this.children) {
                        if (!tmp.getRelativeURI().equals((Object)cm.getRelativeURI())) continue;
                        duplicates.add(tmp);
                    }
                    this.children.removeAll(duplicates);
                    this.children.add((IChildModuleReference)cm);
                } else {
                    IPath path = reference.getRuntimePath();
                    IFlatFolder folder = (IFlatFolder)VirtualComponentFlattenUtility.getExistingModuleResource(modResources, (IPath)path.makeRelative());
                    if (folder == null) {
                        folder = VirtualComponentFlattenUtility.ensureParentExists(modResources, (IPath)path, null);
                    }
                    File f = (File)reference.getReferencedComponent().getAdapter(File.class);
                    FlatFile file = new FlatFile(f, reference.getArchiveName(), reference.getRuntimePath());
                    if (folder == null) {
                        modResources.add(file);
                    } else {
                        VirtualComponentFlattenUtility.addMembersToModuleFolder((IFlatFolder)folder, (IFlatResource[])new IFlatFile[]{file});
                    }
                }
            }
            ++i;
        }
        this.moduleResources = modResources.toArray(new IFlatResource[modResources.size()]);
    }

    protected boolean isChildModule(IVirtualComponent component, IVirtualReference referencedComponent) {
        int i = 0;
        while (i < this.delegates.length) {
            if (this.delegates[i].isChildModule(component, referencedComponent, this.dataModel)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean shouldIgnoreReference(IVirtualComponent component, IVirtualReference referencedComponent) {
        int i = 0;
        while (i < this.delegates.length) {
            if (this.delegates[i].shouldIgnoreReference(component, referencedComponent, this.dataModel)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean shouldAddComponentFile(IVirtualComponent component, IFlatFile file) {
        int i = 0;
        while (i < this.delegates.length) {
            if (this.delegates[i].isChildModule(component, this.dataModel, file)) {
                ChildModuleReference child = new ChildModuleReference(component.getProject(), file);
                this.children.add((IChildModuleReference)child);
                return false;
            }
            if (!this.delegates[i].shouldAddExportableFile(component, component, this.dataModel, file)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static interface SingleRootParticipantCallback
    extends SingleRootUtil.SingleRootCallback {
        public IFlattenParticipant[] getDelegateParticipants();
    }
}

