/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.format.FormatProcessorCSS;
import org.eclipse.wst.css.ui.internal.contentassist.CSSStructuredContentAssistProcessor;
import org.eclipse.wst.css.ui.internal.style.LineStyleProviderForCSS;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.format.StructuredFormattingStrategy;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class StructuredTextViewerConfigurationCSS
extends StructuredTextViewerConfiguration {
    private String[] fConfiguredContentTypes;
    private LineStyleProvider fLineStyleProviderForCSS;

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        ArrayList<IAutoEditStrategy> allStrategies = new ArrayList<IAutoEditStrategy>(0);
        IAutoEditStrategy[] superStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
        int i = 0;
        while (i < superStrategies.length) {
            allStrategies.add(superStrategies[i]);
            ++i;
        }
        return allStrategies.toArray(new IAutoEditStrategy[0]);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        if (this.fConfiguredContentTypes == null) {
            this.fConfiguredContentTypes = new String[]{"org.eclipse.wst.css.STYLE", "org.eclipse.wst.css.COMMENT", "org.eclipse.wst.sse.ST_DEFAULT", "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE"};
        }
        return this.fConfiguredContentTypes;
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        CSSStructuredContentAssistProcessor processor = new CSSStructuredContentAssistProcessor((ContentAssistant)this.getContentAssistant(), partitionType, (ITextViewer)sourceViewer);
        return new IContentAssistProcessor[]{processor};
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        IContentFormatter formatter = super.getContentFormatter(sourceViewer);
        if (!(formatter instanceof MultiPassContentFormatter)) {
            formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "org.eclipse.wst.css.STYLE");
        }
        ((MultiPassContentFormatter)formatter).setMasterStrategy((IFormattingStrategy)new StructuredFormattingStrategy((IStructuredFormatProcessor)new FormatProcessorCSS()));
        return formatter;
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        int indentationWidth = preferences.getInt("indentationSize");
        String indentCharPref = preferences.getString("indentationChar");
        boolean useSpaces = "space".equals(indentCharPref);
        int i = 0;
        while (i <= indentationWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            boolean appendTab = false;
            if (useSpaces) {
                j = 0;
                while (j + i < indentationWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    appendTab = true;
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != indentationWidth) {
                    appendTab = true;
                }
            }
            if (appendTab) {
                prefix.append('\t');
                vector.add(prefix.toString());
                prefix.deleteCharAt(prefix.length() - 1);
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        LineStyleProvider[] providers = null;
        if (partitionType == "org.eclipse.wst.css.STYLE" || partitionType == "org.eclipse.wst.css.COMMENT") {
            providers = new LineStyleProvider[]{this.getLineStyleProviderForCSS()};
        }
        return providers;
    }

    private LineStyleProvider getLineStyleProviderForCSS() {
        if (this.fLineStyleProviderForCSS == null) {
            this.fLineStyleProviderForCSS = new LineStyleProviderForCSS();
        }
        return this.fLineStyleProviderForCSS;
    }
}

