/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.editor;

import org.easymock.EasyMock;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaSelection;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaSelectionManager;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaSelectionParticipant;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditor;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;

public class EditorTest {
    @Test
    public void testJPADiagramEditorCreation() {
        JPADiagramEditor ed = new JPADiagramEditor();
        Assert.assertNotNull((Object)ed);
    }

    @Test
    public void testJPADiagramEditorPlugin() {
        JPADiagramEditorPlugin plugin = new JPADiagramEditorPlugin();
        BundleContext bc = (BundleContext)EasyMock.createMock(BundleContext.class);
        Bundle bundle = (Bundle)EasyMock.createMock(Bundle.class);
        EasyMock.expect((Object)bundle.getSymbolicName()).andStubReturn((Object)"");
        EasyMock.expect((Object)bc.getBundle()).andStubReturn((Object)bundle);
        bc.addBundleListener((BundleListener)EasyMock.isA(BundleListener.class));
        bc.removeBundleListener((BundleListener)EasyMock.isA(BundleListener.class));
        EasyMock.replay((Object[])new Object[]{bc, bundle});
        try {
            plugin.start(bc);
            plugin.stop(bc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EasyMock.verify((Object[])new Object[]{bc});
    }

    @Test
    public void testSelectionChanged() {
        IJPAEditorFeatureProvider provider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        IWorkbenchPart part = this.replayPart();
        PictogramElement pe = (PictogramElement)EasyMock.createMock(PictogramElement.class);
        EasyMock.replay((Object[])new Object[]{pe});
        EditPart editPart = (EditPart)EasyMock.createMock(EditPart.class);
        EasyMock.expect((Object)editPart.getModel()).andReturn((Object)pe);
        EasyMock.replay((Object[])new Object[]{editPart});
        JpaStructureNode jpaNodeToBeSelected = (JpaStructureNode)EasyMock.createMock(JpaStructureNode.class);
        EasyMock.expect((Object)provider.getBusinessObjectForPictogramElement(pe)).andReturn((Object)jpaNodeToBeSelected);
        EasyMock.replay((Object[])new Object[]{provider});
        JpaSelectionManager manager = (JpaSelectionManager)EasyMock.createMock(JpaSelectionManager.class);
        manager.select((JpaSelection)EasyMock.isA(JpaSelection.class), (JpaSelectionParticipant)EasyMock.eq(null));
        EasyMock.replay((Object[])new Object[]{manager});
        JPADiagramEditor.ISelectionManagerFactory factory = (JPADiagramEditor.ISelectionManagerFactory)EasyMock.createMock(JPADiagramEditor.ISelectionManagerFactory.class);
        EasyMock.expect((Object)factory.getSelectionManager((IWorkbenchWindow)EasyMock.isA(IWorkbenchWindow.class))).andReturn((Object)manager);
        EasyMock.replay((Object[])new Object[]{factory});
        JPADiagramEditor editor = this.createEditor(provider, factory);
        editor.selectionChanged(part, (ISelection)new StructuredSelection((Object)editPart));
        EasyMock.verify((Object[])new Object[]{manager});
    }

    private JPADiagramEditor createEditor(final IJPAEditorFeatureProvider provider, JPADiagramEditor.ISelectionManagerFactory factory) {
        IWorkbenchPage page = (IWorkbenchPage)EasyMock.createMock(IWorkbenchPage.class);
        EasyMock.expect((Object)page.isPartVisible((IWorkbenchPart)EasyMock.isA(IWorkbenchPart.class))).andReturn((Object)false);
        EasyMock.expect((Object)page.getActiveEditor()).andStubReturn(null);
        EasyMock.replay((Object[])new Object[]{page});
        final IWorkbenchPartSite site = (IWorkbenchPartSite)EasyMock.createMock(IWorkbenchPartSite.class);
        EasyMock.expect((Object)site.getPage()).andStubReturn((Object)page);
        EasyMock.replay((Object[])new Object[]{site});
        JPADiagramEditor editor = new JPADiagramEditor(factory){

            public IJPAEditorFeatureProvider getFeatureProvider() {
                return provider;
            }

            public IWorkbenchPartSite getSite() {
                return site;
            }
        };
        return editor;
    }

    private IWorkbenchPart replayPart() {
        IWorkbenchWindow window = (IWorkbenchWindow)EasyMock.createMock(IWorkbenchWindow.class);
        EasyMock.replay((Object[])new Object[]{window});
        IWorkbenchPage page = (IWorkbenchPage)EasyMock.createMock(IWorkbenchPage.class);
        IWorkbenchPartSite site = (IWorkbenchPartSite)EasyMock.createMock(IWorkbenchPartSite.class);
        EasyMock.expect((Object)site.getWorkbenchWindow()).andReturn((Object)window);
        EasyMock.expect((Object)site.getPage()).andStubReturn((Object)page);
        EasyMock.replay((Object[])new Object[]{site});
        IWorkbenchPart part = (IWorkbenchPart)EasyMock.createMock(IWorkbenchPart.class);
        EasyMock.expect((Object)part.getSite()).andStubReturn((Object)site);
        EasyMock.expect((Object)page.isPartVisible((IWorkbenchPart)EasyMock.isA(IWorkbenchPart.class))).andReturn((Object)false);
        EasyMock.expect((Object)page.getActiveEditor()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{page});
        EasyMock.replay((Object[])new Object[]{part});
        return part;
    }

    @Test
    public void testSelectionChangedTextSelection() {
        JPADiagramEditor editor = this.createEditor(null, null);
        editor.selectionChanged(null, new ISelection(){

            public boolean isEmpty() {
                return false;
            }
        });
    }

    @Test
    public void testSelectionChangedNotEditPart() {
        JPADiagramEditor editor = this.createEditor(null, null);
        editor.selectionChanged(null, (ISelection)new StructuredSelection(new Object()));
    }
}

