/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.modelintegration.ui;

import java.util.Iterator;
import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.ui.JPAEditorMatchingStrategy;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.IModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPADiagramEditorInput;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelIntegrationTest {
    private static final String CODE_GENERATED = "CODE_GENERATED";
    private IJPAEditorFeatureProvider featureProvider;
    final String TEST_PROJECT = "Test";
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    IEclipseFacade eclipseFacade = null;
    private String testProjectName = "Test_" + System.currentTimeMillis();
    IFile entityFile = null;

    @Before
    public void setUp() throws Exception {
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject(this.testProjectName);
        Assert.assertNotNull((Object)this.jpaProject);
        this.entityFile = this.factory.createEntity(this.jpaProject, "org.eclipse.Entity1");
        Thread.sleep(2000L);
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement(null)).andReturn((Object)ModelIntegrationTest.getPersistentType(this.entityFile));
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit((JavaPersistentType)EasyMock.isA(JavaPersistentType.class))).andReturn((Object)JavaCore.createCompilationUnitFrom((IFile)this.entityFile)).anyTimes();
    }

    @Test
    public void testJPAEditorMatchingStrategyWithEntityFileEditorInputTrue() {
        IEditorReference editorRef = (IEditorReference)EasyMock.createMock(IEditorReference.class);
        IFileEditorInput input = (IFileEditorInput)EasyMock.createMock(IFileEditorInput.class);
        EasyMock.expect((Object)input.getFile()).andStubReturn((Object)this.entityFile);
        EasyMock.expect((Object)input.getName()).andStubReturn((Object)CODE_GENERATED);
        ICompilationUnit cu = this.createCompilationUnitFrom(this.entityFile);
        IJPAEditorUtil ut = (IJPAEditorUtil)EasyMock.createMock(IJPAEditorUtil.class);
        JavaPersistentType inputJptType = ModelIntegrationTest.getPersistentType(this.entityFile);
        EasyMock.expect((Object)ut.getJPType(cu)).andStubReturn((Object)inputJptType);
        EasyMock.expect((Object)this.featureProvider.getJPAEditorUtil()).andStubReturn((Object)ut);
        Diagram d = (Diagram)EasyMock.createMock(Diagram.class);
        IJPADiagramEditorInput dEdInput = (IJPADiagramEditorInput)EasyMock.createMock(IJPADiagramEditorInput.class);
        try {
            EasyMock.expect((Object)editorRef.getEditorInput()).andStubReturn((Object)dEdInput);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        EasyMock.expect((Object)dEdInput.getDiagram()).andStubReturn((Object)d);
        IDiagramTypeProvider dtp = (IDiagramTypeProvider)EasyMock.createMock(IDiagramTypeProvider.class);
        EasyMock.expect((Object)this.featureProvider.getDiagramTypeProvider()).andStubReturn((Object)dtp);
        IModelIntegrationUtil moinIntUtil = (IModelIntegrationUtil)EasyMock.createMock(IModelIntegrationUtil.class);
        EasyMock.expect((Object)this.featureProvider.getMoinIntegrationUtil()).andStubReturn((Object)moinIntUtil);
        EasyMock.expect((Object)moinIntUtil.getProjectByDiagram(d)).andStubReturn((Object)this.jpaProject);
        PictogramElement pe = (PictogramElement)EasyMock.createMock(PictogramElement.class);
        EasyMock.expect((Object)this.featureProvider.getPictogramElementForBusinessObject((Object)inputJptType)).andStubReturn((Object)pe);
        IDiagramEditor dEd = (IDiagramEditor)EasyMock.createMock(IDiagramEditor.class);
        EasyMock.expect((Object)dtp.getDiagramEditor()).andStubReturn((Object)dEd);
        dEd.setPictogramElementForSelection(pe);
        JPAEditorMatchingStrategy str = new JPAEditorMatchingStrategy(this.featureProvider);
        EasyMock.replay((Object[])new Object[]{editorRef, d, dtp, pe, dEd, moinIntUtil, dEdInput, ut, input, this.featureProvider});
        Assert.assertTrue((boolean)str.matches(editorRef, (IEditorInput)input));
    }

    @Test
    public void testJPAEditorMatchingStrategyWithEntityFileEditorInputFalse() {
        IEditorReference editorRef = (IEditorReference)EasyMock.createMock(IEditorReference.class);
        IFileEditorInput input = (IFileEditorInput)EasyMock.createMock(IFileEditorInput.class);
        EasyMock.expect((Object)input.getFile()).andStubReturn((Object)this.entityFile);
        EasyMock.expect((Object)input.getName()).andStubReturn((Object)CODE_GENERATED);
        ICompilationUnit cu = this.createCompilationUnitFrom(this.entityFile);
        IJPAEditorUtil ut = (IJPAEditorUtil)EasyMock.createMock(IJPAEditorUtil.class);
        JavaPersistentType inputJptType = ModelIntegrationTest.getPersistentType(this.entityFile);
        EasyMock.expect((Object)ut.getJPType(cu)).andStubReturn((Object)inputJptType);
        EasyMock.expect((Object)this.featureProvider.getJPAEditorUtil()).andStubReturn((Object)ut);
        Diagram d = (Diagram)EasyMock.createMock(Diagram.class);
        IJPADiagramEditorInput dEdInput = (IJPADiagramEditorInput)EasyMock.createMock(IJPADiagramEditorInput.class);
        try {
            EasyMock.expect((Object)editorRef.getEditorInput()).andStubReturn((Object)dEdInput);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        EasyMock.expect((Object)dEdInput.getDiagram()).andStubReturn((Object)d);
        IDiagramTypeProvider dtp = (IDiagramTypeProvider)EasyMock.createMock(IDiagramTypeProvider.class);
        EasyMock.expect((Object)this.featureProvider.getDiagramTypeProvider()).andStubReturn((Object)dtp);
        IModelIntegrationUtil moinIntUtil = (IModelIntegrationUtil)EasyMock.createMock(IModelIntegrationUtil.class);
        EasyMock.expect((Object)this.featureProvider.getMoinIntegrationUtil()).andStubReturn((Object)moinIntUtil);
        JpaProject anotherJpaProject = (JpaProject)EasyMock.createMock(JpaProject.class);
        EasyMock.expect((Object)moinIntUtil.getProjectByDiagram(d)).andStubReturn((Object)anotherJpaProject);
        PictogramElement pe = (PictogramElement)EasyMock.createMock(PictogramElement.class);
        EasyMock.expect((Object)this.featureProvider.getPictogramElementForBusinessObject((Object)inputJptType)).andStubReturn((Object)pe);
        IDiagramEditor dEd = (IDiagramEditor)EasyMock.createMock(IDiagramEditor.class);
        EasyMock.expect((Object)dtp.getDiagramEditor()).andStubReturn((Object)dEd);
        dEd.setPictogramElementForSelection(pe);
        JPAEditorMatchingStrategy str = new JPAEditorMatchingStrategy(this.featureProvider);
        EasyMock.replay((Object[])new Object[]{editorRef, d, dtp, pe, dEd, moinIntUtil, anotherJpaProject, dEdInput, ut, input, this.featureProvider});
        Assert.assertFalse((boolean)str.matches(editorRef, (IEditorInput)input));
    }

    @Test
    public void testJPAEditorMatchingStrategyWithJPADiagramEditorInputTrue() {
        IEditorReference editorRef = (IEditorReference)EasyMock.createMock(IEditorReference.class);
        EasyMock.expect((Object)editorRef.getPartName()).andStubReturn((Object)"ProjectName");
        IJPADiagramEditorInput input = (IJPADiagramEditorInput)EasyMock.createMock(IJPADiagramEditorInput.class);
        EasyMock.expect((Object)input.getProjectName()).andStubReturn((Object)"ProjectName");
        JPAEditorMatchingStrategy str = new JPAEditorMatchingStrategy(this.featureProvider);
        EasyMock.replay((Object[])new Object[]{editorRef, input, this.featureProvider});
        Assert.assertTrue((boolean)str.matches(editorRef, (IEditorInput)input));
    }

    @Test
    public void testJPAEditorMatchingStrategyWithJPADiagramEditorInputFalse() {
        IEditorReference editorRef = (IEditorReference)EasyMock.createMock(IEditorReference.class);
        EasyMock.expect((Object)editorRef.getPartName()).andStubReturn((Object)"ProjectName");
        IJPADiagramEditorInput input = (IJPADiagramEditorInput)EasyMock.createMock(IJPADiagramEditorInput.class);
        EasyMock.expect((Object)input.getProjectName()).andStubReturn((Object)"DifferentProjectName");
        JPAEditorMatchingStrategy str = new JPAEditorMatchingStrategy(this.featureProvider);
        EasyMock.replay((Object[])new Object[]{editorRef, input, this.featureProvider});
        Assert.assertFalse((boolean)str.matches(editorRef, (IEditorInput)input));
    }

    public static JavaPersistentType getPersistentType(IFile file) {
        JpaFile jpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        Iterator<JpaStructureNode> iterator = ModelIntegrationTest.getRootNodes(jpaFile).iterator();
        if (iterator.hasNext()) {
            JpaStructureNode node = iterator.next();
            JavaPersistentType entity = (JavaPersistentType)node;
            return entity;
        }
        return null;
    }

    private static Iterable<JpaStructureNode> getRootNodes(JpaFile jpaFile) {
        if (jpaFile == null) {
            return EmptyIterable.instance();
        }
        return jpaFile.getRootStructureNodes();
    }

    public ICompilationUnit createCompilationUnitFrom(IFile file) {
        return JavaCore.createCompilationUnitFrom((IFile)file);
    }

    @After
    public void tearDown() throws Exception {
        this.deleteAllProjects();
    }

    private void deleteAllProjects() throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject project = ModelIntegrationTest.this.jpaProject.getProject();
                project.close(monitor);
                project.close(monitor);
                project.delete(true, true, monitor);
            }
        }, (IProgressMonitor)monitor);
    }
}

