/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.format;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapterFactory;
import org.eclipse.wst.jsdt.web.ui.StructuredTextViewerConfigurationJSDT;
import org.eclipse.wst.jsdt.web.ui.tests.internal.ProjectUtil;
import org.eclipse.wst.jsdt.web.ui.tests.internal.StringUtils;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class FormattingTests
extends TestCase {
    private static final String PROJECT_NAME = "FormattingTests";
    private static final String PROJECT_FILES = "/testFiles/formatting";
    private static IProject fProject;
    static /* synthetic */ Class class$0;

    public FormattingTests() {
        super("Formatting Tests");
    }

    public FormattingTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.ui.tests.format.FormattingTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, "Formatting Tests");
        return new FormattingTestsSetup((Test)ts);
    }

    public void testFormatHTMLScriptEvent() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test0.html", "test0.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegionWrappedWithHTMLComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test2.html", "test2-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegionWrappedWithHTMLCommentWithInvalidJS() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test3.html", "test3.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegionWithJustEndHTMLComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test4.html", "test4-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegionWithJustStartHTMLComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test5.html", "test5-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScript_WithHTMLTagInString() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test6.html", "test6-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScript_FormattingHTMLBeforeScript() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test7.html", "test7-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScript_WithHTMLTagInString_WithHTMLCommentStartAndEnd_simple() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test8.html", "test8-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScript_WithHTMLTagInString_WithHTMLCommentStartAndEnd_advanded() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test9.html", "test9-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegionWrappedWithHTMLComment_TextInLeadingComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test10.html", "test10-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegionWrappedWithHTMLComment_TextInTrailingComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test11.html", "test11-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegionWrappedWithHTMLComment_TextInLeadingComment_and_TextInTrailingComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test12.html", "test12-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegion_AllOnOneLine() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test13.html", "test13-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegion_AllOnOneLine_LeadingComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test14.html", "test14-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void formatAndAssertEquals(String beforePath, String afterPath, SourceViewerConfiguration configuration) throws UnsupportedEncodingException, IOException, CoreException {
        IStructuredModel afterModel;
        block11: {
            IStructuredModel beforeModel = null;
            afterModel = null;
            try {
                beforeModel = this.getModelForEdit(beforePath);
                FormattingTests.assertNotNull((String)("could not retrieve structured model for : " + beforePath), (Object)beforeModel);
                beforeModel.getFactoryRegistry().addFactory((INodeAdapterFactory)new JsTranslationAdapterFactory());
                afterModel = this.getModelForEdit(afterPath);
                FormattingTests.assertNotNull((String)("could not retrieve structured model for : " + afterPath), (Object)afterModel);
                IStructuredDocument document = beforeModel.getStructuredDocument();
                String normalizedContents = document.get();
                normalizedContents = StringUtils.replace(normalizedContents, "\r\n", "\n");
                normalizedContents = StringUtils.replace(normalizedContents, "\r", "\n");
                document.set(normalizedContents);
                ISourceViewer viewer = FormattingTests.getConfiguredViewer((IDocument)document, configuration);
                FormattingTests.assertNotNull((String)"Could not get viewer to run test", (Object)viewer);
                IContentFormatterExtension formatter = (IContentFormatterExtension)configuration.getContentFormatter(viewer);
                FormattingContext fContext = new FormattingContext();
                Region region = new Region(0, document.getLength());
                fContext.setProperty((Object)"formatting.context.document", (Object)true);
                fContext.setProperty((Object)"formatting.context.region", (Object)region);
                formatter.format((IDocument)document, (IFormattingContext)fContext);
                String actualContents = beforeModel.getStructuredDocument().get();
                String expectedContents = afterModel.getStructuredDocument().get();
                expectedContents = StringUtils.replace(expectedContents, "\r\n", "\n");
                expectedContents = StringUtils.replace(expectedContents, "\r", "\n");
                actualContents = StringUtils.replace(actualContents, "\r\n", "\n");
                actualContents = StringUtils.replace(actualContents, "\r", "\n");
                FormattingTests.assertTrue((String)("Formatted document differs from the expected.\nExpected Contents:\n" + expectedContents + "\nActual Contents:\n" + actualContents), (boolean)StringUtils.equalsIgnoreLineSeperator(expectedContents, actualContents));
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (beforeModel != null) {
                    try {
                        beforeModel.releaseFromEdit();
                    }
                    catch (Exception exception) {}
                }
                if (afterModel == null) throw throwable;
                try {
                    afterModel.releaseFromEdit();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var14_16 = null;
                if (beforeModel == null) break block11;
            }
            try {}
            catch (Exception exception) {}
            beforeModel.releaseFromEdit();
        }
        if (afterModel == null) return;
        try {}
        catch (Exception exception) {
            return;
        }
        afterModel.releaseFromEdit();
    }

    private static IFile getFile(String name) {
        IFile file = fProject.getFile(name);
        FormattingTests.assertTrue((String)("Test file " + file + " can not be found"), (boolean)file.exists());
        return file;
    }

    private IStructuredModel getModelForEdit(String path) {
        IFile file = FormattingTests.getFile(path);
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            model = modelManager.getModelForEdit(file);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        return model;
    }

    private static ISourceViewer getConfiguredViewer(IDocument document, SourceViewerConfiguration configuration) {
        StructuredTextViewer viewer = null;
        FormattingTests.assertNotNull((String)"Could not get current display to run test with.", (Object)Display.getCurrent());
        Shell shell = null;
        shell = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : new Shell(Display.getCurrent());
        Composite parent = new Composite((Composite)shell, 0);
        viewer = new StructuredTextViewer(parent, null, null, false, 0);
        viewer.setDocument(document);
        viewer.configure(configuration);
        return viewer;
    }

    private static class FormattingTestsSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public FormattingTestsSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            fProject = ProjectUtil.createProject(FormattingTests.PROJECT_NAME, null, new String[]{"org.eclipse.wst.jsdt.core.jsNature"});
            ProjectUtil.copyBundleEntriesIntoWorkspace(FormattingTests.PROJECT_FILES, FormattingTests.PROJECT_NAME);
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
        }

        public void tearDown() throws Exception {
            fProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
        }
    }
}

