/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests;

import java.io.IOException;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.encoding.XMLDocumentLoader;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;
import org.eclipse.wst.xsl.ui.internal.StructuredTextViewerConfigurationXSL;
import org.eclipse.wst.xsl.ui.internal.contentassist.XSLContentAssistProcessor;
import org.eclipse.wst.xsl.ui.tests.AbstractXSLUITest;
import org.junit.After;

public class AbstractSourceViewerTest
extends AbstractXSLUITest {
    protected String projectName = "xsltestfiles";
    protected String fileName = null;
    protected IFile file = null;
    protected IEditorPart textEditorPart = null;
    protected ITextEditor editor = null;
    protected XMLDocumentLoader xmlDocumentLoader = null;
    protected IStructuredDocument document = null;
    protected StructuredTextViewer sourceViewer = null;
    protected IStructuredModel model;
    protected Shell shell = null;
    protected Composite parent = null;

    protected void initializeSourceViewer() {
        if (Display.getCurrent() != null) {
            this.shell = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : new Shell(Display.getCurrent());
            this.parent = new Composite((Composite)this.shell, 0);
            this.sourceViewer = new StructuredTextViewer(this.parent, null, null, false, 0);
        } else {
            Assert.fail((String)"Unable to run the test as a display must be available.");
        }
        this.configureSourceViewer();
    }

    protected void configureSourceViewer() {
        this.sourceViewer.configure((SourceViewerConfiguration)new StructuredTextViewerConfigurationXSL());
        this.sourceViewer.setDocument((IDocument)this.document);
    }

    protected void loadFileForTesting(String xslFilePath) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(xslFilePath));
        if (this.file != null && !this.file.exists()) {
            Assert.fail((String)("Unable to locate " + this.fileName + " stylesheet."));
        }
        this.loadXSLFile();
        this.initializeSourceViewer();
    }

    protected void loadXSLFile() throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        this.model = modelManager.getModelForEdit(this.file);
        this.document = this.model.getStructuredDocument();
    }

    protected ICompletionProposal[] getProposals(int offset) throws Exception {
        return new XSLContentAssistProcessor().computeCompletionProposals((ITextViewer)this.sourceViewer, offset);
    }

    protected ICompletionProposal[] getXMLProposals(int offset) throws Exception {
        return new XMLContentAssistProcessor().computeCompletionProposals((ITextViewer)this.sourceViewer, offset);
    }

    protected ICompletionProposal[] getProposals(int lineNumber, int numberOfCharacters) throws BadLocationException {
        int offset = this.calculateOffset(lineNumber, numberOfCharacters);
        return new XSLContentAssistProcessor().computeCompletionProposals((ITextViewer)this.sourceViewer, offset);
    }

    protected ICompletionProposal[] getXMLProposals(int lineNumber, int numberOfCharacters) throws BadLocationException {
        int offset = this.calculateOffset(lineNumber, numberOfCharacters);
        return new XMLContentAssistProcessor().computeCompletionProposals((ITextViewer)this.sourceViewer, offset);
    }

    protected int calculateOffset(int lineNumber, int columnNumber) throws BadLocationException {
        IDocument document = this.sourceViewer.getDocument();
        int lineOffset = document.getLineOffset(lineNumber);
        int offset = lineOffset + columnNumber;
        return offset;
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.parent.dispose();
        if (this.model != null) {
            this.model.releaseFromEdit();
        }
    }
}

