/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.BidiTransformer;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class BidiTransformerTests
extends TestCase {
    public BidiTransformerTests(String name) {
        super(name);
    }

    public void testNullBidiTransformer_transform() throws Exception {
        BidiTransformerTests.assertEquals((Object)"foo", (Object)BidiTransformer.Null.instance().transform((Object)"foo"));
        BidiTransformerTests.assertNull((Object)BidiTransformer.Null.instance().transform(null));
    }

    public void testNullBidiTransformer_reverseTransform() throws Exception {
        BidiTransformerTests.assertEquals((Object)"foo", (Object)BidiTransformer.Null.instance().reverseTransform((Object)"foo"));
        BidiTransformerTests.assertNull((Object)BidiTransformer.Null.instance().transform(null));
    }

    public void testNullBidiTransformer_toString() throws Exception {
        BidiTransformerTests.assertNotNull((Object)BidiTransformer.Null.instance().toString());
    }

    public void testNullBidiTransformer_serialization() throws Exception {
        BidiTransformer xxx = TestTools.serialize(BidiTransformer.Null.instance());
        BidiTransformerTests.assertSame((Object)BidiTransformer.Null.instance(), (Object)xxx);
    }

    public void testDisabledBidiTransformer_transform() throws Exception {
        boolean exCaught = false;
        try {
            BidiTransformer.Disabled.instance().transform((Object)"foo");
            BidiTransformerTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        BidiTransformerTests.assertTrue((boolean)exCaught);
    }

    public void testDisabledBidiTransformer_reverseTransform() throws Exception {
        boolean exCaught = false;
        try {
            BidiTransformer.Disabled.instance().reverseTransform((Object)"foo");
            BidiTransformerTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        BidiTransformerTests.assertTrue((boolean)exCaught);
    }

    public void testDisabledBidiTransformer_toString() throws Exception {
        BidiTransformerTests.assertNotNull((Object)BidiTransformer.Disabled.instance().toString());
    }

    public void testDisabledBidiTransformer_serialization() throws Exception {
        BidiTransformer xxx = TestTools.serialize(BidiTransformer.Disabled.instance());
        BidiTransformerTests.assertSame((Object)BidiTransformer.Disabled.instance(), (Object)xxx);
    }
}

