/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterators.PeekableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeekableIteratorTests
extends TestCase {
    public PeekableIteratorTests(String name) {
        super(name);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        PeekableIterator<String> stream = this.buildPeekableIterator();
        while (stream.hasNext()) {
            String string = (String)stream.next();
            if (!string.equals("three")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        PeekableIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        PeekableIterator<String> stream = this.buildPeekableIterator();
        String string = null;
        while (stream.hasNext()) {
            string = (String)stream.next();
        }
        try {
            string = (String)stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        PeekableIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testHasNext() {
        int i = 0;
        PeekableIterator<String> stream = this.buildPeekableIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        PeekableIteratorTests.assertEquals((int)6, (int)i);
    }

    public void testHasNextUpcast() {
        int i = 0;
        PeekableIterator<Object> stream = this.buildPeekableIteratorUpcast();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        PeekableIteratorTests.assertEquals((int)6, (int)i);
    }

    public void testNext() {
        PeekableIterator<String> stream = this.buildPeekableIterator();
        PeekableIteratorTests.assertEquals((String)"zero", (String)((String)stream.next()));
        PeekableIteratorTests.assertEquals((String)"one", (String)((String)stream.next()));
        PeekableIteratorTests.assertEquals((String)"two", (String)((String)stream.next()));
        PeekableIteratorTests.assertEquals((String)"three", (String)((String)stream.next()));
        PeekableIteratorTests.assertEquals((String)"four", (String)((String)stream.next()));
        PeekableIteratorTests.assertEquals((String)"five", (String)((String)stream.next()));
    }

    public void testNextUpcast() {
        PeekableIterator<Object> stream = this.buildPeekableIteratorUpcast();
        PeekableIteratorTests.assertEquals((Object)"zero", stream.next());
        PeekableIteratorTests.assertEquals((Object)"one", stream.next());
        PeekableIteratorTests.assertEquals((Object)"two", stream.next());
        PeekableIteratorTests.assertEquals((Object)"three", stream.next());
        PeekableIteratorTests.assertEquals((Object)"four", stream.next());
        PeekableIteratorTests.assertEquals((Object)"five", stream.next());
    }

    public void testPeek() {
        Object next = null;
        PeekableIterator<String> stream = this.buildPeekableIterator();
        while (stream.hasNext()) {
            Object peek = stream.peek();
            PeekableIteratorTests.assertTrue((String)"peek and next are prematurely identical", (peek != next ? 1 : 0) != 0);
            next = stream.next();
            PeekableIteratorTests.assertTrue((String)"peek and next are not identical", (peek == next ? 1 : 0) != 0);
        }
    }

    public void testPeekUpcast() {
        Object next = null;
        PeekableIterator<Object> stream = this.buildPeekableIteratorUpcast();
        while (stream.hasNext()) {
            Object peek = stream.peek();
            PeekableIteratorTests.assertTrue((String)"peek and next are prematurely identical", (peek != next ? 1 : 0) != 0);
            next = stream.next();
            PeekableIteratorTests.assertTrue((String)"peek and next are not identical", (peek == next ? 1 : 0) != 0);
        }
    }

    private PeekableIterator<String> buildPeekableIterator() {
        return this.buildPeekableIterator(this.buildNestedIterator());
    }

    private PeekableIterator<Object> buildPeekableIteratorUpcast() {
        return this.buildPeekableIteratorUpcast(this.buildNestedIterator());
    }

    private PeekableIterator<String> buildPeekableIterator(Iterator<String> nestedIterator) {
        return new PeekableIterator(nestedIterator);
    }

    private PeekableIterator<Object> buildPeekableIteratorUpcast(Iterator<String> nestedIterator) {
        return new PeekableIterator(nestedIterator);
    }

    private Iterator<String> buildNestedIterator() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        c.add("four");
        c.add("five");
        return c.iterator();
    }
}

