/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterators;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ReadOnlyListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyListIteratorTests
extends TestCase {
    public ReadOnlyListIteratorTests(String name) {
        super(name);
    }

    public void testHasNextAndHasPrevious() {
        int i = 0;
        ListIterator<String> stream = this.buildReadOnlyListIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        ReadOnlyListIteratorTests.assertEquals((int)this.buildList().size(), (int)i);
        while (stream.hasPrevious()) {
            stream.previous();
            --i;
        }
        ReadOnlyListIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testHasNextAndHasPreviousUpcast() {
        int i = 0;
        ListIterator<Object> stream = this.buildReadOnlyListIteratorUpcast();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        ReadOnlyListIteratorTests.assertEquals((int)this.buildList().size(), (int)i);
        while (stream.hasPrevious()) {
            stream.previous();
            --i;
        }
        ReadOnlyListIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testNextAndPrevious() {
        ListIterator<String> nestedListIterator = this.buildNestedListIterator();
        ListIterator<String> stream = this.buildReadOnlyListIterator();
        while (stream.hasNext()) {
            ReadOnlyListIteratorTests.assertEquals((String)"bogus element", (String)nestedListIterator.next(), (String)stream.next());
        }
        while (stream.hasPrevious()) {
            ReadOnlyListIteratorTests.assertEquals((String)"bogus element", (String)nestedListIterator.previous(), (String)stream.previous());
        }
    }

    public void testNextAndPreviousUpcast() {
        ListIterator<String> nestedListIterator = this.buildNestedListIterator();
        ListIterator<Object> stream = this.buildReadOnlyListIteratorUpcast();
        while (stream.hasNext()) {
            ReadOnlyListIteratorTests.assertEquals((String)"bogus element", (Object)nestedListIterator.next(), (Object)stream.next());
        }
        while (stream.hasPrevious()) {
            ReadOnlyListIteratorTests.assertEquals((String)"bogus element", (Object)nestedListIterator.previous(), (Object)stream.previous());
        }
    }

    public void testNextIndexAndPreviousIndex() {
        ListIterator<String> nestedListIterator = this.buildNestedListIterator();
        ListIterator<String> stream = this.buildReadOnlyListIterator();
        while (stream.hasNext()) {
            ReadOnlyListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.nextIndex(), (int)stream.nextIndex());
            nestedListIterator.next();
            stream.next();
        }
        ReadOnlyListIteratorTests.assertEquals((String)"bogus index", (int)this.buildList().size(), (int)stream.nextIndex());
        while (stream.hasPrevious()) {
            ReadOnlyListIteratorTests.assertEquals((String)"bogus element", (int)nestedListIterator.previousIndex(), (int)stream.previousIndex());
            nestedListIterator.previous();
            stream.previous();
        }
        ReadOnlyListIteratorTests.assertEquals((String)"bogus index", (int)-1, (int)stream.previousIndex());
    }

    public void testNextIndexAndPreviousIndexUpcast() {
        ListIterator<String> nestedListIterator = this.buildNestedListIterator();
        ListIterator<Object> stream = this.buildReadOnlyListIteratorUpcast();
        while (stream.hasNext()) {
            ReadOnlyListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.nextIndex(), (int)stream.nextIndex());
            nestedListIterator.next();
            stream.next();
        }
        ReadOnlyListIteratorTests.assertEquals((String)"bogus index", (int)this.buildList().size(), (int)stream.nextIndex());
        while (stream.hasPrevious()) {
            ReadOnlyListIteratorTests.assertEquals((String)"bogus element", (int)nestedListIterator.previousIndex(), (int)stream.previousIndex());
            nestedListIterator.previous();
            stream.previous();
        }
        ReadOnlyListIteratorTests.assertEquals((String)"bogus index", (int)-1, (int)stream.previousIndex());
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        ListIterator<String> stream = this.buildReadOnlyListIterator();
        String string = null;
        while (stream.hasNext()) {
            string = stream.next();
        }
        try {
            string = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ReadOnlyListIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testRemove() {
        boolean exCaught = false;
        ListIterator<String> stream = this.buildReadOnlyListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ReadOnlyListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testSet() {
        boolean exCaught = false;
        ListIterator<String> stream = this.buildReadOnlyListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.set("bogus");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ReadOnlyListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testAdd() {
        boolean exCaught = false;
        ListIterator<String> stream = this.buildReadOnlyListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.add("bogus");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ReadOnlyListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    private ListIterator<String> buildReadOnlyListIterator() {
        return this.buildReadOnlyListIterator(this.buildNestedListIterator());
    }

    private ListIterator<Object> buildReadOnlyListIteratorUpcast() {
        return this.buildReadOnlyListIteratorUpcast(this.buildNestedListIterator());
    }

    private ListIterator<String> buildReadOnlyListIterator(ListIterator<String> nestedListIterator) {
        return new ReadOnlyListIterator(nestedListIterator);
    }

    private ListIterator<Object> buildReadOnlyListIteratorUpcast(ListIterator<String> nestedListIterator) {
        return new ReadOnlyListIterator(nestedListIterator);
    }

    private ListIterator<String> buildNestedListIterator() {
        return this.buildList().listIterator();
    }

    private List<String> buildList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("one");
        l.add("two");
        l.add("three");
        l.add("four");
        l.add("five");
        l.add("six");
        l.add("seven");
        l.add("eight");
        return l;
    }
}

