/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionPropertyValueModelAdapterTests
extends TestCase {
    private WritablePropertyValueModel<Boolean> adapter;
    private SimpleCollectionValueModel<String> wrappedCollectionHolder;
    PropertyChangeEvent event;

    public CollectionPropertyValueModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.wrappedCollectionHolder = new SimpleCollectionValueModel();
        this.adapter = new LocalAdapter((CollectionValueModel<String>)this.wrappedCollectionHolder, "666");
        this.event = null;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    private boolean booleanValue() {
        return (Boolean)this.adapter.getValue();
    }

    private Collection<String> wrappedCollection() {
        return CollectionTools.collection((Iterator)this.wrappedCollectionHolder.iterator());
    }

    public void testValue() {
        this.adapter.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
            }
        });
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.booleanValue());
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.wrappedCollection().contains("666"));
        this.wrappedCollectionHolder.add((Object)"111");
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.booleanValue());
        this.wrappedCollectionHolder.add((Object)"222");
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.booleanValue());
        this.wrappedCollectionHolder.add((Object)"666");
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)this.booleanValue());
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)this.wrappedCollection().contains("666"));
        this.wrappedCollectionHolder.remove((Object)"666");
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.booleanValue());
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.wrappedCollection().contains("666"));
        this.wrappedCollectionHolder.add((Object)"666");
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)this.booleanValue());
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)this.wrappedCollection().contains("666"));
        this.wrappedCollectionHolder.clear();
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.booleanValue());
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.wrappedCollection().contains("666"));
    }

    public void testSetValue() {
        this.adapter.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
            }
        });
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.booleanValue());
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.wrappedCollection().contains("666"));
        this.adapter.setValue((Object)Boolean.TRUE);
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)this.booleanValue());
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)this.wrappedCollection().contains("666"));
        this.adapter.setValue((Object)Boolean.FALSE);
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.booleanValue());
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.wrappedCollection().contains("666"));
    }

    public void testEventFiring() {
        this.adapter.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                CollectionPropertyValueModelAdapterTests.this.event = e;
            }
        });
        CollectionPropertyValueModelAdapterTests.assertNull((Object)this.event);
        this.wrappedCollectionHolder.add((Object)"111");
        CollectionPropertyValueModelAdapterTests.assertNull((Object)this.event);
        this.wrappedCollectionHolder.add((Object)"222");
        CollectionPropertyValueModelAdapterTests.assertNull((Object)this.event);
        this.wrappedCollectionHolder.add((Object)"666");
        this.verifyEvent(false, true);
        this.wrappedCollectionHolder.remove((Object)"666");
        this.verifyEvent(true, false);
        this.wrappedCollectionHolder.add((Object)"666");
        this.verifyEvent(false, true);
        this.wrappedCollectionHolder.clear();
        this.verifyEvent(true, false);
    }

    private void verifyEvent(boolean oldValue, boolean newValue) {
        CollectionPropertyValueModelAdapterTests.assertEquals(this.adapter, (Object)this.event.getSource());
        CollectionPropertyValueModelAdapterTests.assertEquals((Object)oldValue, (Object)this.event.getOldValue());
        CollectionPropertyValueModelAdapterTests.assertEquals((Object)newValue, (Object)this.event.getNewValue());
        this.event = null;
    }

    public void testStaleValue() {
        PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
            }
        };
        this.adapter.addPropertyChangeListener("value", listener);
        this.wrappedCollectionHolder.add((Object)"666");
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)this.booleanValue());
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)this.wrappedCollection().contains("666"));
        this.adapter.removePropertyChangeListener("value", listener);
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.booleanValue());
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)this.wrappedCollection().contains("666"));
        this.adapter.addPropertyChangeListener("value", listener);
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)this.booleanValue());
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)this.wrappedCollection().contains("666"));
    }

    public void testHasListeners() {
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyPropertyChangeListeners("value"));
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.wrappedCollectionHolder.hasAnyCollectionChangeListeners("values"));
        ChangeAdapter listener = new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
            }
        };
        this.adapter.addPropertyChangeListener("value", (PropertyChangeListener)listener);
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)((AbstractModel)this.adapter).hasAnyPropertyChangeListeners("value"));
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)this.wrappedCollectionHolder.hasAnyCollectionChangeListeners("values"));
        this.adapter.removePropertyChangeListener("value", (PropertyChangeListener)listener);
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyPropertyChangeListeners("value"));
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.wrappedCollectionHolder.hasAnyCollectionChangeListeners("values"));
        this.adapter.addChangeListener((ChangeListener)listener);
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)((AbstractModel)this.adapter).hasAnyPropertyChangeListeners("value"));
        CollectionPropertyValueModelAdapterTests.assertTrue((boolean)this.wrappedCollectionHolder.hasAnyCollectionChangeListeners("values"));
        this.adapter.removeChangeListener((ChangeListener)listener);
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyPropertyChangeListeners("value"));
        CollectionPropertyValueModelAdapterTests.assertFalse((boolean)this.wrappedCollectionHolder.hasAnyCollectionChangeListeners("values"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LocalAdapter
    extends CollectionPropertyValueModelAdapter<Boolean>
    implements WritablePropertyValueModel<Boolean> {
        private String item;

        LocalAdapter(CollectionValueModel<String> collectionHolder, String item) {
            super(collectionHolder);
            this.item = item;
        }

        public Boolean getValue() {
            Boolean result = (Boolean)super.getValue();
            return result == null ? Boolean.FALSE : result;
        }

        public void setValue(Boolean value) {
            if (this.booleanValue()) {
                if (!this.booleanValueOf(value)) {
                    ((SimpleCollectionValueModel)this.collectionModel).remove((Object)this.item);
                }
            } else if (this.booleanValueOf(value)) {
                ((SimpleCollectionValueModel)this.collectionModel).add((Object)this.item);
            }
        }

        protected Boolean buildValue() {
            return CollectionTools.contains((Iterator)this.collectionModel.iterator(), (Object)this.item);
        }

        private boolean booleanValue() {
            return this.booleanValueOf(this.value);
        }

        private boolean booleanValueOf(Object b) {
            return b == null ? false : (Boolean)b;
        }
    }
}

