/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.iterators.ChainIterator;
import org.eclipse.jpt.common.utility.internal.iterators.ReadOnlyIterator;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.common.utility.internal.iterators.TreeIterator;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TreeAspectAdapter;
import org.eclipse.jpt.common.utility.model.event.TreeAddEvent;
import org.eclipse.jpt.common.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.common.utility.model.event.TreeClearEvent;
import org.eclipse.jpt.common.utility.model.event.TreeEvent;
import org.eclipse.jpt.common.utility.model.event.TreeRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.TreeChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeAspectAdapterTests
extends TestCase {
    private TestSubject subject1;
    private WritablePropertyValueModel<TestSubject> subjectHolder1;
    private TreeAspectAdapter<TestSubject, List<TestNode>> aa1;
    private TreeEvent event1;
    private TreeChangeListener listener1;
    private TestSubject subject2;

    public TreeAspectAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.subject1 = new TestSubject();
        TestNode root = this.subject1.getRootNameNode();
        TestNode node = this.subject1.addName(root, "name 1.1");
        this.subject1.addName(node, "name 1.1.1");
        this.subject1.addName(node, "name 1.1.2");
        node = this.subject1.addName(root, "name 1.2");
        this.subject1.addName(node, "name 1.2.1");
        node = this.subject1.addName(root, "name 1.3");
        root = this.subject1.getRootDescriptionNode();
        node = this.subject1.addDescription(root, "description 1.1");
        this.subject1.addDescription(node, "description 1.1.1");
        this.subject1.addDescription(node, "description 1.1.2");
        node = this.subject1.addDescription(root, "description 1.2");
        this.subject1.addDescription(node, "description 1.2.1");
        node = this.subject1.addDescription(root, "description 1.3");
        this.subjectHolder1 = new SimplePropertyValueModel((Object)this.subject1);
        this.aa1 = this.buildAspectAdapter((PropertyValueModel<TestSubject>)this.subjectHolder1);
        this.listener1 = this.buildValueChangeListener1();
        this.aa1.addTreeChangeListener("nodes", this.listener1);
        this.event1 = null;
        this.subject2 = new TestSubject();
        root = this.subject2.getRootNameNode();
        node = this.subject2.addName(root, "name 2.1");
        this.subject2.addName(node, "name 2.1.1");
        this.subject2.addName(node, "name 2.1.2");
        node = this.subject2.addName(root, "name 2.2");
        this.subject2.addName(node, "name 2.2.1");
        node = this.subject2.addName(root, "name 2.3");
        root = this.subject2.getRootDescriptionNode();
        node = this.subject2.addDescription(root, "description 2.1");
        this.subject2.addDescription(node, "description 2.1.1");
        this.subject2.addDescription(node, "description 2.1.2");
        node = this.subject2.addDescription(root, "description 2.2");
        this.subject2.addDescription(node, "description 2.2.1");
        node = this.subject2.addDescription(root, "description 2.3");
    }

    private TreeAspectAdapter<TestSubject, List<TestNode>> buildAspectAdapter(PropertyValueModel<TestSubject> subjectHolder) {
        return new TreeAspectAdapter<TestSubject, List<TestNode>>(subjectHolder, new String[]{"names"}){

            protected Iterator<List<TestNode>> nodes_() {
                if (this.treeNames[0] == "names") {
                    return ((TestSubject)((Object)this.subject)).namePaths();
                }
                if (this.treeNames[0] == "descriptions") {
                    return ((TestSubject)((Object)this.subject)).descriptionPaths();
                }
                throw new IllegalStateException("invalid aspect name: " + this.treeNames[0]);
            }
        };
    }

    private ChangeListener buildValueChangeListener1() {
        return new ChangeAdapter(){

            public void nodeAdded(TreeAddEvent e) {
                TreeAspectAdapterTests.this.value1Changed((TreeEvent)e);
            }

            public void nodeRemoved(TreeRemoveEvent e) {
                TreeAspectAdapterTests.this.value1Changed((TreeEvent)e);
            }

            public void treeCleared(TreeClearEvent e) {
                TreeAspectAdapterTests.this.value1Changed((TreeEvent)e);
            }

            public void treeChanged(TreeChangeEvent e) {
                TreeAspectAdapterTests.this.value1Changed((TreeEvent)e);
            }
        };
    }

    void value1Changed(TreeEvent e) {
        this.event1 = e;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testSubjectHolder() {
        TreeAspectAdapterTests.assertNull((Object)this.event1);
        this.subjectHolder1.setValue((Object)this.subject2);
        TreeAspectAdapterTests.assertNotNull((Object)this.event1);
        TreeAspectAdapterTests.assertEquals(this.aa1, (Object)this.event1.getSource());
        TreeAspectAdapterTests.assertEquals((String)"nodes", (String)this.event1.getTreeName());
        this.event1 = null;
        this.subjectHolder1.setValue(null);
        TreeAspectAdapterTests.assertNotNull((Object)this.event1);
        TreeAspectAdapterTests.assertEquals(this.aa1, (Object)this.event1.getSource());
        TreeAspectAdapterTests.assertEquals((String)"nodes", (String)this.event1.getTreeName());
        this.event1 = null;
        this.subjectHolder1.setValue((Object)this.subject1);
        TreeAspectAdapterTests.assertNotNull((Object)this.event1);
        TreeAspectAdapterTests.assertEquals(this.aa1, (Object)this.event1.getSource());
        TreeAspectAdapterTests.assertEquals((String)"nodes", (String)this.event1.getTreeName());
    }

    public void testTreeStructureChange() {
        TreeAspectAdapterTests.assertNull((Object)this.event1);
        this.subject1.addTwoNames(this.subject1.getRootNameNode(), "jam", "jaz");
        TreeAspectAdapterTests.assertNotNull((Object)this.event1);
        TreeAspectAdapterTests.assertEquals(this.aa1, (Object)this.event1.getSource());
        TreeAspectAdapterTests.assertEquals((String)"nodes", (String)this.event1.getTreeName());
        TreeAspectAdapterTests.assertTrue((boolean)this.subject1.containsNameNode("jam"));
        TreeAspectAdapterTests.assertTrue((boolean)this.subject1.containsNameNode("jaz"));
    }

    public void testNodes() {
        TreeAspectAdapterTests.assertEquals(this.convertToNames(this.subject1.namePaths()), this.convertToNames(this.aa1.nodes()));
    }

    private Collection<String> convertToNames(Iterator<List<TestNode>> namePaths) {
        HashBag result = new HashBag();
        while (namePaths.hasNext()) {
            List<TestNode> path = namePaths.next();
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            int i = 0;
            while (i < path.size()) {
                sb.append(path.get(i).getText());
                if (i < path.size() - 1) {
                    sb.append(':');
                }
                ++i;
            }
            sb.append(']');
            result.add(sb.toString());
        }
        return result;
    }

    public void testHasListeners() {
        TreeAspectAdapterTests.assertTrue((boolean)this.aa1.hasAnyTreeChangeListeners("nodes"));
        TreeAspectAdapterTests.assertTrue((boolean)this.subject1.hasAnyTreeChangeListeners("names"));
        this.aa1.removeTreeChangeListener("nodes", this.listener1);
        TreeAspectAdapterTests.assertFalse((boolean)this.subject1.hasAnyTreeChangeListeners("names"));
        TreeAspectAdapterTests.assertFalse((boolean)this.aa1.hasAnyTreeChangeListeners("nodes"));
        ChangeListener listener2 = this.buildValueChangeListener1();
        this.aa1.addChangeListener(listener2);
        TreeAspectAdapterTests.assertTrue((boolean)this.aa1.hasAnyTreeChangeListeners("nodes"));
        TreeAspectAdapterTests.assertTrue((boolean)this.subject1.hasAnyTreeChangeListeners("names"));
        this.aa1.removeChangeListener(listener2);
        TreeAspectAdapterTests.assertFalse((boolean)this.subject1.hasAnyTreeChangeListeners("names"));
        TreeAspectAdapterTests.assertFalse((boolean)this.aa1.hasAnyTreeChangeListeners("nodes"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestNode {
        private final String text;
        private TestNode parent;
        private final Collection<TestNode> children;

        public TestNode(String text) {
            this.text = text;
            this.children = new HashBag();
        }

        public String getText() {
            return this.text;
        }

        public TestNode getParent() {
            return this.parent;
        }

        private void setParent(TestNode parent) {
            this.parent = parent;
        }

        public Iterator<TestNode> children() {
            return new ReadOnlyIterator(this.children);
        }

        public void addChild(TestNode child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TestNode child) {
            this.children.remove(child);
        }

        public List<TestNode> getPath() {
            return CollectionTools.reverseList(this.buildAntiPath());
        }

        private Iterator<TestNode> buildAntiPath() {
            return new ChainIterator<TestNode>(this){

                protected TestNode nextLink(TestNode currentLink) {
                    return currentLink.getParent();
                }
            };
        }

        public String toString() {
            return "TestNode(" + this.text + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestSubject
    extends AbstractModel {
        private TestNode rootNameNode;
        public static final String NAMES_TREE = "names";
        private TestNode rootDescriptionNode;
        public static final String DESCRIPTIONS_TREE = "descriptions";

        public TestSubject() {
            this.rootNameNode = new TestNode("root name");
            this.rootDescriptionNode = new TestNode("root description");
        }

        public TestNode getRootNameNode() {
            return this.rootNameNode;
        }

        public Iterator<TestNode> nameNodes() {
            return new TreeIterator<TestNode>(this.rootNameNode){

                public Iterator<TestNode> children(TestNode next) {
                    return next.children();
                }
            };
        }

        public Iterator<List<TestNode>> namePaths() {
            return new TransformationIterator<TestNode, List<TestNode>>(this.nameNodes()){

                protected List<TestNode> transform(TestNode next) {
                    return next.getPath();
                }
            };
        }

        public TestNode addName(TestNode parent, String name) {
            TestNode child = new TestNode(name);
            parent.addChild(child);
            this.fireNodeAdded(NAMES_TREE, child.getPath());
            return child;
        }

        public void addTwoNames(TestNode parent, String name1, String name2) {
            parent.addChild(new TestNode(name1));
            parent.addChild(new TestNode(name2));
            this.fireTreeChanged(NAMES_TREE, parent.getPath());
        }

        public void removeNameNode(TestNode nameNode) {
            nameNode.getParent().removeChild(nameNode);
            this.fireNodeRemoved(NAMES_TREE, nameNode.getPath());
        }

        public boolean containsNameNode(String name) {
            return this.nameNode(name) != null;
        }

        public TestNode nameNode(String name) {
            Iterator<TestNode> stream = this.nameNodes();
            while (stream.hasNext()) {
                TestNode node = stream.next();
                if (!node.getText().equals(name)) continue;
                return node;
            }
            return null;
        }

        public TestNode getRootDescriptionNode() {
            return this.rootDescriptionNode;
        }

        public Iterator<TestNode> descriptionNodes() {
            return new TreeIterator<TestNode>(this.rootDescriptionNode){

                public Iterator<TestNode> children(TestNode next) {
                    return next.children();
                }
            };
        }

        public Iterator<List<TestNode>> descriptionPaths() {
            return new TransformationIterator<TestNode, List<TestNode>>(this.descriptionNodes()){

                protected List<TestNode> transform(TestNode next) {
                    return next.getPath();
                }
            };
        }

        public TestNode addDescription(TestNode parent, String description) {
            TestNode child = new TestNode(description);
            parent.addChild(child);
            this.fireNodeAdded(DESCRIPTIONS_TREE, child.getPath());
            return child;
        }

        public void removeDescriptionNode(TestNode descriptionNode) {
            descriptionNode.getParent().removeChild(descriptionNode);
            this.fireNodeRemoved(DESCRIPTIONS_TREE, descriptionNode.getPath());
        }

        public boolean containsDescriptionNode(String name) {
            Iterator<TestNode> stream = this.descriptionNodes();
            while (stream.hasNext()) {
                TestNode node = stream.next();
                if (!node.getText().equals(name)) continue;
                return true;
            }
            return false;
        }
    }
}

