/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ValueCollectionAdapter;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class ValueCollectionAdapterTests
extends TestCase {
    private Junk junk;
    private SimplePropertyValueModel<Junk> junkHolder;
    private ValueCollectionAdapter<Junk> junkHolder2;

    public ValueCollectionAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.junk = new Junk("foo");
        this.junkHolder = new SimplePropertyValueModel((Object)this.junk);
        this.junkHolder2 = new ValueCollectionAdapter(this.junkHolder, new String[]{"stuff"});
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testWrappedPVM() {
        Junk junk2 = new Junk("bar");
        LocalListener l = new LocalListener(this.junkHolder2, (Object)this.junk, (Object)junk2);
        this.junkHolder2.addChangeListener((ChangeListener)l);
        this.junkHolder.setValue((Object)junk2);
        ValueCollectionAdapterTests.assertTrue((boolean)l.eventReceived());
    }

    public void testHasPropertyChangeListeners() throws Exception {
        ValueCollectionAdapterTests.assertFalse((boolean)this.junkHolder.hasAnyPropertyChangeListeners("value"));
        ValueCollectionAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyPropertyChangeListeners("value"));
        LocalListener l = new LocalListener(this.junkHolder2, null, (Object)this.junk);
        this.junkHolder2.addChangeListener((ChangeListener)l);
        ValueCollectionAdapterTests.assertTrue((boolean)this.junkHolder.hasAnyPropertyChangeListeners("value"));
        ValueCollectionAdapterTests.assertTrue((boolean)this.junkHolder2.hasAnyPropertyChangeListeners("value"));
        this.junkHolder2.removeChangeListener((ChangeListener)l);
        ValueCollectionAdapterTests.assertFalse((boolean)this.junkHolder.hasAnyPropertyChangeListeners("value"));
        ValueCollectionAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyPropertyChangeListeners("value"));
    }

    public void testHasStateChangeListeners() throws Exception {
        ValueCollectionAdapterTests.assertFalse((boolean)this.junk.hasAnyCollectionChangeListeners("stuff"));
        ValueCollectionAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyStateChangeListeners());
        LocalListener l = new LocalListener(this.junkHolder2, null, (Object)this.junk);
        this.junkHolder2.addStateChangeListener((StateChangeListener)l);
        ValueCollectionAdapterTests.assertTrue((boolean)this.junk.hasAnyCollectionChangeListeners("stuff"));
        ValueCollectionAdapterTests.assertTrue((boolean)this.junkHolder2.hasAnyStateChangeListeners());
        this.junkHolder2.removeStateChangeListener((StateChangeListener)l);
        ValueCollectionAdapterTests.assertFalse((boolean)this.junk.hasAnyCollectionChangeListeners("stuff"));
        ValueCollectionAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyStateChangeListeners());
    }

    public void testCollectionAdd() {
        LocalListener l = new LocalListener(this.junkHolder2);
        this.junkHolder2.addStateChangeListener((StateChangeListener)l);
        this.junk.addStuff("bar");
        ValueCollectionAdapterTests.assertTrue((boolean)l.eventReceived());
    }

    public void testCollectionRemove() {
        LocalListener l = new LocalListener(this.junkHolder2);
        this.junkHolder2.addStateChangeListener((StateChangeListener)l);
        this.junk.removeStuff("foo");
        ValueCollectionAdapterTests.assertTrue((boolean)l.eventReceived());
    }

    private class Junk
    extends AbstractModel {
        private Collection<String> stuff = new ArrayList<String>();
        public static final String STUFF_COLLECTION = "stuff";

        public Junk(String stuffItem) {
            this.stuff.add(stuffItem);
        }

        public void addStuff(String stuffItem) {
            this.addItemToCollection(stuffItem, this.stuff, STUFF_COLLECTION);
        }

        public void removeStuff(String stuffItem) {
            this.removeItemFromCollection(stuffItem, this.stuff, STUFF_COLLECTION);
        }

        public String toString() {
            return "Junk(" + this.stuff + ")";
        }
    }

    class LocalListener
    extends ChangeAdapter {
        private boolean eventReceived = false;
        private final Object source;
        private final Object oldValue;
        private final Object newValue;

        LocalListener(Object source) {
            this(source, null, null);
        }

        LocalListener(Object source, Object oldValue, Object newValue) {
            this.source = source;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public void propertyChanged(PropertyChangeEvent e) {
            this.eventReceived = true;
            ValueCollectionAdapterTests.assertEquals((Object)this.source, (Object)e.getSource());
            ValueCollectionAdapterTests.assertEquals((Object)this.oldValue, (Object)e.getOldValue());
            ValueCollectionAdapterTests.assertEquals((Object)this.newValue, (Object)e.getNewValue());
            ValueCollectionAdapterTests.assertEquals((String)"value", (String)e.getPropertyName());
        }

        public void stateChanged(StateChangeEvent e) {
            this.eventReceived = true;
            ValueCollectionAdapterTests.assertEquals((Object)this.source, (Object)e.getSource());
        }

        boolean eventReceived() {
            return this.eventReceived;
        }
    }
}

