/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value.swing;

import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class ObjectListSelectionModelTests
extends TestCase {
    private DefaultListModel listModel;
    private ObjectListSelectionModel selectionModel;

    public ObjectListSelectionModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.listModel = this.buildListModel();
        this.selectionModel = this.buildSelectionModel(this.listModel);
    }

    private DefaultListModel buildListModel() {
        DefaultListModel<String> lm = new DefaultListModel<String>();
        lm.addElement("foo");
        lm.addElement("bar");
        lm.addElement("baz");
        return lm;
    }

    private ObjectListSelectionModel buildSelectionModel(ListModel lm) {
        return new ObjectListSelectionModel(lm);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testListDataListener() {
        this.selectionModel.addListSelectionListener(this.buildListSelectionListener());
        this.selectionModel.setSelectionInterval(0, 0);
        ObjectListSelectionModelTests.assertEquals((Object)"foo", (Object)this.selectionModel.selectedValue());
        this.listModel.set(0, "jar");
        ObjectListSelectionModelTests.assertEquals((Object)"jar", (Object)this.selectionModel.selectedValue());
    }

    public void testGetSelectedValue() {
        this.selectionModel.setSelectionInterval(0, 0);
        ObjectListSelectionModelTests.assertEquals((Object)"foo", (Object)this.selectionModel.selectedValue());
    }

    public void testGetSelectedValues() {
        this.selectionModel.setSelectionInterval(0, 0);
        this.selectionModel.addSelectionInterval(2, 2);
        ObjectListSelectionModelTests.assertEquals((int)2, (int)this.selectionModel.selectedValues().length);
        ObjectListSelectionModelTests.assertTrue((boolean)ArrayTools.contains((Object[])this.selectionModel.selectedValues(), (Object)"foo"));
        ObjectListSelectionModelTests.assertTrue((boolean)ArrayTools.contains((Object[])this.selectionModel.selectedValues(), (Object)"baz"));
    }

    public void testSetSelectedValue() {
        this.selectionModel.setSelectedValue((Object)"foo");
        ObjectListSelectionModelTests.assertEquals((int)0, (int)this.selectionModel.getMinSelectionIndex());
        ObjectListSelectionModelTests.assertEquals((int)0, (int)this.selectionModel.getMaxSelectionIndex());
    }

    public void testSetSelectedValues() {
        this.selectionModel.setSelectedValues(new Object[]{"foo", "baz"});
        ObjectListSelectionModelTests.assertEquals((int)0, (int)this.selectionModel.getMinSelectionIndex());
        ObjectListSelectionModelTests.assertEquals((int)2, (int)this.selectionModel.getMaxSelectionIndex());
    }

    public void testAddSelectedValue() {
        this.listModel.addElement("joo");
        this.listModel.addElement("jar");
        this.listModel.addElement("jaz");
        this.selectionModel.setSelectedValue((Object)"foo");
        this.selectionModel.addSelectedValue((Object)"jaz");
        ObjectListSelectionModelTests.assertEquals((int)0, (int)this.selectionModel.getMinSelectionIndex());
        ObjectListSelectionModelTests.assertEquals((int)5, (int)this.selectionModel.getMaxSelectionIndex());
        ObjectListSelectionModelTests.assertTrue((boolean)this.selectionModel.isSelectedIndex(0));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(1));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(2));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(3));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(4));
        ObjectListSelectionModelTests.assertTrue((boolean)this.selectionModel.isSelectedIndex(5));
    }

    public void testAddSelectedValues() {
        this.listModel.addElement("joo");
        this.listModel.addElement("jar");
        this.listModel.addElement("jaz");
        this.selectionModel.setSelectedValue((Object)"foo");
        this.selectionModel.addSelectedValues(new Object[]{"bar", "jar"});
        ObjectListSelectionModelTests.assertEquals((int)0, (int)this.selectionModel.getMinSelectionIndex());
        ObjectListSelectionModelTests.assertEquals((int)4, (int)this.selectionModel.getMaxSelectionIndex());
        ObjectListSelectionModelTests.assertTrue((boolean)this.selectionModel.isSelectedIndex(0));
        ObjectListSelectionModelTests.assertTrue((boolean)this.selectionModel.isSelectedIndex(1));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(2));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(3));
        ObjectListSelectionModelTests.assertTrue((boolean)this.selectionModel.isSelectedIndex(4));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(5));
    }

    public void testRemoveSelectedValue() {
        this.listModel.addElement("joo");
        this.listModel.addElement("jar");
        this.listModel.addElement("jaz");
        this.selectionModel.setSelectedValues(new Object[]{"foo", "baz", "jar"});
        this.selectionModel.removeSelectedValue((Object)"jar");
        ObjectListSelectionModelTests.assertEquals((int)0, (int)this.selectionModel.getMinSelectionIndex());
        ObjectListSelectionModelTests.assertEquals((int)2, (int)this.selectionModel.getMaxSelectionIndex());
        ObjectListSelectionModelTests.assertTrue((boolean)this.selectionModel.isSelectedIndex(0));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(1));
        ObjectListSelectionModelTests.assertTrue((boolean)this.selectionModel.isSelectedIndex(2));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(3));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(4));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(5));
    }

    public void testRemoveSelectedValues() {
        this.listModel.addElement("joo");
        this.listModel.addElement("jar");
        this.listModel.addElement("jaz");
        this.selectionModel.setSelectedValues(new Object[]{"foo", "baz", "joo", "jar"});
        this.selectionModel.removeSelectedValues(new Object[]{"foo", "joo"});
        ObjectListSelectionModelTests.assertEquals((int)2, (int)this.selectionModel.getMinSelectionIndex());
        ObjectListSelectionModelTests.assertEquals((int)4, (int)this.selectionModel.getMaxSelectionIndex());
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(0));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(1));
        ObjectListSelectionModelTests.assertTrue((boolean)this.selectionModel.isSelectedIndex(2));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(3));
        ObjectListSelectionModelTests.assertTrue((boolean)this.selectionModel.isSelectedIndex(4));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.isSelectedIndex(5));
    }

    public void testGetAnchorSelectedValue() {
        this.selectionModel.setAnchorSelectionIndex(1);
        ObjectListSelectionModelTests.assertEquals((Object)"bar", (Object)this.selectionModel.getAnchorSelectedValue());
    }

    public void testGetLeadSelectedValue() {
        this.selectionModel.setSelectedValue((Object)"bar");
        ObjectListSelectionModelTests.assertEquals((Object)"bar", (Object)this.selectionModel.getLeadSelectedValue());
        this.selectionModel.setSelectedValues(new Object[]{"foo", "baz"});
        ObjectListSelectionModelTests.assertEquals((Object)"baz", (Object)this.selectionModel.getLeadSelectedValue());
    }

    public void testGetMinMaxSelectedValue() {
        this.listModel.addElement("joo");
        this.listModel.addElement("jar");
        this.listModel.addElement("jaz");
        this.selectionModel.setSelectedValue((Object)"foo");
        this.selectionModel.addSelectedValues(new Object[]{"bar", "jar"});
        ObjectListSelectionModelTests.assertEquals((Object)"foo", (Object)this.selectionModel.getMinSelectedValue());
        ObjectListSelectionModelTests.assertEquals((Object)"jar", (Object)this.selectionModel.getMaxSelectedValue());
    }

    public void testValueIsSelected() {
        this.listModel.addElement("joo");
        this.listModel.addElement("jar");
        this.listModel.addElement("jaz");
        this.selectionModel.setSelectedValue((Object)"foo");
        this.selectionModel.addSelectedValues(new Object[]{"bar", "jar"});
        ObjectListSelectionModelTests.assertTrue((boolean)this.selectionModel.valueIsSelected((Object)"foo"));
        ObjectListSelectionModelTests.assertTrue((boolean)this.selectionModel.valueIsSelected((Object)"bar"));
        ObjectListSelectionModelTests.assertTrue((boolean)this.selectionModel.valueIsSelected((Object)"jar"));
        ObjectListSelectionModelTests.assertFalse((boolean)this.selectionModel.valueIsSelected((Object)"baz"));
    }

    public void testHasListeners() throws Exception {
        ListSelectionListener listener = this.buildListSelectionListener();
        ObjectListSelectionModelTests.assertEquals((int)0, (int)this.listModel.getListDataListeners().length);
        this.selectionModel.addListSelectionListener(listener);
        ObjectListSelectionModelTests.assertEquals((int)1, (int)this.listModel.getListDataListeners().length);
        this.selectionModel.removeListSelectionListener(listener);
        ObjectListSelectionModelTests.assertEquals((int)0, (int)this.listModel.getListDataListeners().length);
    }

    private ListSelectionListener buildListSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
            }
        };
    }
}

