/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.BaseWriteTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteReferencedBeanTestCase
extends BaseWriteTestCase {
    private static final String REFERENCED_BEAN = "referenced-bean";
    private static final String REFERENCED_BEAN_NAME = CommonStructuresUtil.createPreficedString("referenced-bean", "name");
    private static final String REFERENCED_BEAN_CLASS = CommonStructuresUtil.createPreficedString("referenced-bean", "class");

    public WriteReferencedBeanTestCase(String name) {
        super(name);
    }

    public void testWriteReferencedBeanToFileTwo() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteReferencedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            ReferencedBeanType referencedBean = facesConfigFactory.createReferencedBeanType();
            referencedBean.getDescription().add((Object)CommonStructuresUtil.createDescription(REFERENCED_BEAN));
            referencedBean.getDisplayName().add((Object)CommonStructuresUtil.createDisplayName(REFERENCED_BEAN));
            referencedBean.getIcon().add((Object)CommonStructuresUtil.createIcon(REFERENCED_BEAN));
            ReferencedBeanNameType referencedBeanNameType = facesConfigFactory.createReferencedBeanNameType();
            referencedBeanNameType.setTextContent(REFERENCED_BEAN_NAME);
            referencedBeanNameType.setId(CommonStructuresUtil.createPreficedString(REFERENCED_BEAN_NAME, "id"));
            referencedBean.setReferencedBeanName(referencedBeanNameType);
            ReferencedBeanClassType referencedBeanClassType = facesConfigFactory.createReferencedBeanClassType();
            referencedBeanClassType.setTextContent(REFERENCED_BEAN_CLASS);
            referencedBeanClassType.setId(CommonStructuresUtil.createPreficedString(REFERENCED_BEAN_CLASS, "id"));
            referencedBean.setReferencedBeanClass(referencedBeanClassType);
            referencedBean.setId(CommonStructuresUtil.createPreficedString(REFERENCED_BEAN, "id"));
            edit.getFacesConfig().getReferencedBean().add((Object)referencedBean);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteReferencedBeanTestCase.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteReferencedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            WriteReferencedBeanTestCase.assertEquals((int)1, (int)edit.getFacesConfig().getReferencedBean().size());
            ReferencedBeanType referencedBean = (ReferencedBeanType)edit.getFacesConfig().getReferencedBean().get(0);
            CommonStructuresUtil.assertMatchesDescription(REFERENCED_BEAN, (DescriptionType)referencedBean.getDescription().get(0));
            CommonStructuresUtil.assertMatchesDisplayName(REFERENCED_BEAN, (DisplayNameType)referencedBean.getDisplayName().get(0));
            CommonStructuresUtil.assertMatchesIcon(REFERENCED_BEAN, (IconType)referencedBean.getIcon().get(0));
            ReferencedBeanNameType referencedBeanNameType = referencedBean.getReferencedBeanName();
            WriteReferencedBeanTestCase.assertEquals((String)REFERENCED_BEAN_NAME, (String)referencedBeanNameType.getTextContent());
            WriteReferencedBeanTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(REFERENCED_BEAN_NAME, "id"), (String)referencedBeanNameType.getId());
            ReferencedBeanClassType referencedBeanClassType = referencedBean.getReferencedBeanClass();
            WriteReferencedBeanTestCase.assertEquals((String)REFERENCED_BEAN_CLASS, (String)referencedBeanClassType.getTextContent());
            WriteReferencedBeanTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(REFERENCED_BEAN_CLASS, "id"), (String)referencedBeanClassType.getId());
            WriteReferencedBeanTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(REFERENCED_BEAN, "id"), (String)referencedBean.getId());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

