/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.JptJpaEclipseLinkCoreContextModelTests;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.JptJpaEclipselinkCoreResourceModelTests;

public class JptJpaEclipseLinkCoreTests {
    private static final String JPA_JAR_PROPERTY = "org.eclipse.jpt.jpa.jar";
    private static final String ECLIPSELINK_JAR_PROPERTY = "org.eclipse.jpt.eclipselink.jar";

    public static Test suite() {
        TestSuite suite = new TestSuite(JptJpaEclipseLinkCoreTests.class.getPackage().getName());
        suite.addTest(JptJpaEclipselinkCoreResourceModelTests.suite());
        suite.addTest(JptJpaEclipseLinkCoreContextModelTests.suite());
        return suite;
    }

    public static boolean requiredJarsExists() {
        return JptJpaEclipseLinkCoreTests.jpaJarPropertyExists() && JptJpaEclipseLinkCoreTests.jpaJarFileExists() && JptJpaEclipseLinkCoreTests.eclipselinkJarPropertyExists() && JptJpaEclipseLinkCoreTests.eclipselinkJarFileExists();
    }

    public static boolean jpaJarPropertyExists() {
        return JptJpaEclipseLinkCoreTests.getSystemProperty(JPA_JAR_PROPERTY) != null;
    }

    public static boolean jpaJarFileExists() {
        return new File(JptJpaEclipseLinkCoreTests.getSystemProperty(JPA_JAR_PROPERTY)).exists();
    }

    public static boolean eclipselinkJarPropertyExists() {
        return JptJpaEclipseLinkCoreTests.getSystemProperty(ECLIPSELINK_JAR_PROPERTY) != null;
    }

    public static boolean eclipselinkJarFileExists() {
        return new File(JptJpaEclipseLinkCoreTests.getSystemProperty(ECLIPSELINK_JAR_PROPERTY)).exists();
    }

    public static String buildMissingJarErrorMessage() {
        if (!JptJpaEclipseLinkCoreTests.jpaJarPropertyExists()) {
            return JptJpaEclipseLinkCoreTests.errorMissingProperty(JPA_JAR_PROPERTY);
        }
        if (!JptJpaEclipseLinkCoreTests.jpaJarFileExists()) {
            return JptJpaEclipseLinkCoreTests.errorJarFileDoesNotExist(JptJpaEclipseLinkCoreTests.getSystemProperty(JPA_JAR_PROPERTY));
        }
        if (!JptJpaEclipseLinkCoreTests.eclipselinkJarPropertyExists()) {
            return JptJpaEclipseLinkCoreTests.errorMissingProperty(ECLIPSELINK_JAR_PROPERTY);
        }
        return JptJpaEclipseLinkCoreTests.errorJarFileDoesNotExist(JptJpaEclipseLinkCoreTests.getSystemProperty(ECLIPSELINK_JAR_PROPERTY));
    }

    private static String errorMissingProperty(String propertyName) {
        return "missing Java system property: \"" + propertyName + "\"";
    }

    private static String errorJarFileDoesNotExist(String propertyValue) {
        return "JAR file doesn't exist: \"" + propertyValue + "\"";
    }

    private static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    private JptJpaEclipseLinkCoreTests() {
        throw new UnsupportedOperationException();
    }
}

