/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConvertAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaConvertTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvert() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"class-instance\")").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndTypeConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"class-instance\")").append(CR);
                sb.append("    @TypeConverter");
            }
        });
    }

    public EclipseLinkJavaConvertTests(String name) {
        super(name);
    }

    public void testGetConverterName() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkJavaConvertTests.assertEquals((String)"none", (String)eclipseLinkConvert.getConverterName());
        EclipseLinkJavaConvertTests.assertEquals((String)"none", (String)eclipseLinkConvert.getDefaultConverterName());
        EclipseLinkJavaConvertTests.assertEquals(null, (String)eclipseLinkConvert.getSpecifiedConverterName());
    }

    public void testGetConvertName2() throws Exception {
        this.createTestEntityWithConvert();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkJavaConvertTests.assertEquals((String)"class-instance", (String)eclipseLinkConvert.getConverterName());
    }

    public void testSetSpecifiedConverterName() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        basicMapping.setConverter(EclipseLinkConvert.class);
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkJavaConvertTests.assertEquals(null, (String)eclipseLinkConvert.getSpecifiedConverterName());
        eclipseLinkConvert.setSpecifiedConverterName("foo");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkConvertAnnotation convertAnnotation = (EclipseLinkConvertAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Convert");
        EclipseLinkJavaConvertTests.assertEquals((String)"foo", (String)convertAnnotation.getValue());
        eclipseLinkConvert.setSpecifiedConverterName(null);
        convertAnnotation = (EclipseLinkConvertAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Convert");
        EclipseLinkJavaConvertTests.assertNotNull((Object)convertAnnotation);
        EclipseLinkJavaConvertTests.assertEquals(null, (String)convertAnnotation.getValue());
    }

    public void testGetConverterNameUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkJavaConvertTests.assertNull((Object)basicMapping.getConverter().getType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkConvertAnnotation convert = (EclipseLinkConvertAnnotation)attributeResource.addAnnotation("org.eclipse.persistence.annotations.Convert");
        convert.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaConvertTests.assertEquals(EclipseLinkConvert.class, (Object)basicMapping.getConverter().getType());
        EclipseLinkJavaConvertTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)basicMapping.getConverter()).getConverterName());
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaConvertTests.assertNull((Object)basicMapping.getConverter().getType());
        EclipseLinkJavaConvertTests.assertFalse((boolean)basicMapping.isDefault());
        EclipseLinkJavaConvertTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getMapping());
    }

    public void testGetConverter() throws Exception {
        this.createTestEntityWithConvertAndTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkJavaConvertTests.assertEquals(EclipseLinkTypeConverter.class, (Object)eclipseLinkConvert.getConverter().getType());
    }

    public void testSetConverter() throws Exception {
        this.createTestEntityWithConvert();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkJavaConvertTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        eclipseLinkConvert.setConverter(EclipseLinkTypeConverter.class);
        EclipseLinkJavaConvertTests.assertEquals(EclipseLinkTypeConverter.class, (Object)eclipseLinkConvert.getConverter().getType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaConvertTests.assertNotNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.TypeConverter"));
        eclipseLinkConvert.setConverter(EclipseLinkStructConverter.class);
        EclipseLinkJavaConvertTests.assertEquals(EclipseLinkStructConverter.class, (Object)eclipseLinkConvert.getConverter().getType());
        EclipseLinkJavaConvertTests.assertNotNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.StructConverter"));
        EclipseLinkJavaConvertTests.assertNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.TypeConverter"));
        eclipseLinkConvert.setConverter(null);
        EclipseLinkJavaConvertTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        EclipseLinkJavaConvertTests.assertNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.StructConverter"));
        EclipseLinkJavaConvertTests.assertNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.TypeConverter"));
        eclipseLinkConvert.setConverter(EclipseLinkStructConverter.class);
        EclipseLinkJavaConvertTests.assertEquals(EclipseLinkStructConverter.class, (Object)eclipseLinkConvert.getConverter().getType());
        EclipseLinkJavaConvertTests.assertNotNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.StructConverter"));
        basicMapping.setConverter(null);
        EclipseLinkJavaConvertTests.assertNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.StructConverter"));
        EclipseLinkJavaConvertTests.assertNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Convert"));
    }
}

